/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.Action;
import io.inversion.ApiException;
import io.inversion.Collection;
import io.inversion.Db;
import io.inversion.Endpoint;
import io.inversion.Engine;
import io.inversion.Linker;
import io.inversion.Op;
import io.inversion.Property;
import io.inversion.Relationship;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.Rule;
import io.inversion.Server;
import io.inversion.utils.Path;
import io.inversion.utils.Task;
import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Api {
    protected final transient Logger log = LoggerFactory.getLogger((String)this.getClass().getName());
    protected final List<Server> servers = new ArrayList<Server>();
    protected final List<Db> dbs = new ArrayList<Db>();
    protected final List<Endpoint> endpoints = new ArrayList<Endpoint>();
    protected final List<Action> actions = new ArrayList<Action>();
    protected final List<Collection> collections = new ArrayList<Collection>();
    protected final transient List<ApiListener> listeners = new ArrayList<ApiListener>();
    protected transient Linker linker = new Linker();
    protected transient List<Op> ops = new ArrayList<Op>();
    protected String name = null;
    protected transient String hash = null;
    protected boolean debug = false;
    protected String url = null;
    volatile transient boolean started = false;
    volatile transient boolean starting = false;
    transient long loadTime = 0L;
    transient Engine engine = null;
    protected String version = "1";
    transient List<Runnable> delayedConfig = new ArrayList<Runnable>();

    public Api() {
    }

    public Api(String name) {
        this.withName(name);
    }

    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Api startup(Engine engine) {
        if (this.engine != null && engine != this.engine) {
            this.engine.removeApi(this);
        }
        if (this.started || this.starting) {
            return this;
        }
        this.engine = engine;
        this.starting = true;
        try {
            for (Db db : this.dbs) {
                db.startup(this);
            }
            this.removeExcludes();
            this.configureServers();
            this.configureOps();
            this.started = true;
            for (Runnable r : this.delayedConfig) {
                r.run();
            }
            for (ApiListener listener : this.listeners) {
                try {
                    listener.onStartup(engine, this);
                }
                catch (Exception ex) {
                    this.log.warn("Error notifying api startup listener: " + listener, (Throwable)ex);
                }
            }
            Api api = this;
            return api;
        }
        finally {
            this.starting = false;
        }
    }

    void shutdown(Engine engine) {
        if (!this.started) {
            return;
        }
        this.started = false;
        for (Db db : this.dbs) {
            db.shutdown(this);
        }
        for (ApiListener listener : this.listeners) {
            try {
                listener.onShutdown(engine, this);
            }
            catch (Exception ex) {
                this.log.warn("Error notifying api shutdown listener: " + listener, (Throwable)ex);
            }
        }
    }

    public void withDelayedConfig(Runnable r) {
        if (this.isStarted()) {
            r.run();
        } else {
            this.delayedConfig.add(r);
        }
    }

    public void removeExcludes() {
        for (Db db : this.getDbs()) {
            for (Collection coll : db.getCollections()) {
                if (coll.isExclude()) {
                    db.removeCollection(coll);
                } else {
                    for (Property col : coll.getProperties()) {
                        if (!col.isExclude()) continue;
                        coll.removeProperty(col);
                    }
                }
                for (Relationship rel : coll.getRelationships()) {
                    if (!rel.isExclude()) continue;
                    coll.removeRelationship(rel);
                }
            }
        }
    }

    public String getHash() {
        return this.hash;
    }

    public Api withHash(String hash) {
        this.hash = hash;
        return this;
    }

    public List<Server> getServers() {
        return new ArrayList<Server>(this.servers);
    }

    public Api withServers(String ... urls) {
        for (String url : urls) {
            Server server = new Server().withUrls(url);
            this.withServer(server);
        }
        return this;
    }

    public Api withServer(Server server) {
        if (!this.servers.contains(server)) {
            this.servers.add(server);
        }
        return this;
    }

    public Api withCollection(Collection coll) {
        if (coll.isExclude()) {
            return this;
        }
        if (!this.collections.contains(coll)) {
            this.collections.add(coll);
        }
        return this;
    }

    public List<Collection> getCollections() {
        return Collections.unmodifiableList(this.collections);
    }

    public Collection getCollection(String name) {
        for (Collection coll : this.collections) {
            if (!name.equalsIgnoreCase(coll.getName())) continue;
            return coll;
        }
        return null;
    }

    public Db getDb(String name) {
        if (name == null) {
            return null;
        }
        for (Db db : this.dbs) {
            if (!name.equalsIgnoreCase(db.getName())) continue;
            return db;
        }
        return null;
    }

    public List<Db> getDbs() {
        return new ArrayList<Db>(this.dbs);
    }

    public Api withDbs(Db ... dbs) {
        for (Db db : dbs) {
            this.withDb(db);
        }
        return this;
    }

    public Api withDbs(List<Db> dbs) {
        for (Db db : dbs) {
            this.withDb(db);
        }
        return this;
    }

    public <T extends Db> Api withDb(Db<T> db) {
        if (!this.dbs.contains(db)) {
            this.dbs.add(db);
            for (Collection coll : db.getCollections()) {
                this.withCollection(coll);
            }
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Api withName(String name) {
        this.name = name;
        return this;
    }

    public Api withVersion(String version) {
        this.version = version;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public long getLoadTime() {
        return this.loadTime;
    }

    public void setLoadTime(long loadTime) {
        this.loadTime = loadTime;
    }

    public Endpoint getEndpoint(String name) {
        for (Endpoint ep : this.endpoints) {
            if (!name.equalsIgnoreCase(ep.getName())) continue;
            return ep;
        }
        return null;
    }

    public List<Endpoint> getEndpoints() {
        return new ArrayList<Endpoint>(this.endpoints);
    }

    public Api removeEndpoint(Endpoint ep) {
        this.endpoints.remove(ep);
        return this;
    }

    public Api withEndpoint(Action action1, Action ... actions) {
        Endpoint endpoint = new Endpoint(action1);
        endpoint.withActions(actions);
        this.withEndpoint(endpoint);
        return this;
    }

    public Api withEndpoint(String ruleMatcherSpec, Action ... actions) {
        Endpoint endpoint = new Endpoint(ruleMatcherSpec, actions);
        this.withEndpoint(endpoint);
        return this;
    }

    public Api withEndpoint(Endpoint ... endpoints) {
        for (Endpoint endpoint : endpoints) {
            if (this.endpoints.contains(endpoint)) continue;
            boolean inserted = false;
            for (int i = 0; i < this.endpoints.size(); ++i) {
                if (endpoint.getOrder() >= this.endpoints.get(i).getOrder()) continue;
                this.endpoints.add(i, endpoint);
                inserted = true;
                break;
            }
            if (!inserted) {
                this.endpoints.add(endpoint);
            }
            endpoint.withApi(this);
        }
        return this;
    }

    public Api withRelationship(String parentCollectionName, String parentPropertyName, String childCollectionName, String childPropertyName, String ... childFkProps) {
        this.withDelayedConfig(() -> {
            Collection parentCollection = this.getCollection(parentCollectionName);
            Collection childCollection = this.getCollection(childCollectionName);
            if (parentCollection == null || childCollection == null) {
                throw ApiException.new500InternalServerError("You have specified a relationship between collections that don't exist in the Api after startup during delayed config: '{}' and, '{}'", parentCollectionName, childCollectionName);
            }
            if (parentPropertyName != null) {
                parentCollection.withOneToManyRelationship(parentPropertyName, childCollection, childFkProps);
            }
            if (childPropertyName != null) {
                childCollection.withManyToOneRelationship(childPropertyName, parentCollection, childFkProps);
            }
        });
        return this;
    }

    public Action getAction(String name) {
        for (Action action : this.actions) {
            if (!name.equalsIgnoreCase(action.getName())) continue;
            return action;
        }
        return null;
    }

    public List<Action> getActions() {
        return new ArrayList<Action>(this.actions);
    }

    public synchronized Api withActions(Action ... actions) {
        for (Action action : actions) {
            if (this.actions.contains(action)) continue;
            this.actions.add(action);
        }
        return this;
    }

    public Api withAction(Action action) {
        if (!this.actions.contains(action)) {
            this.actions.add(action);
        }
        return this;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public Api withDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getUrl() {
        return this.url;
    }

    public Api withUrl(String url) {
        this.url = url;
        return this;
    }

    public Linker getLinker() {
        return this.linker;
    }

    public Api withLinker(Linker linker) {
        this.linker = linker;
        return this;
    }

    public Api withApiListener(ApiListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        return this;
    }

    public List<ApiListener> getApiListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public Db matchDb(String method, Path requestPath) {
        Db winnerDb = null;
        Path winnerDbMatch = null;
        for (Db db : this.getDbs()) {
            Path dbMatch = db.match(method, requestPath);
            if (dbMatch == null || winnerDbMatch != null && dbMatch.size() <= winnerDbMatch.size()) continue;
            winnerDb = db;
            winnerDbMatch = dbMatch;
        }
        return winnerDb;
    }

    public List<Op> getOps() {
        return this.ops;
    }

    public Op getOp(String name) {
        for (Op op : this.ops) {
            if (!name.equalsIgnoreCase(op.getName())) continue;
            return op;
        }
        return null;
    }

    void configureServers() {
        System.out.println("\r\n--------------------------------------------");
        System.out.println("SERVERS: ");
        for (Server server : this.servers) {
            for (Server.ServerMatcher sm : server.getServerMatches()) {
                System.out.println("  - " + sm);
            }
        }
    }

    List<Op> configureOps() {
        Map<String, Map<Endpoint, List<List<Path>>>> allPaths = this.generatePaths();
        ArrayList<Op> ops = new ArrayList<Op>();
        for (String method : allPaths.keySet()) {
            Map<Endpoint, List<List<Path>>> epMap = allPaths.get(method);
            for (Endpoint ep : epMap.keySet()) {
                List<List<Path>> groupedPaths = epMap.get(ep);
                for (List<Path> paths : groupedPaths) {
                    Op op = new Op();
                    op.withMethod(method);
                    op.withApi(this);
                    op.withEngine(this.engine);
                    paths.forEach(p -> op.withPath((Path)p));
                    if (!this.matchOp(ep, op)) continue;
                    ops.add(op);
                }
            }
        }
        for (Op op : ops) {
            Task.buildTask(op.getActions(), (String)"configureOp", (Object[])new Object[]{op}).go();
        }
        ops.removeIf(o -> o.getFunction() == null);
        ops.removeIf(o -> o.getPath().toString().indexOf("{_") > 0);
        ops.removeIf(o -> o.getActions().size() == 0);
        ops.removeIf(o -> o.getActions().parallelStream().allMatch(a -> a.isDecoration()));
        ops.removeIf(o -> o.getName() == null);
        Collections.sort(ops);
        this.deduplicateOperationNames(ops);
        System.out.println("\r\n--------------------------------------------");
        ArrayList table = new ArrayList();
        ArrayList header = new ArrayList();
        table.add(header);
        Utils.add(header, (Object[])new Object[]{"METHOD", "PATH", "OPERATION", "ENDPOINT", "COLLECTION", "ACTIONS", "PARAMS"});
        for (Op op : ops) {
            ArrayList row = new ArrayList();
            table.add(row);
            ArrayList actionNames = new ArrayList();
            op.getActions().forEach(a -> actionNames.add(a.getName() != null ? a.getName() : a.getClass().getSimpleName()));
            Utils.add(row, (Object[])new Object[]{op.getMethod(), op.getPath(), op.getName(), op.getEndpoint().getName(), op.getCollection() != null ? op.getCollection().getName() : null, actionNames, op.getParams()});
        }
        System.out.println(Utils.printTable(table));
        System.out.println("\r\n--------------------------------------------");
        this.ops = Collections.unmodifiableList(ops);
        return new ArrayList<Op>(ops);
    }

    boolean matchOp(Endpoint ep, Op op) {
        Path actionMatch;
        Path requestPath;
        String method = op.getMethod();
        Path endpointMatch = ep.match(method, requestPath = op.getPath().copy());
        if (endpointMatch == null) {
            return false;
        }
        op.withEndpoint(ep);
        op.withEndpointPathMatch(endpointMatch.copy());
        for (Action action : this.getActions()) {
            actionMatch = action.match(method, requestPath, true);
            if (actionMatch == null) continue;
            op.withActionMatch(action, actionMatch.copy(), false);
        }
        for (int i = 0; i < endpointMatch.size() && !endpointMatch.isOptional(i) && !endpointMatch.isWildcard(i); ++i) {
            requestPath.remove(0);
        }
        op.withActionPathMatch(requestPath.copy());
        for (Action action : ep.getActions()) {
            actionMatch = action.match(method, requestPath, true);
            if (actionMatch == null) continue;
            op.withActionMatch(action, actionMatch.copy(), true);
        }
        return true;
    }

    Map<String, Map<Endpoint, List<List<Path>>>> generatePaths() {
        LinkedHashMap<String, Map<Endpoint, List<List<Path>>>> paths = new LinkedHashMap<String, Map<Endpoint, List<List<Path>>>>();
        LinkedHashSet methods = new LinkedHashSet();
        Utils.add(methods, (Object[])new Object[]{"GET", "POST", "PUT", "PATCH", "DELETE"});
        for (String method : methods) {
            ArrayList<Endpoint> eps = new ArrayList<Endpoint>(this.getEndpoints());
            Collections.sort(eps);
            for (Endpoint ep : eps) {
                List<Object> endpointPaths = new ArrayList();
                for (Rule.RuleMatcher epMatcher : ep.getIncludeMatchers()) {
                    if (!epMatcher.hasMethod(method)) continue;
                    for (Path epPath : epMatcher.getPaths()) {
                        Db db = this.matchDb(method, epPath);
                        List<Action> epActions = ep.getActions();
                        ArrayList<Action> allActions = new ArrayList<Action>(ep.getActions());
                        for (Action action : this.getActions()) {
                            if (allActions.contains(action)) continue;
                            allActions.add(action);
                        }
                        Collections.sort(allActions);
                        List<Path> allPathsForSingleEpMatcherPath = new ArrayList();
                        for (Action action : allActions) {
                            if (action.isDecoration()) continue;
                            for (Path fullActionPath : action.getFullIncludePaths(this, db, method, epPath, epActions.contains(action))) {
                                allPathsForSingleEpMatcherPath.add(fullActionPath);
                            }
                        }
                        allPathsForSingleEpMatcherPath = Path.filterDuplicates(allPathsForSingleEpMatcherPath);
                        allPathsForSingleEpMatcherPath.removeIf(p -> p.size() == 0);
                        endpointPaths.addAll(allPathsForSingleEpMatcherPath);
                    }
                }
                endpointPaths = Path.filterDuplicates(endpointPaths);
                if ((endpointPaths = this.removeObscuredWildcards(endpointPaths)).size() <= 0) continue;
                List<List<Path>> groupedPaths = this.groupPaths(endpointPaths);
                Map<Endpoint, List<List<Path>>> epMap = paths.get(method);
                if (epMap == null) {
                    epMap = new LinkedHashMap<Endpoint, List<List<Path>>>();
                    paths.put(method, epMap);
                }
                epMap.put(ep, groupedPaths);
            }
        }
        return paths;
    }

    List<Path> removeObscuredWildcards(List<Path> paths) {
        ArrayListValuedHashMap templates = new ArrayListValuedHashMap();
        for (Path path : paths) {
            String template = path.getTemplate();
            templates.put((Object)template, (Object)path);
        }
        ArrayList sorted = new ArrayList(templates.keySet());
        Collections.sort(sorted);
        for (int i = 1; i < sorted.size() - 1; ++i) {
            String previous = (String)sorted.get(i - 1);
            String current = (String)sorted.get(i);
            if (!previous.endsWith("/*") || !current.startsWith(previous.substring(0, previous.length() - 1))) continue;
            System.out.println("REMOVING: " + previous);
            templates.remove((Object)previous);
        }
        ArrayList<Path> newPaths = new ArrayList<Path>();
        for (String key : templates.keySet()) {
            List ps = templates.get((Object)key);
            newPaths.addAll(ps);
        }
        Collections.sort(newPaths);
        return newPaths;
    }

    List<List<Path>> groupPaths(List<Path> paths) {
        paths = Path.filterDuplicates((List)paths);
        ArrayList<List<Path>> groups = new ArrayList<List<Path>>();
        ArrayList<Path> dynamics = new ArrayList<Path>();
        ArrayList<Path> statics = new ArrayList<Path>();
        ArrayList<Path> unbounds = new ArrayList<Path>();
        for (Path p2 : paths) {
            if (p2.hasVars()) {
                boolean unbound = false;
                for (int i = 0; i < p2.size(); ++i) {
                    String name = p2.getVarName(i);
                    if (name == null || !name.startsWith("_")) continue;
                    unbound = true;
                    break;
                }
                if (unbound) {
                    unbounds.add(p2);
                    continue;
                }
                dynamics.add(p2);
                continue;
            }
            statics.add(p2);
        }
        statics.forEach(p -> groups.add((List<Path>)Utils.add(new ArrayList(), (Object[])new Object[]{p})));
        dynamics.forEach(p -> groups.add((List<Path>)Utils.add(new ArrayList(), (Object[])new Object[]{p})));
        for (Path unbound : unbounds) {
            for (List list : groups) {
                boolean matches = true;
                for (Path p3 : list) {
                    if (p3.matches(unbound, true)) continue;
                    matches = false;
                    break;
                }
                if (!matches) continue;
                list.add(unbound);
            }
        }
        return groups;
    }

    void deduplicateOperationNames(List<Op> ops) {
        Collections.sort(ops);
        ArrayListValuedHashMap map = new ArrayListValuedHashMap();
        ops.forEach(op -> map.put((Object)op.getName(), op));
        for (String operationName : map.keySet()) {
            List values = map.get((Object)operationName);
            if (values.size() <= 1) continue;
            for (int i = 0; i < values.size(); ++i) {
                String name = ((Op)values.get(i)).getName() + (i + 1);
                ((Op)values.get(i)).withName(name);
            }
        }
    }

    public static interface ApiListener {
        default public void onStartup(Engine engine, Api api) {
        }

        default public void onShutdown(Engine engine, Api api) {
        }

        default public void onAfterRequest(Request req, Response res) {
        }

        default public void onAfterError(Request req, Response res) {
        }

        default public void onBeforeFinally(Request req, Response res) {
        }
    }
}

