/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.action.security;

import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Collection;
import io.inversion.Filter;
import io.inversion.Op;
import io.inversion.Param;
import io.inversion.Property;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.User;
import io.inversion.action.security.AuthScheme;
import io.inversion.action.security.schemes.ApiKeyScheme;
import io.inversion.action.security.schemes.BasicScheme;
import io.inversion.action.security.schemes.BearerScheme;
import io.inversion.json.JSMap;
import io.inversion.utils.Task;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class AuthFilter
extends Filter<AuthFilter> {
    public static final int AUTH_ACTION_DEFAULT_ORDER_IS_100 = 100;
    protected List<AuthScheme> schemes = new ArrayList<AuthScheme>();

    public AuthFilter() {
        this.withOrder(100);
    }

    @Override
    public void run(Request req, Response resp) throws ApiException {
        User user = Chain.getUser();
        if (user == null) {
            AuthScheme scheme;
            Iterator<AuthScheme> iterator = this.schemes.iterator();
            while (iterator.hasNext() && (user = (scheme = iterator.next()).getUser(req, resp)) == null) {
            }
        }
        if (user == null) {
            throw ApiException.new401Unauthroized();
        }
        Chain.peek().withUser(user);
        Collection coll = req.getCollection();
        if (coll != null) {
            for (Property prop : coll.getProperties()) {
                String key = prop.getJsonName();
                Object claimed = user.getClaim(key);
                if (claimed == null) continue;
                req.getUrl().withParam(key, claimed.toString());
                if (req.getData() == null) continue;
                for (Object node : req.getData()) {
                    if (!(node instanceof JSMap)) continue;
                    ((JSMap)node).put(key, claimed);
                }
            }
        }
    }

    public List<AuthScheme> getAuthSchemes() {
        return this.schemes;
    }

    public AuthFilter withAuthSchemes(List<AuthScheme> schemes) {
        schemes.forEach(this::withAuthScheme);
        return this;
    }

    public AuthFilter withAuthScheme(AuthScheme scheme) {
        if (scheme != null && !this.schemes.contains(scheme)) {
            this.schemes.add(scheme);
        }
        return this;
    }

    @Override
    public Operation hook_documentOp(Task docChain, OpenAPI openApi, List<Op> ops, Op op, Map<Object, Schema> schemas) {
        Operation operation = super.hook_documentOp(docChain, openApi, ops, op, schemas);
        if (!op.isEpAction(this)) {
            this.documentSecurity(openApi, null);
        }
        return operation;
    }

    protected void documentSecurity(OpenAPI openApi, Op op) {
        if (openApi.getSecurity() != null) {
            return;
        }
        Components components = openApi.getComponents();
        LinkedHashMap<String, SecurityScheme> securitySchemes = new LinkedHashMap<String, SecurityScheme>();
        List<AuthScheme> schemes = this.getAuthSchemes();
        ArrayListValuedHashMap securityRequirementsNames = new ArrayListValuedHashMap();
        for (int i = 0; i < schemes.size(); ++i) {
            SecurityScheme oasSS;
            AuthScheme scheme = schemes.get(i);
            String name = scheme.getName();
            if (name == null) {
                name = scheme.getClass().getSimpleName() + (i + 1);
            }
            String description = scheme.getDescription();
            if (scheme instanceof BasicScheme) {
                oasSS = new SecurityScheme();
                securitySchemes.put(name, oasSS);
                oasSS.setName(name);
                oasSS.setDescription(description);
                oasSS.setType(SecurityScheme.Type.HTTP);
                oasSS.setScheme("basic");
                securityRequirementsNames.put((Object)name, (Object)name);
                continue;
            }
            if (scheme instanceof BearerScheme) {
                oasSS = new SecurityScheme();
                securitySchemes.put(name, oasSS);
                oasSS.setName(name);
                oasSS.setDescription(description);
                oasSS.setType(SecurityScheme.Type.HTTP);
                oasSS.setScheme("bearer");
                oasSS.setBearerFormat(((BearerScheme)scheme).getBarerFormat());
                securityRequirementsNames.put((Object)name, (Object)name);
                continue;
            }
            if (!(scheme instanceof ApiKeyScheme)) continue;
            for (Param param : scheme.getParams()) {
                String apiKeyName = name + "_" + param.getKey() + "_" + (Object)((Object)param.getIn());
                SecurityScheme oasSS2 = new SecurityScheme();
                securitySchemes.put(apiKeyName, oasSS2);
                oasSS2.setDescription(description);
                oasSS2.setType(SecurityScheme.Type.APIKEY);
                oasSS2.setName(param.getKey());
                securityRequirementsNames.put((Object)name, (Object)apiKeyName);
                switch (param.getIn()) {
                    case HEADER: {
                        oasSS2.setIn(SecurityScheme.In.HEADER);
                        break;
                    }
                    case QUERY: {
                        oasSS2.setIn(SecurityScheme.In.QUERY);
                        break;
                    }
                    case COOKIE: {
                        oasSS2.setIn(SecurityScheme.In.COOKIE);
                    }
                }
            }
        }
        components.setSecuritySchemes(securitySchemes);
        ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>();
        for (String name : securityRequirementsNames.keySet()) {
            SecurityRequirement req = new SecurityRequirement();
            req.put((Object)name, (Object)securityRequirementsNames.get((Object)name));
            securityRequirements.add(req);
        }
        openApi.setSecurity(securityRequirements);
    }
}

