/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.action.security;

import io.inversion.Request;
import io.inversion.Rule;
import io.inversion.utils.Utils;
import java.util.ArrayList;

public class AclRule
extends Rule<AclRule> {
    protected final ArrayList<String> permissions = new ArrayList();
    protected final ArrayList<String> roles = new ArrayList();
    protected final ArrayList<String> scopes = new ArrayList();
    protected boolean allow = true;
    protected boolean info = false;
    protected boolean allRolesMustMatch = false;
    protected boolean allPermissionsMustMatch = false;
    protected boolean allScopesMustMatch = false;

    public AclRule() {
    }

    public AclRule(String name, String ruleMatcherSpec, String permission1, String ... permissionsN) {
        this.withName(name);
        this.withIncludeOn(ruleMatcherSpec);
        if (permission1 != null) {
            this.withPermissions(permission1);
        }
        if (permissionsN != null) {
            this.withPermissions(permissionsN);
        }
    }

    public static AclRule allowAll(String ruleMatcherSpec) {
        AclRule rule = new AclRule(null, ruleMatcherSpec, null, new String[0]);
        return rule;
    }

    public static AclRule requireAllPerms(String ruleMatcherSpec, String permission1, String ... permissionsN) {
        AclRule rule = new AclRule(null, ruleMatcherSpec, permission1, permissionsN);
        rule.withAllPermissionsMustMatch(true);
        return rule;
    }

    public static AclRule requireOnePerm(String ruleMatcherSpec, String permission1, String ... permissionsN) {
        AclRule rule = new AclRule(null, ruleMatcherSpec, permission1, permissionsN);
        rule.withAllPermissionsMustMatch(false);
        return rule;
    }

    public static AclRule requireAllRoles(String ruleMatcherSpec, String role1, String ... rolesN) {
        AclRule rule = new AclRule(null, ruleMatcherSpec, null, new String[0]);
        rule.withAllRolesMustMatch(true);
        rule.withRoles(role1);
        rule.withRoles(rolesN);
        return rule;
    }

    public static AclRule requireOneRole(String ruleMatcherSpec, String role1, String ... rolesN) {
        AclRule rule = new AclRule(null, ruleMatcherSpec, null, new String[0]);
        rule.withAllRolesMustMatch(false);
        rule.withRoles(role1);
        rule.withRoles(rolesN);
        return rule;
    }

    public static AclRule requireAllScopes(String ruleMatcherSpec, String scope1, String ... scopesN) {
        AclRule rule = new AclRule(null, ruleMatcherSpec, null, new String[0]);
        rule.withAllRolesMustMatch(true);
        rule.withScopes(scope1);
        rule.withScopes(scopesN);
        return rule;
    }

    public static AclRule requireOneScopes(String ruleMatcherSpec, String scope1, String ... scopesN) {
        AclRule rule = new AclRule(null, ruleMatcherSpec, null, new String[0]);
        rule.withAllRolesMustMatch(false);
        rule.withScopes(scope1);
        rule.withScopes(scopesN);
        return rule;
    }

    public boolean ruleMatches(Request req) {
        return true;
    }

    public ArrayList<String> getRoles() {
        return new ArrayList<String>(this.roles);
    }

    public AclRule withRoles(String ... roles) {
        if (roles != null) {
            for (String role : Utils.explode((String)",", (String[])roles)) {
                if (this.roles.contains(role)) continue;
                this.roles.add(role);
            }
        }
        return this;
    }

    public ArrayList<String> getPermissions() {
        return new ArrayList<String>(this.permissions);
    }

    public AclRule withPermissions(String ... permissions) {
        if (permissions != null) {
            for (String permission : Utils.explode((String)",", (String[])permissions)) {
                if (this.permissions.contains(permission)) continue;
                this.permissions.add(permission);
            }
        }
        return this;
    }

    public ArrayList<String> getScopes() {
        return new ArrayList<String>(this.scopes);
    }

    public AclRule withScopes(String ... scopes) {
        if (scopes != null) {
            for (String scope : Utils.explode((String)",", (String[])scopes)) {
                if (this.scopes.contains(scope)) continue;
                this.scopes.add(scope);
            }
        }
        return this;
    }

    public boolean isAllow() {
        return this.allow;
    }

    public AclRule withAllow(boolean allow) {
        this.allow = allow;
        return this;
    }

    public boolean isInfo() {
        return this.info;
    }

    public AclRule withInfo(boolean info) {
        this.info = info;
        return this;
    }

    public boolean isAllRolesMustMatch() {
        return this.allRolesMustMatch;
    }

    public AclRule withAllRolesMustMatch(boolean allRolesMustMatch) {
        this.allRolesMustMatch = allRolesMustMatch;
        return this;
    }

    public boolean isAllPermissionsMustMatch() {
        return this.allPermissionsMustMatch;
    }

    public AclRule withAllPermissionsMustMatch(boolean allPermissionsMustMatch) {
        this.allPermissionsMustMatch = allPermissionsMustMatch;
        return this;
    }
}

