/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.action.misc;

import io.inversion.Action;
import io.inversion.ApiException;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.json.JSList;
import io.inversion.json.JSNode;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CsvAction
extends Action<CsvAction> {
    @Override
    public void run(Request req, Response res) throws ApiException {
        if (!"GET".equals(req.getMethod()) || 200 != res.getStatusCode() || res.getJson() == null || res.getText() != null) {
            return;
        }
        if (!"csv".equalsIgnoreCase(req.getUrl().getParam("format"))) {
            return;
        }
        JSList arr = res.data();
        byte[] bytes = this.toCsv(arr).getBytes();
        res.withHeader("Content-Length", bytes.length + "");
        res.debug("Content-Length " + bytes.length + "", new Object[0]);
        res.withText(new String(bytes));
    }

    public String toCsv(JSList arr) throws ApiException {
        try {
            StringBuilder buff = new StringBuilder();
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            for (int i = 0; i < arr.size(); ++i) {
                JSNode obj = (JSNode)arr.get(i);
                if (obj == null) continue;
                for (String key : obj.keySet()) {
                    Object val = obj.get((Object)key);
                    if (val instanceof JSList || val instanceof JSNode) continue;
                    keys.add(key);
                }
            }
            CSVPrinter printer = new CSVPrinter((Appendable)buff, CSVFormat.DEFAULT);
            ArrayList keysList = new ArrayList(keys);
            for (String key : keysList) {
                printer.print((Object)key);
            }
            printer.println();
            System.out.println(arr);
            System.out.println("asdf");
            for (int i = 0; i < arr.size(); ++i) {
                for (String key : keysList) {
                    Object val = ((JSNode)arr.get(i)).get((Object)key);
                    if (val != null) {
                        printer.print(val);
                        continue;
                    }
                    printer.print((Object)"");
                }
                printer.println();
            }
            printer.flush();
            printer.close();
            return buff.toString();
        }
        catch (Exception ex) {
            throw ApiException.new500InternalServerError(ex);
        }
    }
}

