/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.action.hateoas;

import io.inversion.Action;
import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Op;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.action.db.DbAction;
import io.inversion.action.hateoas.HATEOASFilter;
import io.inversion.json.JSList;
import io.inversion.json.JSMap;
import io.inversion.json.JSNode;
import io.inversion.utils.Task;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.List;
import java.util.Map;

public class SdkFilter
extends HATEOASFilter<SdkFilter> {
    @Override
    public void run(Request req, Response res) throws ApiException {
        if (Chain.isRoot() && req.getCollection() != null) {
            req.getChain().go();
            if (res.isSuccess() && res.getJson() != null) {
                if (req.getOp().getFunction() == Op.OpFunction.FIND) {
                    this.updateFindResponse(req, res);
                } else {
                    this.removeMetaAndCollapseData(req, res);
                }
            }
        }
    }

    void removeMetaAndCollapseData(Request req, Response res) {
        res.getJson().remove(new Object[]{"meta"});
        JSNode json = res.getJson();
        JSList data = res.data();
        if (data != json) {
            if (data.size() == 1 && data.get(0) instanceof JSMap) {
                res.withJson(data.getNode((Object)0));
            } else {
                res.withJson((JSNode)new JSMap(new Object[]{"items", data}));
            }
        }
    }

    void updateFindResponse(Request req, Response res) {
        JSList data = res.data();
        System.out.println(res.getMeta());
        String next = res.getNext();
        int totalCount = res.getFoundRows();
        int itemCount = res.data() != null ? res.data().size() : 0;
        String lastKey = res.getLastKey();
        int pageSize = res.getPageSize();
        int pageCount = res.getPageCount();
        int pageNumber = res.getPageNum();
        JSMap page = res.findMap("page");
        if (page == null) {
            page = new JSMap();
        }
        if (next != null) {
            page.put("next", (Object)next);
        }
        if (totalCount > -1) {
            page.put("totalCount", (Object)totalCount);
        }
        if (itemCount > -1) {
            page.put("itemCount", (Object)itemCount);
        }
        if (lastKey != null) {
            page.put("lastKey", (Object)lastKey);
        }
        if (pageSize > -1) {
            page.put("pageSize", (Object)pageSize);
        }
        if (pageCount > -1) {
            page.put("pageCount", (Object)pageCount);
        }
        if (pageNumber > -1) {
            page.put("pageNumber", (Object)pageNumber);
        }
        JSMap newJson = new JSMap();
        newJson.put("page", (Object)page);
        newJson.put("items", (Object)data);
        res.withJson((JSNode)newJson);
    }

    @Override
    public Operation documentOpFind(Task docChain, OpenAPI openApi, List<Op> ops, Op op, Map<Object, Schema> schemas) {
        docChain.go();
        boolean hasDbAction = false;
        for (Action a : op.getActions()) {
            if (!(a instanceof DbAction)) continue;
            hasDbAction = true;
            break;
        }
        if (hasDbAction) {
            Operation operation = ((PathItem)openApi.getPaths().get((Object)op.getOperationPath())).getGet();
            Schema schema = schemas.get(op);
            if (operation != null && schema instanceof ArraySchema) {
                ArraySchema as = (ArraySchema)schema;
                Schema paginationInfo = (Schema)openApi.getComponents().getSchemas().get("PaginationInfo");
                if (paginationInfo == null) {
                    paginationInfo = this.newTypeSchema("object", "Pagination and Sort Information");
                    openApi.getComponents().addSchemas("PaginationInfo", paginationInfo);
                    paginationInfo.addProperties("next", this.newTypeSchema("string", "The GET URL to return the next page of results."));
                    paginationInfo.addProperties("totalCount", this.newTypeSchema("number", "The number of items returned in this paginated response."));
                    paginationInfo.addProperties("itemCount", this.newTypeSchema("number", "The number of items identified as matching the query."));
                    paginationInfo.addProperties("lastKey", this.newTypeSchema("string", "The primary key of the last item returned in this page.  This can be returned as the 'after' query parameter to most efficiently continue pagination."));
                    paginationInfo.addProperties("pageNumber", this.newTypeSchema("number", "The page number returned by this response being between 1 and pageCount."));
                    paginationInfo.addProperties("pageSize", this.newTypeSchema("number", "The number of items that were requested to be returned."));
                    paginationInfo.addProperties("pageCount", this.newTypeSchema("number", "The total number of pages available meaning  (itemCount / pageSize) rounded up."));
                }
                Schema listWrapper = this.newTypeSchema("object", null);
                String wrapperName = op.getName() + "Result";
                openApi.getComponents().addSchemas(wrapperName, listWrapper);
                listWrapper.addProperties("page", this.newComponentRefSchema("PaginationInfo"));
                ArraySchema arr = new ArraySchema();
                arr.setItems(as.getItems());
                listWrapper.addProperties("items", (Schema)arr);
                this.addResponse(operation, op, "200", null, wrapperName);
            }
        }
        return null;
    }
}

