/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.action.hateoas;

import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Collection;
import io.inversion.Relationship;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.action.hateoas.HATEOASFilter;
import io.inversion.json.JSMap;
import io.inversion.json.JSNode;
import java.util.Map;

public class LinksFilter
extends HATEOASFilter<LinksFilter> {
    @Override
    public void run(Request req, Response res) throws ApiException {
        if (Chain.isRoot() && req.getCollection() != null) {
            if (req.getJson() != null) {
                req.getData().asMapList().forEach(node -> this.removeLinks(req.getCollection(), (JSMap)node));
            }
            req.getChain().go();
            if (res.isSuccess() && res.getJson() != null) {
                Collection coll = req.getRelationship() != null ? req.getRelationship().getRelated() : req.getCollection();
                res.data().stream().filter(node -> node instanceof JSMap).forEach(node -> this.addLinks(coll, (JSMap)node));
            }
        }
    }

    @Override
    public void addSelfLink(JSMap entityNode, String link) {
        this.addLink(entityNode, "href", link);
    }

    protected void removeLinks(Collection coll, JSMap node) {
        if (node.get((Object)"href") instanceof String) {
            String href = (String)node.remove((Object)"href");
            if (href.startsWith("http://") || href.startsWith("https://")) {
                href = href.substring(href.lastIndexOf("/") + 1);
            }
            Map<String, Object> row = coll.decodeKeyToJsonNames(href);
            for (String key : row.keySet()) {
                node.put(key, row.get(key));
            }
        }
        for (Relationship rel : coll.getRelationships()) {
            if (!node.containsKey((Object)rel.getName())) continue;
            Object value = node.get((Object)rel.getName());
            if (value instanceof JSNode) {
                ((JSNode)value).asMapList().forEach(child -> this.removeLinks(rel.getRelated(), (JSMap)child));
                continue;
            }
            if (rel.isManyToOne()) {
                String href;
                if (value == null || !(value instanceof String) || !(href = (String)value).startsWith("http://") && !href.startsWith("https://")) continue;
                node.remove((Object)rel.getName());
                href = href.substring(href.lastIndexOf("/") + 1);
                Map<String, Object> primaryKey = rel.getRelated().decodeKeyToJsonNames(href);
                Map<String, Object> foreignKey = rel.buildForeignKeyFromPrimaryKey(primaryKey);
                for (String key : foreignKey.keySet()) {
                    if (node.containsKey((Object)key)) continue;
                    node.put(key, foreignKey.get(key));
                }
                continue;
            }
            node.remove((Object)rel.getName());
        }
    }
}

