/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.json.JSMap;
import io.inversion.json.JSParser;
import io.inversion.rql.Rql;
import io.inversion.rql.Term;
import io.inversion.utils.Path;
import io.inversion.utils.Utils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public final class Url {
    private String original;
    private String protocol = "http";
    private String hostAsString = null;
    private Path hostAsPath = null;
    private int port = 0;
    private Path path = null;
    private JSMap params = new JSMap();

    public Url copy() {
        Url url = new Url();
        url.original = this.original;
        url.protocol = this.protocol;
        url.hostAsString = this.hostAsString;
        url.hostAsPath = this.hostAsPath == null ? null : new Path(this.hostAsPath);
        url.port = this.port;
        url.path = this.path == null ? null : new Path(this.path);
        url.params = this.params.size() == 0 ? url.params : JSParser.asJSMap((String)this.params.toString());
        return url;
    }

    private Url() {
    }

    public Url(String url) {
        String origionalUrl = url;
        try {
            int queryIndex = url.indexOf(63);
            if (queryIndex >= 0) {
                String query = url.substring(queryIndex + 1);
                url = url.substring(0, queryIndex);
                this.withQueryString(query);
            }
            if (url.startsWith("//") || url.startsWith("http:/") || url.startsWith("https:/")) {
                if (url.startsWith("//")) {
                    this.withProtocol("//");
                } else if (url.startsWith("http://")) {
                    this.withProtocol("http");
                    url = url.substring(5);
                } else if (url.startsWith("https://")) {
                    this.withProtocol("https");
                    url = url.substring(6);
                } else {
                    throw Utils.ex((String)"Your requested URL '{}' is malformed.", (Object[])new Object[]{origionalUrl});
                }
                while (url.startsWith("/")) {
                    url = url.substring(1);
                }
                int slash = url.indexOf("/");
                int colon = url.indexOf(":");
                if (colon > 0 && (slash < 0 || colon < slash)) {
                    this.withHost(url.substring(0, colon));
                    url = url.substring(colon);
                } else if (slash > 0) {
                    this.withHost(url.substring(0, slash));
                    url = url.substring(slash);
                }
                if (url.startsWith(":")) {
                    slash = url.indexOf("/");
                    if (slash > 0) {
                        this.withPort(Integer.parseInt(url.substring(1, slash)));
                        url = url.substring(slash);
                    } else {
                        this.withPort(Integer.parseInt(url.substring(1)));
                        url = "";
                    }
                }
            }
            while (url.startsWith("/")) {
                url = url.substring(1);
            }
            if (url.length() > 0) {
                Path path = new Path(new String[]{url});
                for (int i = 0; i < path.size(); ++i) {
                    if (!path.get(i).startsWith(".")) continue;
                    throw Utils.ex((String)"Your requested URL '{}' is malformed.", (Object[])new Object[]{origionalUrl});
                }
                this.withPath(path);
            }
        }
        catch (Exception ex) {
            throw Utils.ex((Throwable)ex, (String)"Your requested URL '{}' is malformed.", (Object[])new Object[]{origionalUrl});
        }
        finally {
            this.original = this.toString();
        }
    }

    public static String toQueryString(Map<String, String> params) {
        StringBuilder query = new StringBuilder();
        ArrayList<String> qs = new ArrayList<String>();
        for (String key : params.keySet()) {
            if (key.indexOf("(") <= 0) continue;
            qs.add(key);
        }
        if (qs.size() > 0) {
            params = new LinkedHashMap<String, String>(params);
            for (String q : qs) {
                params.remove(q);
            }
            params.put("q", Utils.implode((String)",", (Object[])new Object[]{qs}));
        }
        for (String key : params.keySet()) {
            try {
                if (params.get(key) != null) {
                    query.append(URLEncoder.encode(key, "UTF-8")).append("=").append(URLEncoder.encode(params.get(key).toString(), "UTF-8")).append("&");
                    continue;
                }
                query.append(URLEncoder.encode(key, "UTF-8")).append("&");
            }
            catch (UnsupportedEncodingException e) {
                Utils.rethrow((Throwable)e);
            }
        }
        if (query.length() > 0) {
            query = new StringBuilder(query.substring(0, query.length() - 1));
        }
        String str = query.toString();
        str = str.replace("%28", "(");
        str = str.replace("%29", ")");
        str = str.replace("%2C", ",");
        return str;
    }

    public static String encode(String str) {
        try {
            str = URLEncoder.encode(str, "UTF-8");
            str = str.replace("%2C", ",");
            str = str.replace("%7E", "~");
            return str;
        }
        catch (Exception ex) {
            throw Utils.ex((Throwable)ex);
        }
    }

    public String toString() {
        String url = this.protocol;
        if (!this.protocol.equals("//")) {
            url = url + "://";
        }
        url = url + (this.hostAsString != null ? this.hostAsString : "127.0.0.1");
        if (this.port > 0) {
            if (!(this.port == 80 && "http".equalsIgnoreCase(this.protocol) || this.port == 443 && "https".equalsIgnoreCase(this.protocol))) {
                url = url + ":" + this.port;
            }
        } else if (this.hostAsString == null) {
            url = url + ":8080";
        }
        if (this.path != null && this.path.size() > 0) {
            url = url + "/" + this.path;
        }
        if (this.params.size() > 0) {
            while (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            url = url + "?";
            url = url + Url.toQueryString((Map<String, String>)this.params);
        }
        return url;
    }

    public boolean equals(Object url) {
        if (url instanceof Url) {
            return this.toString().equals(url.toString());
        }
        return false;
    }

    public String getDomain() {
        String domain = this.hostAsString;
        if (domain.lastIndexOf(46) > domain.indexOf(46)) {
            domain = domain.substring(domain.indexOf(46) + 1);
        }
        return domain;
    }

    public String getQueryString() {
        if (this.params.size() == 0) {
            return "";
        }
        return Url.toQueryString((Map<String, String>)this.params);
    }

    public String getHost() {
        return this.hostAsString;
    }

    public Url withHost(String host) {
        this.hostAsString = host;
        this.hostAsPath = new Path(new String[]{this.hostAsString.replace('.', '/')});
        return this;
    }

    public Path getHostAsPath() {
        return this.hostAsPath;
    }

    public int getPort() {
        return this.port;
    }

    public Url withPort(int port) {
        this.port = port;
        return this;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Url withProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public Path getPath() {
        if (this.path == null) {
            return new Path();
        }
        return new Path(this.path);
    }

    public Url withPath(Path path) {
        this.path = path;
        return this;
    }

    public String getFile() {
        if (this.path != null) {
            return this.path.last();
        }
        return null;
    }

    public Url withQueryString(String queryString) {
        this.withParams(Utils.parseQueryString((String)queryString));
        return this;
    }

    public Url withParams(Map<String, String> params) {
        if (params != null) {
            for (String key : params.keySet()) {
                this.withParam(key, params.get(key));
            }
        }
        return this;
    }

    public Url withParam(Term term) {
        this.params.put(term.toString(), null);
        return this;
    }

    public Url withParam(String name, String value) {
        int paren = name.indexOf("(");
        if (paren > 0) {
            String func = this.fixLegacyParamName(name.substring(0, paren));
            if (Utils.in((Object)func, (Object[])new Object[]{"page", "size", "sort", "include", "exclude", "expand", "collapse"})) {
                value = name.substring(paren + 1, name.lastIndexOf(")"));
                name = func;
            }
        } else {
            name = this.fixLegacyParamName(name);
        }
        if (!Utils.empty((Object[])new Object[]{name})) {
            if ("q".equalsIgnoreCase(name)) {
                value = "and(" + value + ")";
                Term term = Rql.parse(value);
                for (Term child : term.getTerms()) {
                    this.withParam(child.toString(), null);
                }
            } else {
                this.params.put(name, (Object)value);
            }
        }
        return this;
    }

    String fixLegacyParamName(String name) {
        switch (name.toLowerCase()) {
            case "pagenum": {
                return "page";
            }
            case "limit": {
                return "size";
            }
            case "order": {
                return "sort";
            }
            case "includes": {
                return "include";
            }
            case "excludes": {
                return "exclude";
            }
            case "expands": {
                return "expand";
            }
            case "collapses": {
                return "collapse";
            }
        }
        return name;
    }

    public Url withParams(String ... nvpairs) {
        if (nvpairs != null) {
            for (int i = 0; i < nvpairs.length - 1; i += 2) {
                this.withParam(nvpairs[i], nvpairs[i + 1]);
            }
            if (nvpairs.length % 2 == 1) {
                this.withParam(nvpairs[nvpairs.length - 1], null);
            }
        }
        return this;
    }

    public String clearParams(String ... tokens) {
        String oldValue = null;
        for (String token : tokens) {
            for (String key : new LinkedHashSet(this.params.keySet())) {
                String value = (String)this.params.get((Object)key);
                if (!Utils.containsToken((String)token, (String)key)) continue;
                String removed = (String)this.params.remove((Object)key);
                if (oldValue != null) continue;
                oldValue = removed;
            }
        }
        return oldValue;
    }

    public void clearParams() {
        this.params.clear();
    }

    public String findKey(String ... tokens) {
        for (String token : tokens) {
            for (String key : this.params.keySet()) {
                if (!Utils.containsToken((String)token, (String)key)) continue;
                return key;
            }
        }
        return null;
    }

    public String findKeyValue(String ... tokens) {
        String key = this.findKey(tokens);
        if (key != null) {
            return (String)this.params.get((Object)key);
        }
        return null;
    }

    public String getParam(String key) {
        return (String)this.params.get((Object)key);
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getOriginal() {
        return this.original;
    }
}

