/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.Url;
import io.inversion.utils.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public final class Server {
    String name = null;
    LinkedHashMap<Url, ServerMatcher> urls = new LinkedHashMap();
    boolean documented = true;

    public Server() {
    }

    public Server(String ... urls) {
        this.withUrls(urls);
    }

    public Server(Url ... urls) {
        this.withUrls(urls);
    }

    public String getName() {
        return this.name;
    }

    public Server withName(String name) {
        this.name = name;
        return this;
    }

    public String toString() {
        return this.urls.keySet().toString();
    }

    public ServerMatcher match(Url url) {
        for (ServerMatcher matcher : this.urls.values()) {
            if (!matcher.match(url)) continue;
            return matcher;
        }
        return null;
    }

    public Server withUrls(String ... urls) {
        for (String url : urls) {
            this.withUrls(new Url(url));
        }
        return this;
    }

    public Server withUrls(Url ... urls) {
        for (Url url : urls) {
            this.urls.put(url, new ServerMatcher(url));
        }
        return this;
    }

    public List<Url> getUrls() {
        return new ArrayList<Url>(this.urls.keySet());
    }

    public boolean isDocumented() {
        return this.documented;
    }

    public Server withDocumented(boolean documented) {
        this.documented = documented;
        return this;
    }

    public List<ServerMatcher> getServerMatches() {
        return new ArrayList<ServerMatcher>(this.urls.values());
    }

    public static class ServerMatcher {
        Url url;
        String protocol;
        Path host;
        Path path;
        int port = 0;

        public ServerMatcher(Url url) {
            this.url = url;
            this.protocol = url.getProtocol();
            this.host = url.getHost() != null ? new Path(new String[]{url.getHost().replace(".", "/")}) : null;
            this.port = url.getPort();
            this.path = url.getPath();
            if (this.path == null) {
                this.path = new Path(new String[]{"*"});
            }
            if (!this.path.endsWithWildcard()) {
                this.path.add("*");
            }
        }

        public String toString() {
            if (this.host != null && this.host.size() > 0) {
                return this.url.toString();
            }
            if (this.port > 0) {
                return "/" + this.path + ":" + this.port;
            }
            return "/" + this.path;
        }

        public boolean match(Url url) {
            if (this.protocol != null && !this.protocol.equals("//") && !this.protocol.equals(url.getProtocol())) {
                return false;
            }
            if (this.host != null && url.getHostAsPath() != null && !this.host.matches(url.getHostAsPath())) {
                return false;
            }
            if (this.port > 0 && url.getPort() > 0 && this.port != url.getPort()) {
                return false;
            }
            return this.path == null || this.path.matches(url.getPath());
        }

        public String getProtocol() {
            return this.protocol;
        }

        public Path getHost() {
            if (this.host == null) {
                return new Path();
            }
            return new Path(this.host);
        }

        public Path getPath() {
            return new Path(this.path);
        }

        public int getPort() {
            return this.port;
        }
    }
}

