/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.Api;
import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Collection;
import io.inversion.Db;
import io.inversion.Endpoint;
import io.inversion.Engine;
import io.inversion.Headers;
import io.inversion.Op;
import io.inversion.Param;
import io.inversion.Relationship;
import io.inversion.Server;
import io.inversion.Upload;
import io.inversion.Uploader;
import io.inversion.Url;
import io.inversion.Validation;
import io.inversion.json.JSFind;
import io.inversion.json.JSList;
import io.inversion.json.JSMap;
import io.inversion.json.JSNode;
import io.inversion.json.JSParser;
import io.inversion.utils.Path;
import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class Request
implements Headers,
JSFind {
    public static final String COLLECTION_KEY = "_collection";
    public static final String RESOURCE_KEY = "_resource";
    public static final String RELATIONSHIP_KEY = "_relationship";
    long startAt = System.currentTimeMillis();
    long endAt = -1L;
    String referrer = null;
    String remoteAddr = null;
    JSMap headers = new JSMap();
    boolean explain = false;
    boolean internal = false;
    Engine engine = null;
    Chain chain = null;
    String method = null;
    Url url = null;
    Server server = null;
    Api api = null;
    Op op = null;
    Endpoint endpoint = null;
    Collection collection = null;
    Db db = null;
    Server.ServerMatcher serverMatch = null;
    Path serverPath = null;
    Path serverPathMatch = null;
    Path operationPath = null;
    Path endpointPath = null;
    Path dbPath = null;
    Path collectionPath = null;
    Path actionPath = null;
    List<Chain.ActionMatch> actionMatches = new ArrayList<Chain.ActionMatch>();
    Map<String, String> pathParams = new HashMap<String, String>();
    String body = null;
    JSNode json = null;
    Uploader uploader = null;

    public Request() {
    }

    public Request(String method, String url) {
        this(method, url, null, null);
    }

    public Request(String method, String url, String body) {
        this.withMethod(method);
        this.withUrl(url);
        this.withBody(body);
    }

    public Request(Engine engine, String method, String url, Object body) {
        this.withEngine(engine);
        this.withMethod(method);
        this.withUrl(url);
        if (body != null) {
            this.withBody(body.toString());
        }
    }

    public Request(String method, String url, String body, ArrayListValuedHashMap<String, String> headers) {
        this(method, url, body, null, headers);
    }

    public Request(String method, String url, String body, Map<String, String> params, ArrayListValuedHashMap<String, String> headers) {
        this.withMethod(method);
        this.withUrl(url);
        this.withBody(body);
        if (params != null) {
            this.url.withParams(params);
        }
        if (headers != null && headers.size() > 0) {
            for (String key : headers.keySet()) {
                List values = headers.get((Object)key);
                for (String value : values) {
                    this.addHeader(key, value);
                }
            }
        }
        System.out.println(this.headers);
    }

    public String findParam(String name, Param.In ... where) {
        if (where == null || where.length == 0) {
            where = new Param.In[]{Param.In.QUERY, Param.In.URL, Param.In.PATH, Param.In.HEADER, Param.In.SERVER_PATH, Param.In.HOST};
        }
        LinkedHashSet<Param.In> wheres = new LinkedHashSet<Param.In>();
        block10: for (Param.In w : where) {
            switch (w) {
                case URL: {
                    Utils.add(wheres, (Object[])new Object[]{Param.In.HOST, Param.In.SERVER_PATH, Param.In.PATH, Param.In.QUERY});
                    continue block10;
                }
                default: {
                    wheres.add(w);
                }
            }
        }
        String value = null;
        for (Param.In w : wheres) {
            block3 : switch (w) {
                case PATH: {
                    Param param = this.op.getParam(Param.In.PATH, name);
                    if (param == null) break;
                    value = this.getPath().get(param.index);
                    break;
                }
                case HEADER: {
                    value = this.getHeader(name);
                    break;
                }
                case QUERY: {
                    value = this.getUrl().getParam(name);
                    break;
                }
                case SERVER_PATH: {
                    Path path = this.getServerPathMatch();
                    for (int i = 0; path != null && i < path.size(); ++i) {
                        if (!path.isVar(i) || !path.getVarName(i).equalsIgnoreCase(name)) continue;
                        value = this.getServerPath().get(i);
                        break block3;
                    }
                    break;
                }
                case HOST: {
                    Path hostPath = this.getServerMatch().getHost();
                    for (int i = 0; hostPath != null && i < hostPath.size(); ++i) {
                        if (!hostPath.isVar(i) || !hostPath.getVarName(i).equalsIgnoreCase(name)) continue;
                        value = this.getUrl().getHostAsPath().get(i);
                        break block3;
                    }
                    break;
                }
                default: {
                    System.err.println("IMPLEMENT SUPPORT FOR Request.findParam(var, " + (Object)((Object)w) + ")");
                }
            }
            if (value == null) continue;
            break;
        }
        return value;
    }

    public Request withUrl(String url) {
        Url u = new Url(url);
        String key = u.findKey("explain");
        if (key != null) {
            String explain = u.clearParams(key);
            if (Utils.empty((Object[])new Object[]{explain}) || "true".equalsIgnoreCase(explain.trim())) {
                this.withExplain(true);
            }
            u = new Url(u.toString());
        }
        this.url = u;
        return this;
    }

    public long getStartAt() {
        return this.startAt;
    }

    public Request withStartAt(long startAt) {
        this.startAt = startAt;
        return this;
    }

    public long getEndAt() {
        return this.endAt;
    }

    public Request withEndAt(long endAt) {
        this.endAt = endAt;
        return this;
    }

    public long getDuration() {
        if (this.endAt < 1L) {
            return System.currentTimeMillis() - this.startAt;
        }
        return this.endAt - this.startAt;
    }

    public Request withMethod(String method) {
        this.method = method;
        return this;
    }

    public Request withHeaders(String key, String value) {
        this.addHeader(key, value);
        return this;
    }

    public Request withHeaders(JSMap headers) {
        this.headers.putAll((Map)headers);
        return this;
    }

    @Override
    public JSMap getHeaders() {
        return this.headers;
    }

    public Server getServer() {
        return this.server;
    }

    public Request withServer(Server server) {
        this.server = server;
        return this;
    }

    public Api getApi() {
        return this.api;
    }

    public Request withApi(Api api) {
        this.api = api;
        return this;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public Request withEngine(Engine engine) {
        this.engine = engine;
        return this;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public Request withInternal(boolean internal) {
        this.internal = internal;
        return this;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public Request withCollection(Collection collection) {
        this.collection = collection;
        return this;
    }

    public Db getDb() {
        return this.db;
    }

    public Request withDb(Db db) {
        this.db = db;
        return this;
    }

    public Path getDbPath() {
        return this.dbPath;
    }

    public Request withDbPath(Path dbPath) {
        this.dbPath = dbPath;
        return this;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public Request withEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public Server.ServerMatcher getServerMatch() {
        return this.serverMatch;
    }

    public Request withServerMatch(Server.ServerMatcher serverMatch) {
        this.serverMatch = serverMatch;
        return this;
    }

    public Path getServerPath() {
        return this.serverPath;
    }

    public Request withServerPath(Path serverPath) {
        this.serverPath = serverPath;
        return this;
    }

    public Path getServerPathMatch() {
        return this.serverPathMatch;
    }

    public Request withServerPathMatch(Path serverPathMatch) {
        this.serverPathMatch = serverPathMatch;
        return this;
    }

    public Path getOperationPath() {
        return this.operationPath;
    }

    public Request withOperationPath(Path operationPath) {
        this.operationPath = operationPath;
        return this;
    }

    public Path getEndpointPath() {
        return this.endpointPath;
    }

    public Request withEndpointPath(Path endpointPath) {
        this.endpointPath = endpointPath;
        return this;
    }

    public Path getActionPath() {
        return this.actionPath;
    }

    public Request withActionPath(Path actionPath) {
        this.actionPath = actionPath;
        return this;
    }

    public Path getCollectionPath() {
        return this.collectionPath;
    }

    public Request withCollectionPath(Path collectionPath) {
        this.collectionPath = collectionPath;
        return this;
    }

    public Request withActionMatches(List<Chain.ActionMatch> actionMatches) {
        this.actionMatches.addAll(actionMatches);
        return this;
    }

    public Request withActionMatch(Chain.ActionMatch actionMatch) {
        this.actionMatches.add(actionMatch);
        return this;
    }

    public List<Chain.ActionMatch> getActionMatches() {
        return this.actionMatches;
    }

    public Request withPathParams(Map<String, String> pathParams) {
        pathParams.keySet().forEach(xva$0 -> this.url.clearParams((String)xva$0));
        pathParams.entrySet().stream().filter(e -> e.getValue() != null).forEach(e -> this.url.withParam((String)e.getKey(), (String)e.getValue()));
        return this;
    }

    public Map<String, String> getPathParams() {
        return this.pathParams;
    }

    public boolean isDebug() {
        Api api = this.getApi();
        if (api != null || api.isDebug()) {
            return true;
        }
        Url url = this.getUrl();
        if (Chain.peek() != null) {
            url = Chain.first().getRequest().getUrl();
        }
        if (url.getHost() == null) {
            return true;
        }
        String host = url.getHost().toLowerCase();
        return "127.0.0.1".equals(host);
    }

    public boolean isExplain() {
        return this.explain;
    }

    public Request withExplain(boolean explain) {
        this.explain = explain;
        return this;
    }

    public String getBody() {
        return this.body;
    }

    public Request withBody(String body) {
        this.body = body;
        return this;
    }

    public JSNode getJson() throws ApiException {
        if (this.json != null) {
            return this.json;
        }
        String body = this.getBody();
        if (Utils.empty((Object[])new Object[]{body})) {
            return null;
        }
        try {
            this.json = JSParser.asJSNode((String)body);
        }
        catch (Exception ex) {
            throw ApiException.new400BadRequest("Unparsable JSON body", new Object[0]);
        }
        return this.json;
    }

    public JSList getData() {
        JSNode node = this.getJson();
        if (node != null) {
            if (node instanceof JSList) {
                return (JSList)node;
            }
            if (node.get((Object)"data") instanceof JSList) {
                return node.getList((Object)"data");
            }
            if (node.get((Object)"_embedded") instanceof JSList) {
                return node.getList((Object)"_embedded");
            }
            return new JSList(new Object[]{node});
        }
        if (this.getBody() == null) {
            return new JSList(new Object[0]);
        }
        return null;
    }

    public Request withJson(JSNode json) {
        this.json = json;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isMethod(String ... methods) {
        for (String method : methods) {
            if (!this.method.equalsIgnoreCase(method)) continue;
            return true;
        }
        return false;
    }

    public boolean isPut() {
        return "put".equalsIgnoreCase(this.method);
    }

    public boolean isPost() {
        return "post".equalsIgnoreCase(this.method);
    }

    public boolean isPatch() {
        return "patch".equalsIgnoreCase(this.method);
    }

    public boolean isGet() {
        return "get".equalsIgnoreCase(this.method);
    }

    public boolean isDelete() {
        return "delete".equalsIgnoreCase(this.method);
    }

    public boolean isOptions() {
        return "options".equalsIgnoreCase(this.method);
    }

    public String getReferrer() {
        return this.getHeader("referrer");
    }

    public Chain getChain() {
        return this.chain;
    }

    public Request withChain(Chain chain) {
        this.chain = chain;
        return this;
    }

    public Url getUrl() {
        return this.url;
    }

    public String getCollectionKey() {
        return this.url.getParam(COLLECTION_KEY);
    }

    public String getResourceKey() {
        return this.url.getParam(RESOURCE_KEY);
    }

    public String getRelationshipKey() {
        return this.url.getParam(RELATIONSHIP_KEY);
    }

    public Relationship getRelationship() {
        return this.op.getRelationship();
    }

    public String getApiUrl() {
        return this.url.getProtocol() + "://" + this.url.getHost() + (this.url.getPort() > 0 ? ":" + this.url.getPort() : "") + "/" + this.getServerPath();
    }

    public Path getPath() {
        return new Path(new String[]{this.endpointPath.toString(), this.actionPath.toString()});
    }

    public Path getSubpath() {
        return this.actionPath;
    }

    public Op getOp() {
        return this.op;
    }

    public Request withOp(Op op) {
        this.op = op;
        return this;
    }

    public String getRemoteAddr() {
        String remoteAddr = this.getHeader("X-Forwarded-For");
        if (remoteAddr == null || remoteAddr.length() == 0 || "unknown".equalsIgnoreCase(remoteAddr)) {
            remoteAddr = this.getHeader("Proxy-Client-IP");
        }
        if (remoteAddr == null || remoteAddr.length() == 0 || "unknown".equalsIgnoreCase(remoteAddr)) {
            remoteAddr = this.getHeader("WL-Proxy-Client-IP");
        }
        if (remoteAddr == null || remoteAddr.length() == 0 || "unknown".equalsIgnoreCase(remoteAddr)) {
            remoteAddr = this.getHeader("HTTP_CLIENT_IP");
        }
        if (remoteAddr == null || remoteAddr.length() == 0 || "unknown".equalsIgnoreCase(remoteAddr)) {
            remoteAddr = this.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (remoteAddr == null || remoteAddr.length() == 0 || "unknown".equalsIgnoreCase(remoteAddr)) {
            remoteAddr = this.remoteAddr;
        }
        return remoteAddr;
    }

    public Request withRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
        return this;
    }

    public Uploader getUploader() {
        return this.uploader;
    }

    public Request withUploader(Uploader uploader) {
        this.uploader = uploader;
        return this;
    }

    public List<Upload> getUploads() {
        return this.uploader.getUploads();
    }

    public Validation validate(String propOrJsonPath) {
        return this.validate(propOrJsonPath, null);
    }

    public Validation validate(String propOrJsonPath, String customErrorMessage) {
        return new Validation(this, propOrJsonPath, customErrorMessage);
    }

    public void check(boolean value, String message, Object ... args) {
        if (!value) {
            throw ApiException.new400BadRequest(message, args);
        }
    }
}

