/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class Param {
    String name = null;
    String key = null;
    In in = null;
    boolean required = false;
    String description = null;
    String type = "string";
    List<Pattern> patterns = new ArrayList<Pattern>();
    Set<String> regexes = new HashSet<String>();
    int index = 0;
    Set<String> methods = new LinkedHashSet<String>();

    public Param() {
    }

    public Param(String key, In in) {
        this.withIn(in);
        this.withKey(key);
    }

    public Param(String key, int index) {
        this.withIn(In.PATH);
        this.withKey(key);
        this.withIndex(index);
        this.withRequired(true);
    }

    public Param(String name, String key, In in, boolean required) {
        this.withName(name);
        this.withKey(key);
        this.withIn(in);
        this.withRequired(required);
    }

    public String toString() {
        return "[" + (Object)((Object)this.in) + ": {" + this.key + "}," + this.index + (this.regexes.size() > 0 ? ", " + this.regexes : "") + "]";
    }

    public String getName() {
        return this.name;
    }

    public Param withName(String name) {
        this.name = name;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public Param withKey(String key) {
        this.key = key;
        return this;
    }

    public In getIn() {
        return this.in;
    }

    public Param withIn(In in) {
        this.in = in;
        return this;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Param withRequired(boolean required) {
        this.required = required;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Param withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public Param withType(String type) {
        this.type = type;
        return this;
    }

    public Set<String> getRegexs() {
        return this.regexes;
    }

    public Param withRegex(String regex) {
        if (regex != null && !this.regexes.contains(regex)) {
            Pattern pattern = Pattern.compile(regex, 2);
            this.patterns.add(pattern);
            this.regexes.add(regex);
        }
        return this;
    }

    public int getIndex() {
        return this.index;
    }

    public Param withIndex(int index) {
        this.index = index;
        return this;
    }

    public List<Pattern> getPatterns() {
        return this.patterns;
    }

    public Param withMethod(String method) {
        this.methods.add(method.toUpperCase());
        return this;
    }

    public Set<String> getMethods() {
        return new LinkedHashSet<String>(this.methods);
    }

    public boolean hasMethod(String method) {
        return this.methods.contains(method.toUpperCase());
    }

    public static enum In {
        HOST,
        SERVER_PATH,
        PATH,
        QUERY,
        BODY,
        COOKIE,
        HEADER,
        USER,
        CHAIN,
        CONTEXT,
        ENVIRONMENT,
        URL,
        REQUEST;

    }
}

