/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.Api;
import io.inversion.ApiException;
import io.inversion.Collection;
import io.inversion.Index;
import io.inversion.Property;
import io.inversion.Relationship;
import io.inversion.Results;
import io.inversion.Rule;
import io.inversion.json.JSMap;
import io.inversion.json.JSParser;
import io.inversion.rql.Rql;
import io.inversion.rql.Term;
import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Db<T extends Db>
extends Rule<T> {
    protected static final Set<String> reservedParams = Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList("select", "insert", "update", "delete", "drop", "union", "truncate", "exec", "explain", "exclude", "expand", "collapse", "q")));
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final ArrayList<Collection> collections = new ArrayList();
    protected final HashMap<String, String> includeTables = new HashMap();
    protected final Set<String> includeColumns = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    protected final Set<String> excludeColumns = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    final transient Set<Api> runningApis = new HashSet<Api>();
    protected boolean bootstrap = true;
    protected String type = null;
    protected boolean dryRun = false;
    transient boolean firstStartup = true;
    transient boolean shutdown = false;

    public Db() {
    }

    public Db(String name) {
        this.name = name;
    }

    protected boolean excludeTable(String tableName) {
        return this.includeTables.size() > 0 && !this.includeTables.containsKey(tableName) && !this.includeTables.containsKey(tableName.toLowerCase());
    }

    /*
     * Exception decompiling
     */
    public static Object castJsonInput(String type, Object value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [55[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final synchronized T startup(Api api) {
        if (this.runningApis.contains(api)) {
            return (T)this;
        }
        this.runningApis.add(api);
        this.doStartup(api);
        return (T)this;
    }

    protected void doStartup(Api api) {
        try {
            if (this.isBootstrap()) {
                if (this.firstStartup) {
                    this.firstStartup = false;
                    this.configDb();
                }
                this.configApi(api);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Utils.rethrow((Throwable)ex);
        }
    }

    public synchronized T shutdown() {
        if (!this.shutdown) {
            this.shutdown = true;
            this.runningApis.forEach(this::shutdown);
            this.doShutdown();
        }
        return (T)this;
    }

    protected void doShutdown() {
    }

    public synchronized T shutdown(Api api) {
        if (this.runningApis.contains(api)) {
            this.doShutdown(api);
            this.runningApis.remove(api);
        }
        if (this.runningApis.size() == 0) {
            this.shutdown();
        }
        return (T)this;
    }

    protected void doShutdown(Api api) {
    }

    public boolean isRunning(Api api) {
        return this.runningApis.contains(api);
    }

    /*
     * Could not resolve type clashes
     */
    public final Results select(Collection collection, Map<String, String> params) throws ApiException {
        ArrayList<Term> terms = new ArrayList<Term>();
        for (String key : params.keySet()) {
            String value;
            Term term2 = Rql.parse(key, value = params.get(key));
            List illegalTerms = term2.stream().filter(t -> t.isLeaf() && reservedParams.contains(t.getToken())).collect(Collectors.toList());
            if (illegalTerms.size() > 0) continue;
            if (term2.hasToken("eq") && term2.getTerm(0).hasToken("include")) {
                boolean dottedInclude = false;
                for (int i = 1; i < term2.size(); ++i) {
                    String str = term2.getToken(i);
                    if (!str.contains(".")) continue;
                    dottedInclude = true;
                    break;
                }
                if (dottedInclude) continue;
                for (Term child : term2.getTerms()) {
                    if (!child.hasToken("href") || collection == null) continue;
                    Index pk = collection.getResourceIndex();
                    if (pk == null) break;
                    term2.removeTerm(child);
                    for (int i = 0; i < pk.size(); ++i) {
                        Property c = pk.getProperty(i);
                        boolean includesPkCol = false;
                        for (Term col : term2.getTerms()) {
                            if (!col.hasToken(c.getColumnName())) continue;
                            includesPkCol = true;
                            break;
                        }
                        if (includesPkCol) continue;
                        term2.withTerm(Term.term(term2, c.getColumnName(), new Object[0]));
                    }
                }
            }
            terms.add(term2);
        }
        Collections.sort(terms);
        ArrayList<Term> mappedTerms = new ArrayList<Term>();
        terms.forEach(term -> mappedTerms.addAll(this.mapToColumnNames(collection, term.copy())));
        Results results = this.doSelect(collection, mappedTerms);
        if (results.size() > 0) {
            for (int i = 0; i < results.size(); ++i) {
                Object attr2;
                JSMap node;
                Object row = results.getRow(i);
                if (collection == null) {
                    node = new JSMap(row);
                    results.setRow(i, node);
                    continue;
                }
                node = new JSMap();
                results.setRow(i, node);
                for (Object attr2 : collection.getProperties()) {
                    String attrName = ((Property)attr2).getJsonName();
                    String colName = ((Property)attr2).getColumnName();
                    boolean rowHas = row.containsKey(colName);
                    if (!rowHas) continue;
                    Object val = row.remove(colName);
                    val = this.castDbOutput((Property)attr2, val);
                    node.put(attrName, val);
                }
                ArrayList sorted = new ArrayList(row.keySet());
                Collections.sort(sorted);
                attr2 = sorted.iterator();
                while (attr2.hasNext()) {
                    String key = (String)attr2.next();
                    if (key.equalsIgnoreCase("href") || node.containsKey((Object)key)) continue;
                    Object value = row.get(key);
                    node.put(key, value);
                }
                Index idx = collection.getResourceIndex();
                if (idx == null) continue;
                for (int j = idx.size() - 1; j >= 0; --j) {
                    Property prop = idx.getProperty(j);
                    if (!node.containsKey((Object)prop.getJsonName())) continue;
                    node.putFirst(prop.getJsonName(), node.get((Object)prop.getJsonName()));
                }
            }
        }
        for (Term term2 : results.getNext()) {
            this.mapToJsonNames(collection, term2);
        }
        return results;
    }

    public Results doSelect(Collection collection, List<Term> queryTerms) throws ApiException {
        return new Results(null);
    }

    public final List<String> upsert(Collection collection, List<Map<String, Object>> records) throws ApiException {
        return this.doUpsert(collection, this.mapToColumnNames(collection, records));
    }

    public List<String> doUpsert(Collection collection, List<Map<String, Object>> records) throws ApiException {
        return Collections.EMPTY_LIST;
    }

    public List<String> patch(Collection collection, List<Map<String, Object>> records) throws ApiException {
        return this.doPatch(collection, this.mapToColumnNames(collection, records));
    }

    public List<String> doPatch(Collection collection, List<Map<String, Object>> rows) throws ApiException {
        return this.doUpsert(collection, rows);
    }

    public final void delete(Collection collection, List<Map<String, Object>> indexValues) throws ApiException {
        this.doDelete(collection, this.mapToColumnNames(collection, indexValues));
    }

    public void doDelete(Collection collection, List<Map<String, Object>> indexValues) throws ApiException {
    }

    protected void configApi(Api api) {
        for (Collection coll : this.getCollections()) {
            if (coll.isExclude()) continue;
            Index index = coll.getResourceIndex();
            if (index != null) {
                for (Property property : index.getProperties()) {
                    property.withNullable(false);
                }
            }
            api.withCollection(coll);
        }
    }

    protected void configDb() throws ApiException {
        if (this.collections.size() == 0) {
            this.buildCollections();
            this.buildRelationships();
        }
    }

    protected void buildCollections() {
        for (String tableName : this.includeTables.keySet()) {
            Collection collection = this.getCollectionByTableName(tableName);
            if (collection != null) continue;
            this.withCollection(new Collection(tableName));
        }
        for (Collection coll : this.getCollections()) {
            if (coll.getName().equals(coll.getTableName())) {
                String prettyName = this.beautifyCollectionName(coll.getTableName());
                String pluralName = Utils.toPluralForm((String)prettyName);
                String singularName = prettyName;
                coll.withName(pluralName);
                coll.withSingularDispalyName(Utils.capitalize((String)singularName));
                coll.withPluralDisplayName(Utils.capitalize((String)pluralName));
            }
            for (Property prop : coll.getProperties()) {
                if (!prop.getColumnName().equals(prop.getJsonName())) continue;
                String prettyName = this.beautifyName(prop.getColumnName());
                prop.withJsonName(prettyName);
            }
        }
    }

    protected void buildRelationships() {
        for (Collection coll : this.getCollections()) {
            Relationship r;
            if (coll.isLinkTbl()) {
                ArrayList<Index> indexes = coll.getIndexes();
                for (int i = 0; i < indexes.size(); ++i) {
                    for (int j = 0; j < indexes.size(); ++j) {
                        Index idx1 = (Index)indexes.get(i);
                        Index idx2 = (Index)indexes.get(j);
                        if (i == j || !idx1.getType().equals("FOREIGN_KEY") || !idx2.getType().equals("FOREIGN_KEY")) continue;
                        Collection resource1 = idx1.getProperty(0).getPk().getCollection();
                        Collection resource2 = idx2.getProperty(0).getPk().getCollection();
                        r = new Relationship();
                        r.withType("MANY_TO_MANY");
                        r.withRelated(resource2);
                        r.withFkIndex1(idx1);
                        r.withFkIndex2(idx2);
                        r.withName(this.makeRelationshipName(resource1, r));
                        r.withCollection(resource1);
                    }
                }
                continue;
            }
            for (Index fkIdx : coll.getIndexes()) {
                try {
                    if (!fkIdx.getType().equals("FOREIGN_KEY") || fkIdx.getProperty(0).getPk() == null) continue;
                    Collection pkResource = fkIdx.getProperty(0).getPk().getCollection();
                    Collection fkResource = fkIdx.getProperty(0).getCollection();
                    boolean oneToOne = false;
                    Index fkPk = fkResource.getResourceIndex();
                    Index pkPk = pkResource.getResourceIndex();
                    if (pkResource != fkResource && pkPk.isUnique() && fkPk.isUnique() && fkIdx.size() == fkPk.size()) {
                        List<String> pkCols = fkPk.getColumnNames();
                        List<String> fkCols = fkIdx.getColumnNames();
                        Collections.sort(pkCols);
                        Collections.sort(fkCols);
                        if (pkCols.toString().equalsIgnoreCase(fkCols.toString())) {
                            ArrayList<String> fkPkCols = new ArrayList<String>();
                            for (Property prop : fkIdx.getProperties()) {
                                fkPkCols.add(prop.getPk().getColumnName());
                            }
                            List<String> pkPkCols = pkPk.getColumnNames();
                            Collections.sort(fkPkCols);
                            Collections.sort(pkPkCols);
                            if (((Object)fkPkCols).toString().equalsIgnoreCase(pkPkCols.toString())) {
                                oneToOne = true;
                            }
                        }
                    }
                    if (oneToOne) {
                        r = new Relationship();
                        r.withType("ONE_TO_ONE_PARENT");
                        r.withFkIndex1(fkIdx);
                        r.withRelated(fkResource);
                        r.withName(this.makeRelationshipName(pkResource, r));
                        r.withCollection(pkResource);
                        r = new Relationship();
                        r.withType("ONE_TO_ONE_CHILD");
                        r.withFkIndex1(fkIdx);
                        r.withRelated(pkResource);
                        r.withName(this.makeRelationshipName(fkResource, r));
                        r.withCollection(fkResource);
                        continue;
                    }
                    r = new Relationship();
                    r.withType("ONE_TO_MANY");
                    r.withFkIndex1(fkIdx);
                    r.withRelated(fkResource);
                    r.withName(this.makeRelationshipName(pkResource, r));
                    r.withCollection(pkResource);
                    r = new Relationship();
                    r.withType("MANY_TO_ONE");
                    r.withFkIndex1(fkIdx);
                    r.withRelated(pkResource);
                    r.withName(this.makeRelationshipName(fkResource, r));
                    r.withCollection(fkResource);
                }
                catch (Exception ex) {
                    throw ApiException.new500InternalServerError(ex, "Error creating relationship for index: {}", fkIdx);
                }
            }
        }
    }

    protected String beautifyCollectionName(String tableName) {
        if (this.includeTables.containsKey(tableName)) {
            return this.includeTables.get(tableName);
        }
        String collectionName = this.beautifyName(tableName);
        return collectionName;
    }

    protected String beautifyName(String name) {
        return Utils.beautifyName((String)name);
    }

    protected String makeRelationshipName(Collection collection, Relationship relationship) {
        String name = null;
        String type = relationship.getType();
        String fkColName = relationship.getFk1Col1().getColumnName();
        if (fkColName.toLowerCase().endsWith("id") && fkColName.length() > 2) {
            fkColName = fkColName.substring(0, fkColName.length() - 2);
            while (fkColName.endsWith("_")) {
                fkColName = fkColName.substring(0, fkColName.length() - 1);
            }
        }
        fkColName = fkColName.trim();
        fkColName = this.beautifyName(fkColName);
        switch (type) {
            case "MANY_TO_ONE": {
                name = fkColName;
                break;
            }
            case "ONE_TO_MANY": {
                name = relationship.getRelated().getName();
                name = Utils.toPluralForm((String)name);
                break;
            }
            case "MANY_TO_MANY": {
                name = relationship.getFk2Col1().getPk().getCollection().getName();
                name = Utils.toPluralForm((String)name);
                break;
            }
            case "ONE_TO_ONE_PARENT": 
            case "ONE_TO_ONE_CHILD": {
                name = relationship.getRelated().getSingularDisplayName();
                name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            }
        }
        return name;
    }

    public Object castDbOutput(Property property, Object value) {
        String type = property.getType();
        if (type == null || value == null) {
            return value;
        }
        if ("json".equalsIgnoreCase(type = type.toLowerCase())) {
            String json = value.toString().trim();
            if (json.isEmpty()) {
                return new JSMap();
            }
            return JSParser.parseJson((String)json);
        }
        if (value instanceof byte[]) {
            value = Utils.bytesToHex((byte[])((byte[])value));
        } else if (Utils.in((Object)type, (Object[])new Object[]{"char", "nchar", "clob"})) {
            value = value.toString().trim();
        } else if (value instanceof Date && Utils.in((Object)type, (Object[])new Object[]{"date", "datetime", "timestamp"})) {
            value = Utils.formatIso8601((Date)((Date)value));
        }
        return value;
    }

    public Object castJsonInput(Property property, Object value) {
        return Db.castJsonInput(property != null ? property.getType() : null, value);
    }

    protected void mapToJsonNames(Collection collection, Term term) {
        if (collection == null) {
            return;
        }
        if (term.isLeaf() && !term.isQuoted()) {
            String token = term.getToken();
            Property attr = collection.findProperty(token);
            if (attr != null) {
                term.withToken(attr.getJsonName());
            }
        } else {
            for (Term child : term.getTerms()) {
                this.mapToJsonNames(collection, child);
            }
        }
    }

    protected Set<Term> mapToColumnNames(Collection collection, Term term) {
        HashSet<Term> terms = new HashSet<Term>();
        if (term.getParent() == null) {
            terms.add(term);
        }
        if (collection == null) {
            return terms;
        }
        if (term.isLeaf() && !term.isQuoted()) {
            String token = term.getToken();
            while (token.startsWith("-") || token.startsWith("+")) {
                token = token.substring(1);
            }
            StringBuilder name = new StringBuilder();
            String[] parts = token.split("\\.");
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                if (i == parts.length - 1) {
                    Property attr = collection.findProperty(parts[i]);
                    if (attr != null) {
                        name.append(attr.getColumnName());
                        continue;
                    }
                    name.append(parts[i]);
                    continue;
                }
                Relationship rel = collection.getRelationship(part);
                if (rel != null) {
                    name.append(rel.getName()).append(".");
                    collection = rel.getRelated();
                    continue;
                }
                name.append(parts[i]).append(".");
            }
            if (!Utils.empty((Object[])new Object[]{name.toString()})) {
                if (term.getToken().startsWith("-")) {
                    name.insert(0, "-");
                }
                term.withToken(name.toString());
            }
        } else {
            for (Term child : term.getTerms()) {
                terms.addAll(this.mapToColumnNames(collection, child));
            }
        }
        return terms;
    }

    protected List<Map<String, Object>> mapToColumnNames(Collection collection, List<Map<String, Object>> records) {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> node : records) {
            LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
            rows.add(row);
            for (String jsonProp : node.keySet()) {
                Object value = node.get(jsonProp);
                Property collProp = collection.getProperty(jsonProp);
                if (collProp == null) continue;
                value = this.castJsonInput(collProp, value);
                row.put(collProp.getColumnName(), value);
            }
            for (String columnName : row.keySet()) {
                if (!this.filterOutJsonProperty(collection, columnName)) continue;
                row.remove(columnName);
            }
        }
        return rows;
    }

    protected Property getProperty(String tableName, String columnName) {
        Collection collection = this.getCollectionByTableName(tableName);
        if (collection != null) {
            return collection.getPropertyByColumnName(columnName);
        }
        return null;
    }

    public Collection getCollection(String collectionOrTableName) {
        for (Collection c : this.collections) {
            if (!c.getName().equalsIgnoreCase(collectionOrTableName)) continue;
            return c;
        }
        return this.getCollectionByTableName(collectionOrTableName);
    }

    public Collection getCollectionByTableName(String tableName) {
        for (Collection t : this.collections) {
            if (!tableName.equalsIgnoreCase(t.getTableName())) continue;
            return t;
        }
        return null;
    }

    public void removeCollection(Collection table) {
        this.collections.remove(table);
    }

    public List<Collection> getCollections() {
        return new ArrayList<Collection>(this.collections);
    }

    public T withIncludeTables(String ... includeTables) {
        for (String includeTable : includeTables) {
            for (String pair : Utils.explode((String)",", (String[])new String[]{includeTable})) {
                String tableName = pair.indexOf(124) < 0 ? pair : pair.substring(0, pair.indexOf("|"));
                String collectionName = pair.indexOf(124) < 0 ? pair : pair.substring(pair.indexOf("|") + 1);
                this.withIncludeTable(tableName, collectionName);
            }
        }
        return (T)this;
    }

    public T withIncludeTable(String tableName, String collectionName) {
        String existing = this.includeTables.get(tableName);
        if (existing != null) {
            collectionName = existing + "," + collectionName;
        }
        this.includeTables.put(tableName, collectionName);
        return (T)this;
    }

    public T withCollections(Collection ... collections) {
        for (Collection collection : collections) {
            this.withCollection(collection);
        }
        return (T)this;
    }

    public T withCollection(Collection collection) {
        if (collection != null) {
            if (collection.getDb() != this) {
                collection.withDb(this);
            }
            if (!this.collections.contains(collection)) {
                this.collections.add(collection);
            }
        }
        return (T)this;
    }

    public boolean filterOutJsonProperty(Collection collection, String name) {
        String[] guesses = new String[]{name, collection.getName() + "." + name, collection.getTableName() + "." + name, collection.getTableName() + collection.getColumnName(name)};
        if (this.includeColumns.size() > 0 || this.excludeColumns.size() > 0) {
            boolean included = false;
            for (String guess : guesses) {
                if (this.excludeColumns.contains(guess)) {
                    return true;
                }
                if (!this.includeColumns.contains(guess)) continue;
                included = true;
            }
            if (!included && this.includeColumns.size() > 0) {
                return true;
            }
        }
        return reservedParams.contains(name) || name.startsWith("_");
    }

    public T withIncludeColumns(String ... columnNames) {
        this.includeColumns.addAll(Utils.explode((String)",", (String[])columnNames));
        return (T)this;
    }

    public T withExcludeColumns(String ... columnNames) {
        this.excludeColumns.addAll(Utils.explode((String)",", (String[])columnNames));
        return (T)this;
    }

    public boolean isType(String ... types) {
        String type = this.getType();
        if (type == null) {
            return false;
        }
        for (String t : types) {
            if (!type.equalsIgnoreCase(t)) continue;
            return true;
        }
        return false;
    }

    public String getType() {
        return this.type;
    }

    public T withType(String type) {
        this.type = type;
        return (T)this;
    }

    public boolean isBootstrap() {
        return this.bootstrap;
    }

    public T withBootstrap(boolean bootstrap) {
        this.bootstrap = bootstrap;
        return (T)this;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public T withDryRun(boolean dryRun) {
        this.dryRun = dryRun;
        return (T)this;
    }
}

