/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.ApiException;
import io.inversion.Db;
import io.inversion.Index;
import io.inversion.Property;
import io.inversion.Relationship;
import io.inversion.Rule;
import io.inversion.utils.Path;
import io.inversion.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.text.StringEscapeUtils;

public class Collection
extends Rule<Collection>
implements Serializable {
    protected final Set<String> aliases = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    protected final ArrayList<Property> properties = new ArrayList();
    protected final ArrayList<Index> indexes = new ArrayList();
    protected final ArrayList<Relationship> relationships = new ArrayList();
    protected transient Db db = null;
    protected String tableName = null;
    protected String pluralDisplayName = null;
    protected String singularDisplayName = null;
    protected String schemaRef = null;
    protected boolean exclude = false;

    public Collection() {
    }

    public Collection(String defaultName) {
        this.withName(defaultName);
        this.withTableName(defaultName);
    }

    @Override
    protected List<Rule.RuleMatcher> getDefaultIncludeMatchers() {
        String regex;
        String collection = "{_collection:" + this.getName() + "}";
        String resource = "[{_resource}]";
        String relationship = "[{_relationship}]";
        Index pk = this.getResourceIndex();
        if (pk != null && pk.size() == 1 && (regex = pk.getProperty(0).getRegex()) != null) {
            regex = regex + "(," + regex + ")*";
            resource = "[{_resource:" + regex + "}]";
        }
        return Utils.asList((Object[])new Object[]{new Rule.RuleMatcher(null, new Path(new String[]{collection + "/" + resource + "/" + relationship + "/*"}))});
    }

    public boolean isLinkTbl() {
        if (this.properties.size() == 0) {
            return false;
        }
        boolean isLinkTbl = true;
        for (Property c : this.properties) {
            if (c.isFk()) continue;
            isLinkTbl = false;
            break;
        }
        return isLinkTbl;
    }

    public Property getProperty(String jsonOrColumnName) {
        return this.findProperty(jsonOrColumnName);
    }

    public Property findProperty(String jsonOrColumnName) {
        Property prop = this.getPropertyByJsonName(jsonOrColumnName);
        if (prop == null) {
            prop = this.getPropertyByColumnName(jsonOrColumnName);
        }
        return prop;
    }

    public Property getPropertyByJsonName(String jsonName) {
        for (Property prop : this.properties) {
            if (!jsonName.equalsIgnoreCase(prop.getJsonName())) continue;
            return prop;
        }
        return null;
    }

    public Property getPropertyByColumnName(String columnName) {
        for (Property col : this.properties) {
            if (!columnName.equalsIgnoreCase(col.getColumnName())) continue;
            return col;
        }
        return null;
    }

    public String getColumnName(String jsonName) {
        Property prop = this.getPropertyByJsonName(jsonName);
        if (prop != null) {
            return prop.getColumnName();
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Collection) {
            Collection coll = (Collection)object;
            return (this.db == null || this.db == coll.db) && Utils.equal((Object)this.getTableName(), (Object)coll.getTableName()) && Utils.equal((Object)this.getName(), (Object)coll.getName());
        }
        return false;
    }

    public Db getDb() {
        return this.db;
    }

    public Collection withDb(Db db) {
        this.db = db;
        return this;
    }

    public String getTableName() {
        return this.tableName != null ? this.tableName : this.name;
    }

    public Collection withTableName(String name) {
        this.tableName = name;
        return this;
    }

    @Override
    public String getName() {
        return this.name != null ? this.name : this.tableName;
    }

    public Collection withSingularDispalyName(String singularName) {
        this.singularDisplayName = singularName;
        return this;
    }

    public String getSingularDisplayName() {
        return this.singularDisplayName != null ? this.singularDisplayName : this.getName();
    }

    public Collection withPluralDisplayName(String pluralName) {
        this.pluralDisplayName = pluralName;
        return this;
    }

    public String getPluralDisplayName() {
        return this.pluralDisplayName != null ? this.pluralDisplayName : this.getName();
    }

    public List<Property> getProperties() {
        return new ArrayList<Property>(this.properties);
    }

    public Collection withProperties(Property ... props) {
        for (Property prop : props) {
            if (this.getPropertyByJsonName(prop.getJsonName()) != null || this.getPropertyByColumnName(prop.getColumnName()) != null) continue;
            if (!this.properties.contains(prop)) {
                this.properties.add(prop);
            }
            if (prop.getCollection() == this) continue;
            prop.withCollection(this);
        }
        return this;
    }

    public Collection withProperty(String name, String type) {
        return this.withProperty(name, type, true);
    }

    public Collection withProperty(String name, String type, boolean nullable) {
        return this.withProperties(new Property(name, type, nullable));
    }

    public void removeProperty(Property prop) {
        this.properties.remove(prop);
    }

    public Index getResourceIndex() {
        for (Index index : this.indexes) {
            if (!"RESOURCE_KEY".equals(index.type)) continue;
            return index;
        }
        for (Index index : this.indexes) {
            if (!"PRIMARY_KEY".equals(index.type)) continue;
            return index;
        }
        Index found = null;
        for (Index index : this.indexes) {
            if (!index.isUnique()) continue;
            if (index.size() == 1) {
                return index;
            }
            if (found == null) {
                found = index;
                continue;
            }
            if (index.size() >= found.size()) continue;
            found = index;
        }
        return found;
    }

    public Index getIndexByType(String indexType) {
        for (Index index : this.indexes) {
            if (!indexType.equalsIgnoreCase(index.getType())) continue;
            return index;
        }
        return null;
    }

    public Index getIndex(String indexName) {
        for (Index index : this.indexes) {
            if (!indexName.equalsIgnoreCase(index.getName())) continue;
            return index;
        }
        return null;
    }

    public ArrayList<Index> getIndexes() {
        return new ArrayList<Index>(this.indexes);
    }

    public Collection withIndexes(Index ... indexes) {
        for (Index index : indexes) {
            if (!this.indexes.contains(index)) {
                this.indexes.add(index);
            }
            if (index.getCollection() == this) continue;
            index.withCollection(this);
        }
        return this;
    }

    public Collection withIndex(String name, String type, boolean unique, String ... propertyNames) {
        Property[] properties = new Property[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            String propName = propertyNames[i];
            Property prop = this.getProperty(propName);
            if (prop == null) {
                throw ApiException.new500InternalServerError("Property {} does not exist so it can't be added to the index {}", propertyNames[i], name);
            }
            properties[i] = prop;
        }
        Index index = this.getIndex(name);
        if (index == null) {
            index = new Index(name, type, unique, properties);
            this.withIndexes(index);
        } else {
            index.withType(type);
            index.withUnique(unique);
            index.withProperties(properties);
        }
        return this;
    }

    public Collection withForeignKey(Collection related, String ... myProperties) {
        Property[] properties = new Property[myProperties.length];
        for (int i = 0; i < myProperties.length; ++i) {
            String propName = myProperties[i];
            Property prop = this.getProperty(propName);
            if (prop == null) {
                throw ApiException.new500InternalServerError("Property {} does not exist so it can't be added to the index {}", myProperties[i], this.name);
            }
            properties[i] = prop;
        }
        Index fk = new Index(null, "FOREIGN_KEY", false, properties);
        Index pk = related.getResourceIndex();
        for (int i = 0; i < fk.size(); ++i) {
            fk.getProperty(i).withPk(pk.getProperty(i));
        }
        this.withIndexes(fk);
        return this;
    }

    public void removeIndex(Index index) {
        this.indexes.remove(index);
    }

    public boolean isExclude() {
        return this.exclude;
    }

    public Collection withExclude(boolean exclude) {
        this.exclude = exclude;
        return this;
    }

    public Relationship getRelationship(String name) {
        for (Relationship r : this.relationships) {
            if (!name.equalsIgnoreCase(r.getName())) continue;
            return r;
        }
        return null;
    }

    public List<Relationship> getRelationships() {
        return new ArrayList<Relationship>(this.relationships);
    }

    public void removeRelationship(Relationship relationship) {
        this.relationships.remove(relationship);
    }

    public Collection withRelationships(Relationship ... relationships) {
        for (Relationship rel : relationships) {
            this.withRelationship(rel);
        }
        return this;
    }

    public Collection withRelationship(Relationship relationship) {
        Relationship existing;
        String name = relationship.getName();
        Relationship relationship2 = existing = name != null ? this.getRelationship(name) : null;
        if (existing == null) {
            if (!this.relationships.contains(relationship)) {
                this.relationships.add(relationship);
            }
            if (relationship.getCollection() != this) {
                relationship.withCollection(this);
            }
        }
        return this;
    }

    public Collection withManyToOneRelationship(String thisCollectionsRelationshipJsonPropertyName, Collection parentCollection, String ... thisCollectionsForeignKeyProps) {
        if (thisCollectionsForeignKeyProps == null || thisCollectionsForeignKeyProps.length == 0) {
            throw ApiException.new500InternalServerError("A relationship must include at least one childFkProp", new Object[0]);
        }
        Property[] properties = new Property[thisCollectionsForeignKeyProps.length];
        for (int i = 0; i < thisCollectionsForeignKeyProps.length; ++i) {
            Property prop = this.getProperty(thisCollectionsForeignKeyProps[i]);
            if (prop == null) {
                throw ApiException.new500InternalServerError("Child foreign key property '{}.{}' can not be found.", this.getName(), properties[i]);
            }
            properties[i] = prop;
        }
        Index fkIdx = new Index(this.getName() + "_" + Arrays.asList(thisCollectionsForeignKeyProps), "FOREIGN_KEY", false, properties);
        this.withIndexes(fkIdx);
        this.withRelationship(new Relationship(thisCollectionsRelationshipJsonPropertyName, "MANY_TO_ONE", this, parentCollection, fkIdx, null));
        Index primaryIdx = parentCollection.getResourceIndex();
        if (primaryIdx != null && thisCollectionsForeignKeyProps.length == primaryIdx.size()) {
            for (int i = 0; i < thisCollectionsForeignKeyProps.length; ++i) {
                properties[i].withPk(primaryIdx.getProperty(i));
            }
        }
        return this;
    }

    public Collection withOneToManyRelationship(String thisCollectionsRelationshipJsonPropertyName, Collection childCollection, String ... childCollectionsForeignKeyProps) {
        if (childCollectionsForeignKeyProps == null || childCollectionsForeignKeyProps.length == 0) {
            throw ApiException.new500InternalServerError("A relationship must include at least one childFkProp", new Object[0]);
        }
        Property[] properties = new Property[childCollectionsForeignKeyProps.length];
        for (int i = 0; i < childCollectionsForeignKeyProps.length; ++i) {
            Property prop = childCollection.getProperty(childCollectionsForeignKeyProps[i]);
            if (prop == null) {
                throw ApiException.new500InternalServerError("Child foreign key property '{}.{}' can not be found.", childCollection.getName(), properties[i]);
            }
            properties[i] = prop;
        }
        Index fkIdx = new Index(childCollection.getName() + "_" + Arrays.asList(properties), "FOREIGN_KEY", false, properties);
        childCollection.withIndexes(fkIdx);
        this.withRelationship(new Relationship(thisCollectionsRelationshipJsonPropertyName, "ONE_TO_MANY", this, childCollection, fkIdx, null));
        Index primaryIdx = this.getResourceIndex();
        if (primaryIdx != null && properties.length == primaryIdx.size()) {
            for (int i = 0; i < properties.length; ++i) {
                properties[i].withPk(primaryIdx.getProperty(i));
            }
        }
        return this;
    }

    public boolean hasName(String nameOrAlias) {
        if (nameOrAlias == null) {
            return false;
        }
        return nameOrAlias.equalsIgnoreCase(this.getName()) || this.aliases.contains(nameOrAlias);
    }

    public Set<String> getAliases() {
        return new HashSet<String>(this.aliases);
    }

    public Collection withAliases(String ... aliases) {
        this.aliases.addAll(Arrays.asList(aliases));
        return this;
    }

    public String getSchemaRef() {
        return this.schemaRef;
    }

    public Collection withSchemaRef(String schemaRef) {
        this.schemaRef = schemaRef;
        return this;
    }

    public Collection copy() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this);
            oos.flush();
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
            Collection c = (Collection)ois.readObject();
            c.db = this.db;
            return c;
        }
        catch (Exception e) {
            Utils.rethrow((Throwable)e);
            return null;
        }
    }

    public String encodeKeyFromColumnNames(Map<String, Object> values) {
        Index index = this.getResourceIndex();
        if (index == null) {
            return null;
        }
        return Collection.encodeKey(values, index, false);
    }

    public String encodeKeyFromJsonNames(Map<String, Object> values) {
        Index index = this.getResourceIndex();
        if (index == null) {
            return null;
        }
        return Collection.encodeKey(values, index, true);
    }

    public String encodeKeyFromJsonNames(Map<String, Object> values, Index index) {
        return Collection.encodeKey(values, index, true);
    }

    public static String encodeKey(Map<String, Object> values, Index index, boolean useJsonPropertyNames) {
        StringBuilder key = new StringBuilder();
        for (String name : useJsonPropertyNames ? index.getJsonNames() : index.getColumnNames()) {
            Object val = values.get(name);
            if (Utils.empty((Object[])new Object[]{val})) {
                return null;
            }
            val = Collection.encodeStr(val.toString());
            if (key.length() > 0) {
                key.append("~");
            }
            key.append(val);
        }
        return key.toString();
    }

    public static String encodeKey(List pieces) {
        StringBuilder resourceKey = new StringBuilder();
        for (int i = 0; i < pieces.size(); ++i) {
            Object piece = pieces.get(i);
            if (piece == null) {
                throw ApiException.new500InternalServerError("Trying to encode an resource key with a null component: '{}'.", pieces);
            }
            resourceKey.append(Collection.decodeStr(piece.toString()));
            if (i >= pieces.size() - 1) continue;
            resourceKey.append("~");
        }
        return resourceKey.toString();
    }

    static String encodeStr(String string) {
        Pattern p = Pattern.compile("[^A-Za-z0-9\\-\\.\\_\\(\\)\\'\\!\\,\\;\\*]");
        Matcher m = p.matcher(string);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String chars = m.group();
            StringBuilder hex = new StringBuilder("@").append(Hex.encodeHex((byte[])chars.getBytes()));
            while (hex.length() < 5) {
                hex.insert(1, "0");
            }
            m.appendReplacement(sb, hex.toString());
        }
        m.appendTail(sb);
        String encoded = sb.toString();
        return encoded;
    }

    public Map<String, Object> decodeKeyToColumnNames(Index index, String inKey) {
        return this.decodeKey(index, inKey, false);
    }

    public Map<String, Object> decodeKeyToJsonNames(String inKeys) {
        Index index = this.getResourceIndex();
        if (index == null) {
            throw ApiException.new500InternalServerError("Table '{}' does not have a unique index", this.getTableName());
        }
        return this.decodeKey(index, inKeys, true);
    }

    public Map<String, Object> decodeKey(Index index, String key, boolean useJsonPropertyNames) {
        List<String> names = useJsonPropertyNames ? index.getJsonNames() : index.getColumnNames();
        LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
        List parts = Utils.explode((String)"~", (String[])new String[]{key});
        if (parts.size() != names.size()) {
            throw ApiException.new400BadRequest("Supplied resource key '{}' has {} part(s) but the primary index for table '{}' has {} part(s)", row, row.size(), this.getTableName(), index.size());
        }
        for (int i = 0; i < names.size(); ++i) {
            Object value = Collection.decodeStr(parts.get(i).toString());
            if (((String)value).length() == 0) {
                throw ApiException.new400BadRequest("A key component can not be empty '{}'", key);
            }
            if (!useJsonPropertyNames) {
                value = this.getDb().castJsonInput(index.getProperty(i), value);
            }
            row.put(names.get(i), value);
        }
        return row;
    }

    static String decodeStr(String string) {
        try {
            Pattern p = Pattern.compile("\\@[0-9a-f]{4}");
            Matcher m = p.matcher(string);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                String group = m.group();
                String hex = group.substring(1);
                String chars = StringEscapeUtils.unescapeJava((String)("\\u" + hex));
                if (chars.equals("\\")) {
                    chars = "\\\\";
                }
                m.appendReplacement(sb, chars);
            }
            m.appendTail(sb);
            return sb.toString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

