/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.Action;
import io.inversion.Api;
import io.inversion.ApiException;
import io.inversion.Collection;
import io.inversion.Endpoint;
import io.inversion.Engine;
import io.inversion.Relationship;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.Server;
import io.inversion.Url;
import io.inversion.User;
import io.inversion.json.JSList;
import io.inversion.json.JSMap;
import io.inversion.json.JSNode;
import io.inversion.utils.Path;
import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

public final class Chain {
    public static final Set<String> APPEND_PARAMS = Collections.unmodifiableSet((Set)Utils.add(new HashSet(), (Object[])new Object[]{"include", "exclude", "collapse"}));
    static ThreadLocal<Stack<Chain>> chainLocal = new ThreadLocal();
    protected final Engine engine;
    protected final List<ActionMatch> actions = new ArrayList<ActionMatch>();
    protected final Request request;
    protected final Response response;
    protected final CaseInsensitiveMap<String, Object> vars = new CaseInsensitiveMap();
    protected int next = 0;
    protected boolean canceled = false;
    protected User user = null;
    protected Chain parent = null;
    protected Set<String> pathParamsToRemove = new HashSet<String>();

    private Chain(Engine engine, Request req, Response res) {
        this.engine = engine;
        this.request = req;
        this.response = res;
    }

    public static void resetAll() {
        chainLocal = new ThreadLocal();
    }

    protected static Stack<Chain> get() {
        Stack<Chain> stack = chainLocal.get();
        if (stack == null) {
            stack = new Stack();
            chainLocal.set(stack);
        }
        return stack;
    }

    public static int getDepth() {
        return Chain.get().size();
    }

    public static boolean isRoot() {
        Stack<Chain> stack = Chain.get();
        return stack.isEmpty() || stack.size() == 1;
    }

    public static Chain first() {
        Stack<Chain> stack = Chain.get();
        if (!stack.empty()) {
            return (Chain)stack.get(0);
        }
        return null;
    }

    public static Chain top() throws ApiException {
        Stack<Chain> stack = Chain.get();
        if (!stack.empty()) {
            return stack.peek();
        }
        throw ApiException.new500InternalServerError("Attempting to call Chain.top() when there is no Chain on the ThreadLocal.", new Object[0]);
    }

    public static Chain peek() {
        Stack<Chain> stack = Chain.get();
        if (!stack.empty()) {
            return stack.peek();
        }
        return null;
    }

    public static Chain push(Engine engine, Request req, Response res) {
        Chain child = new Chain(engine, req, res);
        Chain parent = Chain.peek();
        if (parent != null) {
            child.setParent(parent);
        }
        req.withChain(child);
        Chain.get().push(child);
        return child;
    }

    public static Chain pop() {
        return Chain.get().pop();
    }

    public static User getUser() {
        Chain chain = Chain.peek();
        if (chain != null) {
            do {
                if (chain.user == null) continue;
                return chain.user;
            } while ((chain = chain.parent) != null);
        }
        return null;
    }

    public static int size() {
        return Chain.get().size();
    }

    public static void debug(String format, Object ... args) {
        if (format == null || format.trim().length() == 0) {
            return;
        }
        Stack<Chain> stack = Chain.get();
        if (stack.size() < 1) {
            return;
        }
        StringBuilder prefix = new StringBuilder("[" + stack.size() + "]: ");
        for (int i = 1; i < stack.size(); ++i) {
            prefix.append("   ");
        }
        format = prefix.toString() + format;
        Chain root = (Chain)stack.get(0);
        root.response.debug(format, args);
    }

    public static String buildLink(JSMap fromHere, Relationship toHere) {
        String link = null;
        if (toHere.isManyToOne()) {
            String fkval = null;
            if (toHere.getRelated().getResourceIndex().size() != toHere.getFkIndex1().size() && toHere.getFkIndex1().size() == 1) {
                fkval = toHere.getCollection().encodeKeyFromJsonNames((Map<String, Object>)fromHere, toHere.getFkIndex1());
            } else {
                Object obj = fromHere.get((Object)toHere.getFk1Col1().getJsonName());
                if (obj != null) {
                    fkval = obj.toString();
                }
            }
            if (fkval != null) {
                link = Chain.buildLink(toHere.getRelated(), fkval);
            }
        } else {
            String resourceKey = toHere.getCollection().encodeKeyFromJsonNames((Map<String, Object>)fromHere);
            link = Chain.buildLink(toHere.getCollection(), resourceKey);
        }
        return link;
    }

    public static String buildLink(Collection collection) {
        return Chain.buildLink(collection, null);
    }

    public static String buildLink(Collection collection, String resourceKey) {
        return Chain.buildLink(collection, resourceKey, null);
    }

    public static String buildLink(Collection collection, String resourceKey, String relationshipKey) {
        Request req = Chain.top().getRequest();
        return req.getApi().getLinker().buildLink(req, collection, resourceKey, relationshipKey);
    }

    public Chain withUser(User user) {
        this.user = user;
        return this;
    }

    public Chain getParent() {
        return this.parent;
    }

    public void setParent(Chain parent) {
        this.parent = parent;
    }

    public void put(String key, Object value) {
        this.vars.put((Object)key, value);
    }

    public boolean isDebug() {
        if (this.parent != null) {
            return this.parent.isDebug();
        }
        return this.request.isDebug();
    }

    public Object get(String key) {
        if (this.vars.containsKey((Object)key)) {
            return this.vars.get((Object)key);
        }
        String value = this.request.getUrl().getParam(key);
        if (value != null) {
            return value;
        }
        if (this.parent != null) {
            return this.parent.get(key);
        }
        return null;
    }

    public Object remove(String key) {
        if (this.vars.containsKey((Object)key)) {
            return this.vars.remove((Object)key);
        }
        return this.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go() throws ApiException {
        boolean root = this.next == 0;
        try {
            while (this.next()) {
            }
        }
        finally {
            if (root) {
                JSNode json = null;
                try {
                    json = this.request.getJson();
                }
                catch (Exception exception) {}
                this.filterPathParams(json);
            }
        }
    }

    public Chain filterPathParams(JSNode json) {
        if (json != null && this.request.pathParams.size() > 0) {
            json.streamAll().filter(node -> node instanceof JSNode && !(node instanceof JSList)).forEach(node -> this.pathParamsToRemove.forEach(key -> ((JSNode)node).remove(new Object[]{key})));
        }
        return this;
    }

    public Chain skipNext() {
        ++this.next;
        return this;
    }

    public Action getNext() {
        if (this.hasNext()) {
            return this.actions.get((int)this.next).action;
        }
        return null;
    }

    public boolean next() throws ApiException {
        if (!this.isCanceled() && this.next < this.actions.size()) {
            ActionMatch actionMatch = this.actions.get(this.next);
            ++this.next;
            HashMap<String, String> pathParams = new HashMap<String, String>();
            if (actionMatch.path != null) {
                actionMatch.rule.extract(pathParams, new Path(actionMatch.path));
                JSNode json = null;
                try {
                    json = this.request.getJson();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.applyPathParams(pathParams, this.request.getUrl(), json);
            }
            actionMatch.action.run(this.request, this.response);
            return true;
        }
        return false;
    }

    void applyPathParams(Map<String, String> pathParamsToAdd, Url url, JSNode json) {
        pathParamsToAdd.keySet().forEach(xva$0 -> url.clearParams((String)xva$0));
        pathParamsToAdd.entrySet().stream().filter(e -> e.getValue() != null).forEach(e -> url.withParam((String)e.getKey(), (String)e.getValue()));
        if (json != null) {
            json.asList().stream().filter(node -> node instanceof JSMap).forEach(node -> pathParamsToAdd.entrySet().stream().filter(e -> e.getValue() != null && !((String)e.getKey()).startsWith("_")).forEach(e -> ((JSNode)node).put(e.getKey(), e.getValue())));
        }
        this.pathParamsToRemove.addAll(pathParamsToAdd.keySet());
    }

    public boolean hasNext() {
        return !this.isCanceled() && this.next < this.actions.size();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void cancel() {
        this.canceled = true;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public Api getApi() {
        return this.request.getApi();
    }

    public Server getServer() {
        return this.request.getServer();
    }

    public Endpoint getEndpoint() {
        return this.request.getEndpoint();
    }

    public List<ActionMatch> getActions() {
        return new ArrayList<ActionMatch>(this.actions);
    }

    public Chain withActions(List<ActionMatch> actions) {
        for (ActionMatch action : actions) {
            this.withAction(action);
        }
        return this;
    }

    public Chain withAction(ActionMatch action) {
        if (action != null && !this.actions.contains(action)) {
            this.actions.add(action);
        }
        return this;
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public static class ActionMatch
    implements Comparable<ActionMatch> {
        final Path rule;
        final Path path;
        final Action action;

        public ActionMatch(Path rule, Path path, Action action) {
            this.rule = rule;
            this.path = path;
            this.action = action;
        }

        @Override
        public int compareTo(ActionMatch o) {
            return this.action.compareTo(o.action);
        }

        public String toString() {
            return this.rule + " " + this.path + " " + this.action;
        }

        public Path getRule() {
            return this.rule;
        }

        public Path getPath() {
            return this.path;
        }

        public Action getAction() {
            return this.action;
        }
    }
}

