/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.Api;
import io.inversion.ApiException;
import io.inversion.Db;
import io.inversion.Op;
import io.inversion.Param;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.Rule;
import io.inversion.action.openapi.OpenAPIWriter;
import io.inversion.utils.Path;
import io.inversion.utils.Task;
import io.inversion.utils.Utils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class Action<A extends Action>
extends Rule<A>
implements OpenAPIWriter<A> {
    boolean decoration = false;

    public List<Path> getFullIncludePaths(Api api, Db db, String method, Path endpointPath, boolean relative) {
        endpointPath = new Path(endpointPath);
        Path base = new Path();
        if (relative) {
            while (endpointPath.size() > 0 && !endpointPath.isOptional(0) && !endpointPath.isWildcard(0)) {
                base.add(endpointPath.remove(0));
            }
        }
        LinkedHashSet<Path> fullPaths = new LinkedHashSet<Path>();
        List endpointSubPaths = endpointPath.getSubPaths();
        for (Path endpointSubPath : endpointSubPaths) {
            for (Path actionSubPath : this.getIncludePaths(api, db, method)) {
                Path fullPath = Action.joinPaths(endpointSubPath, actionSubPath, relative);
                if (fullPath == null) continue;
                fullPaths.add(new Path(new String[]{base.toString(), fullPath.toString()}));
            }
        }
        ArrayList<Path> returnPaths = new ArrayList<Path>(fullPaths);
        return returnPaths;
    }

    protected LinkedHashSet<Path> getIncludePaths(Api api, Db db, String method) {
        LinkedHashSet<Path> includePaths = new LinkedHashSet<Path>();
        for (Rule.RuleMatcher matcher : this.getIncludeMatchers()) {
            if (!matcher.hasMethod(method)) continue;
            for (Path actionPath : matcher.getPaths()) {
                includePaths.addAll(actionPath.getSubPaths());
            }
        }
        return includePaths;
    }

    public static Path joinPaths(Path endpointPath, Path actionPath, boolean relative) {
        Path val = Action.joinPaths0(endpointPath, actionPath, relative);
        return val;
    }

    public static Path joinPaths0(Path endpointPath, Path actionPath, boolean relative) {
        endpointPath = new Path(endpointPath);
        actionPath = new Path(actionPath);
        Path merged = new Path();
        while (true) {
            if (endpointPath.isWildcard()) {
                merged = new Path(new String[]{merged.toString(), actionPath.toString()});
                break;
            }
            if (actionPath.isWildcard()) {
                merged = new Path(new String[]{merged.toString(), endpointPath.toString()});
                break;
            }
            if (endpointPath.size() == 0 || actionPath.size() == 0) {
                if (endpointPath.size() == actionPath.size()) break;
                return null;
            }
            if ((endpointPath.size() == 0 || actionPath.size() == 0) && actionPath.size() != endpointPath.size()) {
                return null;
            }
            boolean epVar = endpointPath.isVar(0);
            boolean aVar = actionPath.isVar(0);
            String epVal = Path.unwrapOptional((String)endpointPath.remove(0));
            String aVal = Path.unwrapOptional((String)actionPath.remove(0));
            if (!epVar && !aVar) {
                if (!epVal.equalsIgnoreCase(aVal)) {
                    return null;
                }
                merged.add(epVal);
                continue;
            }
            if (!aVar) {
                merged.add(aVal);
                continue;
            }
            merged.add(epVal);
        }
        return merged;
    }

    public void configureOp(Task task, Op op) {
        this.getParams().forEach(p -> op.withParam((Param)p));
    }

    public void run(Request req, Response res) throws ApiException {
        this.run0(req, res);
    }

    protected void run0(Request req, Response res) throws ApiException {
        String collectionKey = req.getCollectionKey();
        String methodKey = req.getUrl().getParam("_method");
        Method method = null;
        if (methodKey != null) {
            method = Utils.getMethod(this.getClass(), (String)methodKey);
        }
        if (method == null && collectionKey != null) {
            method = Utils.getMethod(this.getClass(), (String)("do" + collectionKey + req.getMethod()));
        }
        if (method == null) {
            method = Utils.getMethod(this.getClass(), (String)("do" + collectionKey));
        }
        if (method == null) {
            method = Utils.getMethod(this.getClass(), (String)("do" + req.getMethod()));
        }
        if (method != null) {
            try {
                method.invoke((Object)this, req, res);
            }
            catch (Throwable ex) {
                if (!(ex instanceof ApiException)) {
                    ex = ex.getCause();
                }
                ex.printStackTrace();
                if (!(ex instanceof ApiException)) {
                    ex = ApiException.new500InternalServerError(ex);
                }
                throw (ApiException)ex;
            }
        }
    }

    public void doGet(Request req, Response res) throws ApiException {
    }

    public void doPost(Request req, Response res) throws ApiException {
    }

    public void doPut(Request req, Response res) throws ApiException {
    }

    public void doPatch(Request req, Response res) throws ApiException {
    }

    public void doDelete(Request req, Response res) throws ApiException {
    }

    public boolean isDecoration() {
        return this.decoration;
    }

    public A withDecoration(boolean decoration) {
        this.decoration = decoration;
        return (A)this;
    }
}

