/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.web.compiler.spi;

import io.inverno.core.compiler.spi.BeanQualifiedName;
import io.inverno.core.compiler.spi.ModuleQualifiedName;
import io.inverno.core.compiler.spi.QualifiedName;
import io.inverno.core.compiler.spi.QualifiedNameFormatException;

public class WebRouteQualifiedName
extends QualifiedName {
    private final BeanQualifiedName controllerQName;
    private final String name;

    public WebRouteQualifiedName(String name) throws QualifiedNameFormatException {
        super(":" + name);
        this.controllerQName = null;
        this.name = name;
        this.validateQualifiedNamePart(this.name);
    }

    public WebRouteQualifiedName(BeanQualifiedName controllerQName, String name) throws QualifiedNameFormatException {
        super(controllerQName.getValue() + ":" + name);
        this.controllerQName = controllerQName;
        this.name = name;
        this.validateQualifiedNamePart(this.name);
    }

    public String getSimpleValue() {
        return this.getName();
    }

    public BeanQualifiedName getControllerQName() {
        return this.controllerQName;
    }

    public String getName() {
        return this.name;
    }

    public static WebRouteQualifiedName valueOf(String qname) throws QualifiedNameFormatException {
        int lastSeparatorIndex = qname.lastIndexOf(":");
        if (lastSeparatorIndex == -1) {
            throw new QualifiedNameFormatException("Invalid qname " + qname + ", was expecting: WebControllerQualifiedName():<routeName>");
        }
        return new WebRouteQualifiedName(BeanQualifiedName.valueOf((String)qname.substring(0, lastSeparatorIndex)), qname.substring(lastSeparatorIndex + 1));
    }

    public static WebRouteQualifiedName valueOf(ModuleQualifiedName moduleQName, String qname) throws QualifiedNameFormatException {
        String[] qnameParts = qname.split(":");
        if (qnameParts.length != 2) {
            throw new QualifiedNameFormatException("Invalid qname " + qname + ", was expecting: <controllerName>:<routeName>");
        }
        return new WebRouteQualifiedName(new BeanQualifiedName(moduleQName, qnameParts[0]), qnameParts[1]);
    }
}

