/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.web.compiler.spi;

import io.inverno.core.compiler.spi.BeanQualifiedName;
import io.inverno.core.compiler.spi.QualifiedName;
import io.inverno.core.compiler.spi.QualifiedNameFormatException;
import io.inverno.mod.web.compiler.spi.WebRouteQualifiedName;

public class WebParameterQualifiedName
extends QualifiedName {
    private final WebRouteQualifiedName routeQName;
    private final String name;

    public WebParameterQualifiedName(WebRouteQualifiedName routeQName, String name) throws QualifiedNameFormatException {
        super(routeQName.getValue() + "." + name);
        this.routeQName = routeQName;
        this.name = name;
    }

    public String getSimpleValue() {
        return this.getParameterName();
    }

    public WebRouteQualifiedName getRouteQName() {
        return this.routeQName;
    }

    public String getParameterName() {
        return this.name;
    }

    public static WebParameterQualifiedName valueOf(String qname) throws QualifiedNameFormatException {
        int lastSeparatorIndex = qname.lastIndexOf(".");
        if (lastSeparatorIndex == -1) {
            throw new QualifiedNameFormatException("Invalid qname " + qname + ", was expecting: WebParameterQualifiedName().<parameterName>");
        }
        return new WebParameterQualifiedName(WebRouteQualifiedName.valueOf(qname.substring(0, lastSeparatorIndex)), qname.substring(lastSeparatorIndex + 1));
    }

    public static WebParameterQualifiedName valueOf(BeanQualifiedName controllerQName, String qname) throws QualifiedNameFormatException {
        String[] qnameParts = qname.split(".");
        if (qnameParts.length < 2) {
            throw new QualifiedNameFormatException("Invalid qname " + qname + ", was expecting: <routeName>.<parameterName>");
        }
        return new WebParameterQualifiedName(new WebRouteQualifiedName(controllerQName, qnameParts[0]), qnameParts[1]);
    }
}

