/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.web.compiler.internal;

import io.inverno.mod.base.net.URIs;
import io.inverno.mod.web.compiler.internal.WebRouterConfigurerOpenApiGenerationContext;
import io.inverno.mod.web.compiler.spi.WebBasicParameterInfo;
import io.inverno.mod.web.compiler.spi.WebControllerInfo;
import io.inverno.mod.web.compiler.spi.WebCookieParameterInfo;
import io.inverno.mod.web.compiler.spi.WebExchangeParameterInfo;
import io.inverno.mod.web.compiler.spi.WebFormParameterInfo;
import io.inverno.mod.web.compiler.spi.WebHeaderParameterInfo;
import io.inverno.mod.web.compiler.spi.WebParameterInfo;
import io.inverno.mod.web.compiler.spi.WebPathParameterInfo;
import io.inverno.mod.web.compiler.spi.WebProvidedRouterConfigurerInfo;
import io.inverno.mod.web.compiler.spi.WebQueryParameterInfo;
import io.inverno.mod.web.compiler.spi.WebRequestBodyParameterInfo;
import io.inverno.mod.web.compiler.spi.WebResponseBodyInfo;
import io.inverno.mod.web.compiler.spi.WebRouteInfo;
import io.inverno.mod.web.compiler.spi.WebRouterConfigurerInfo;
import io.inverno.mod.web.compiler.spi.WebRouterConfigurerInfoVisitor;
import io.inverno.mod.web.compiler.spi.WebSseEventFactoryParameterInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

class WebRouterConfigurerOpenApiGenerator
implements WebRouterConfigurerInfoVisitor<StringBuilder, WebRouterConfigurerOpenApiGenerationContext> {
    private static final String OPENAPI_VERSION = "3.0.3";

    WebRouterConfigurerOpenApiGenerator() {
    }

    @Override
    public StringBuilder visit(WebRouterConfigurerInfo routerConfigurerInfo, WebRouterConfigurerOpenApiGenerationContext context) {
        if (context.getMode() == WebRouterConfigurerOpenApiGenerationContext.GenerationMode.ROUTER_SPEC) {
            StringBuilder result = new StringBuilder();
            result.append("openapi: ").append(OPENAPI_VERSION).append("\n");
            result.append("info:\n");
            result.append(context.indent(1)).append("title: '").append(routerConfigurerInfo.getQualifiedName().getModuleQName().toString()).append("'\n");
            WebRouterConfigurerOpenApiGenerationContext dctContext = context.withDocElement(routerConfigurerInfo.getElement());
            ((WebRouterConfigurerOpenApiGenerationContext)dctContext.withIndentDepthAdd(1)).getDescription().ifPresent(description -> result.append(context.indent(1)).append("description: ").append((CharSequence)description).append("\n"));
            ((WebRouterConfigurerOpenApiGenerationContext)dctContext.withIndentDepthAdd(1)).getContact().ifPresent(contact -> result.append(context.indent(1)).append("contact: \n").append((CharSequence)contact).append("\n"));
            ((WebRouterConfigurerOpenApiGenerationContext)dctContext.withIndentDepthAdd(1)).getVersion().ifPresentOrElse(version -> result.append(context.indent(1)).append("version: ").append((CharSequence)version).append("\n"), () -> result.append(context.indent(1)).append("version: ''").append("\n"));
            result.append("tags: ").append("\n");
            result.append((CharSequence)Arrays.stream(routerConfigurerInfo.getControllers()).map(controller -> this.visit((WebControllerInfo)controller, ((WebRouterConfigurerOpenApiGenerationContext)context.withIndentDepthAdd(1)).withMode(WebRouterConfigurerOpenApiGenerationContext.GenerationMode.CONTROLLER_TAG))).collect(context.joining("\n"))).append("\n");
            result.append("paths: ").append("\n");
            Map routesByPath = Arrays.stream(routerConfigurerInfo.getControllers()).flatMap(controller -> Arrays.stream(controller.getRoutes()).flatMap(route -> {
                Stream<String> routePathStream = route.getPaths().length > 0 ? Arrays.stream(route.getPaths()).map(path -> route.getController().map(WebControllerInfo::getRootPath).map(rootPath -> URIs.uri((String)rootPath, (URIs.Option[])new URIs.Option[]{URIs.Option.PARAMETERIZED, URIs.Option.NORMALIZED}).path(path, false).buildRawPath()).orElse((String)path)) : Stream.of(route.getController().map(WebControllerInfo::getRootPath).orElse("/"));
                return routePathStream.map(path -> new Object[]{path, route});
            })).collect(Collectors.groupingBy(pathAndRoute -> (String)pathAndRoute[0], Collectors.mapping(pathAndRoute -> (WebRouteInfo)pathAndRoute[1], Collectors.toList())));
            result.append((CharSequence)routesByPath.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(e -> new StringBuilder(context.indent(1)).append((String)e.getKey()).append(":\n").append((CharSequence)((List)e.getValue()).stream().map(route -> this.visit((WebRouteInfo)route, ((WebRouterConfigurerOpenApiGenerationContext)context.withIndentDepthAdd(2)).withMode(WebRouterConfigurerOpenApiGenerationContext.GenerationMode.ROUTE_PATH))).collect(context.joining("\n")))).collect(context.joining("\n")));
            ((WebRouterConfigurerOpenApiGenerationContext)context.withIndentDepthAdd(2)).getComponentsSchemas().ifPresent(componentsSchemas -> {
                result.append("\n").append(context.indent(0)).append("components: \n");
                result.append(context.indent(1)).append("schemas: \n");
                result.append((CharSequence)componentsSchemas);
            });
            return result;
        }
        return new StringBuilder();
    }

    @Override
    public StringBuilder visit(WebProvidedRouterConfigurerInfo providedRouterConfigurerInfo, WebRouterConfigurerOpenApiGenerationContext context) {
        return new StringBuilder();
    }

    @Override
    public StringBuilder visit(WebControllerInfo controllerInfo, WebRouterConfigurerOpenApiGenerationContext context) {
        if (context.getMode() == WebRouterConfigurerOpenApiGenerationContext.GenerationMode.CONTROLLER_TAG) {
            StringBuilder result = new StringBuilder();
            result.append(context.indentList(0)).append("name: '").append(controllerInfo.getQualifiedName().getSimpleValue()).append("'");
            WebRouterConfigurerOpenApiGenerationContext dctContext = context.withDocElement(controllerInfo.getElement());
            dctContext.getDescription().ifPresent(description -> result.append("\n").append(context.indent(0)).append("description: ").append((CharSequence)description));
            return result;
        }
        return new StringBuilder();
    }

    @Override
    public StringBuilder visit(WebRouteInfo routeInfo, WebRouterConfigurerOpenApiGenerationContext context) {
        if (context.getMode() == WebRouterConfigurerOpenApiGenerationContext.GenerationMode.ROUTE_PATH) {
            List formParameters;
            StringBuilder operation = new StringBuilder();
            operation.append(context.indent(1)).append("tags: ");
            routeInfo.getController().ifPresent(controller -> operation.append("\n").append(context.indentList(2)).append(controller.getQualifiedName().getSimpleValue()));
            WebRouterConfigurerOpenApiGenerationContext dctContext = routeInfo.getElement().map(context::withDocElement).orElse(context);
            dctContext.getSummary().ifPresent(summary -> operation.append("\n").append(context.indent(1)).append("summary: ").append((CharSequence)summary));
            dctContext.getDescription().ifPresent(description -> operation.append("\n").append(context.indent(1)).append("description: ").append((CharSequence)description));
            routeInfo.getElement().filter(element -> context.getElementUtils().isDeprecated((Element)element)).ifPresent(element -> operation.append("\n").append(context.indent(1)).append("deprecated: true"));
            StringBuilder parametersBuilder = (StringBuilder)Arrays.stream(routeInfo.getParameters()).map(parameter -> this.visit((WebParameterInfo)parameter, ((WebRouterConfigurerOpenApiGenerationContext)dctContext.withIndentDepthAdd(2)).withMode(WebRouterConfigurerOpenApiGenerationContext.GenerationMode.ROUTE_PARAMETER).withWebRoute(routeInfo))).filter(parameterBuilder -> parameterBuilder.length() > 0).collect(context.joining("\n"));
            if (parametersBuilder.length() > 0) {
                operation.append("\n").append(context.indent(1)).append("parameters:");
                operation.append("\n").append((CharSequence)parametersBuilder);
            }
            if (!(formParameters = Arrays.stream(routeInfo.getParameters()).filter(parameter -> parameter instanceof WebFormParameterInfo).map(parameter -> (WebFormParameterInfo)parameter).collect(Collectors.toList())).isEmpty()) {
                operation.append("\n").append(context.indent(1)).append("requestBody: ").append("\n");
                operation.append(context.indent(2)).append("content: ").append("\n");
                operation.append(context.indent(3)).append("application/x-www-form-urlencoded").append(": \n");
                operation.append(context.indent(4)).append("schema: \n");
                operation.append(context.indent(5)).append("type: object\n");
                operation.append(context.indent(5)).append("properties: \n");
                operation.append((CharSequence)formParameters.stream().map(formParameter -> this.visit((WebFormParameterInfo)formParameter, ((WebRouterConfigurerOpenApiGenerationContext)dctContext.withIndentDepthAdd(6)).withMode(WebRouterConfigurerOpenApiGenerationContext.GenerationMode.ROUTE_BODY).withWebRoute(routeInfo))).collect(context.joining("\n")));
            } else {
                Arrays.stream(routeInfo.getParameters()).filter(parameter -> parameter instanceof WebRequestBodyParameterInfo).findFirst().map(parameter -> (WebRequestBodyParameterInfo)parameter).ifPresent(requestBody -> {
                    if (requestBody.getBodyKind() == WebRequestBodyParameterInfo.RequestBodyKind.MULTIPART) {
                        operation.append("\n").append(context.indent(1)).append("requestBody: ").append("\n");
                        operation.append(context.indent(2)).append("content: ").append("\n");
                        operation.append(context.indent(3)).append("multipart/form-data").append(": \n");
                        operation.append(context.indent(4)).append("schema: \n");
                        operation.append(context.indent(5)).append("type: object\n");
                    } else {
                        operation.append("\n").append(context.indent(1)).append("requestBody:").append("\n");
                        operation.append((CharSequence)this.visit((WebRequestBodyParameterInfo)requestBody, ((WebRouterConfigurerOpenApiGenerationContext)dctContext.withIndentDepthAdd(2)).withMode(WebRouterConfigurerOpenApiGenerationContext.GenerationMode.ROUTE_BODY).withWebRoute(routeInfo)));
                    }
                });
            }
            operation.append("\n").append(context.indent(1)).append("responses:");
            routeInfo.getElement().map(routeElement -> dctContext.getResponses((ExecutableElement)routeElement, routeInfo.getResponseBody().getType())).ifPresentOrElse(responses -> operation.append("\n").append((CharSequence)responses.stream().collect(Collectors.groupingBy(WebRouterConfigurerOpenApiGenerationContext.ResponseSpec::getStatus)).entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(statusEntry -> {
                StringBuilder responseBuilder = new StringBuilder();
                responseBuilder.append(context.indent(2)).append((String)statusEntry.getKey()).append(": ").append("\n");
                responseBuilder.append(context.indent(3)).append("description: '");
                responseBuilder.append((CharSequence)((List)statusEntry.getValue()).stream().map(WebRouterConfigurerOpenApiGenerationContext.ResponseSpec::getDescription).map(description -> description.deleteCharAt(0).deleteCharAt(description.length() - 1)).filter(sb -> sb.length() > 0).collect(context.joining("<br/>")));
                responseBuilder.append("'");
                Collection<TypeMirror> responseTypes = ((List)statusEntry.getValue()).stream().collect(Collectors.groupingBy(response -> response.getType().toString(), Collectors.collectingAndThen(Collectors.toList(), l -> ((WebRouterConfigurerOpenApiGenerationContext.ResponseSpec)l.get(0)).getType()))).values();
                if (responseTypes.size() > 1) {
                    responseBuilder.append("\n").append(context.indent(3)).append("content: \n");
                    StringBuilder responseSchemaBuilder = new StringBuilder();
                    responseSchemaBuilder.append(context.indent(5)).append("schema: \n");
                    responseSchemaBuilder.append(context.indent(6)).append("oneOf: \n");
                    responseSchemaBuilder.append((CharSequence)responseTypes.stream().map(responseType -> ((WebRouterConfigurerOpenApiGenerationContext)context.withIndentDepthAdd(7)).getSchema((TypeMirror)responseType, true)).filter(Optional::isPresent).map(Optional::get).collect(context.joining("\n")));
                    if (routeInfo.getProduces().length > 0) {
                        for (String produce : routeInfo.getProduces()) {
                            responseBuilder.append(context.indent(4)).append(produce).append(": \n");
                            responseBuilder.append((CharSequence)responseSchemaBuilder);
                        }
                    } else {
                        responseBuilder.append(context.indent(4)).append("'*/*'").append(": \n");
                        responseBuilder.append((CharSequence)responseSchemaBuilder);
                    }
                } else if (responseTypes.size() > 0) {
                    TypeMirror responseType2 = responseTypes.iterator().next();
                    Optional<StringBuilder> responseSchema = ((WebRouterConfigurerOpenApiGenerationContext)context.withIndentDepthAdd(6)).getSchema(responseType2, false).map(schema -> schema.insert(0, new StringBuilder(context.indent(5)).append("schema: \n")));
                    if (responseSchema.isPresent()) {
                        responseBuilder.append("\n").append(context.indent(3)).append("content: \n");
                        if (routeInfo.getProduces().length > 0) {
                            for (String produce : routeInfo.getProduces()) {
                                responseBuilder.append(context.indent(4)).append(produce).append(": \n");
                                responseBuilder.append((CharSequence)responseSchema.get());
                            }
                        } else {
                            responseBuilder.append(context.indent(4)).append("'*/*'").append(": \n");
                            responseBuilder.append((CharSequence)responseSchema.get());
                        }
                    }
                }
                return responseBuilder;
            }).collect(context.joining("\n"))), () -> {
                operation.append("\n").append(context.indent(3)).append("default: ");
                operation.append("\n").append(context.indent(4)).append("description: ''");
            });
            return (StringBuilder)Arrays.stream(routeInfo.getMethods()).map(method -> {
                StringBuilder methodOperation = new StringBuilder();
                methodOperation.append(context.indent(0)).append(method.toString().toLowerCase()).append(":\n");
                methodOperation.append(context.indent(1)).append("operationId: '").append(method.toString().toLowerCase()).append("_").append(routeInfo.getQualifiedName().getControllerQName().getSimpleValue()).append("_").append(routeInfo.getQualifiedName().getSimpleValue()).append("'\n");
                methodOperation.append((CharSequence)operation);
                return methodOperation;
            }).collect(context.joining("\n"));
        }
        return new StringBuilder();
    }

    @Override
    public StringBuilder visit(WebResponseBodyInfo responseBodyInfo, WebRouterConfigurerOpenApiGenerationContext context) {
        return new StringBuilder();
    }

    @Override
    public StringBuilder visit(WebParameterInfo parameterInfo, WebRouterConfigurerOpenApiGenerationContext context) {
        if (parameterInfo instanceof WebFormParameterInfo) {
            return this.visit((WebFormParameterInfo)parameterInfo, context);
        }
        if (parameterInfo instanceof WebBasicParameterInfo) {
            return this.visit((WebBasicParameterInfo)parameterInfo, context);
        }
        if (parameterInfo instanceof WebExchangeParameterInfo) {
            return this.visit((WebExchangeParameterInfo)parameterInfo, context);
        }
        if (parameterInfo instanceof WebRequestBodyParameterInfo) {
            return this.visit((WebRequestBodyParameterInfo)parameterInfo, context);
        }
        if (parameterInfo instanceof WebSseEventFactoryParameterInfo) {
            return this.visit((WebSseEventFactoryParameterInfo)parameterInfo, context);
        }
        return new StringBuilder();
    }

    @Override
    public StringBuilder visit(WebBasicParameterInfo basicParameterInfo, WebRouterConfigurerOpenApiGenerationContext context) {
        if (context.getMode() == WebRouterConfigurerOpenApiGenerationContext.GenerationMode.ROUTE_PARAMETER) {
            StringBuilder result = new StringBuilder();
            String parameterName = basicParameterInfo.getQualifiedName().getParameterName();
            result.append(context.indentList(0)).append("name: ").append(parameterName).append("\n");
            context.getParameterDescription(parameterName).ifPresent(description -> result.append(context.indent(0)).append("description: ").append((CharSequence)description).append("\n"));
            result.append(context.indent(0)).append("in: ");
            if (basicParameterInfo instanceof WebCookieParameterInfo) {
                result.append("cookie").append("\n");
            } else if (basicParameterInfo instanceof WebHeaderParameterInfo) {
                result.append("header").append("\n");
            } else if (basicParameterInfo instanceof WebPathParameterInfo) {
                result.append("path").append("\n");
            } else if (basicParameterInfo instanceof WebQueryParameterInfo) {
                result.append("query").append("\n");
            } else {
                throw new IllegalStateException("Unknown basic parameter type: " + basicParameterInfo.getClass());
            }
            result.append(context.indent(0)).append("required: ").append(basicParameterInfo.isRequired()).append("\n");
            ((WebRouterConfigurerOpenApiGenerationContext)context.withIndentDepthAdd(1)).getSchema(basicParameterInfo.getType(), false).ifPresentOrElse(schema -> result.append(context.indent(0)).append("schema: ").append("\n").append((CharSequence)schema), () -> {
                result.append(context.indent(0)).append("schema: ").append("\n");
                result.append(context.indent(1)).append("type: object");
            });
            return result;
        }
        return new StringBuilder();
    }

    @Override
    public StringBuilder visit(WebCookieParameterInfo cookieParameterInfo, WebRouterConfigurerOpenApiGenerationContext context) {
        return this.visit((WebBasicParameterInfo)cookieParameterInfo, context);
    }

    @Override
    public StringBuilder visit(WebFormParameterInfo formParameterInfo, WebRouterConfigurerOpenApiGenerationContext context) {
        if (context.getMode() == WebRouterConfigurerOpenApiGenerationContext.GenerationMode.ROUTE_BODY) {
            StringBuilder result = new StringBuilder();
            result.append(context.indent(0)).append(formParameterInfo.getQualifiedName().getParameterName()).append(": \n");
            ((WebRouterConfigurerOpenApiGenerationContext)context.withIndentDepthAdd(1)).getSchema(formParameterInfo.getType(), false).ifPresentOrElse(schema -> result.append((CharSequence)schema), () -> result.append(context.indent(1)).append("type: object"));
            return result;
        }
        return new StringBuilder();
    }

    @Override
    public StringBuilder visit(WebHeaderParameterInfo headerParameterInfo, WebRouterConfigurerOpenApiGenerationContext context) {
        return this.visit((WebBasicParameterInfo)headerParameterInfo, context);
    }

    @Override
    public StringBuilder visit(WebPathParameterInfo pathParameterInfo, WebRouterConfigurerOpenApiGenerationContext context) {
        return this.visit((WebBasicParameterInfo)pathParameterInfo, context);
    }

    @Override
    public StringBuilder visit(WebQueryParameterInfo queryParameterInfo, WebRouterConfigurerOpenApiGenerationContext context) {
        return this.visit((WebBasicParameterInfo)queryParameterInfo, context);
    }

    @Override
    public StringBuilder visit(WebRequestBodyParameterInfo bodyParameterInfo, WebRouterConfigurerOpenApiGenerationContext context) {
        if (context.getMode() == WebRouterConfigurerOpenApiGenerationContext.GenerationMode.ROUTE_BODY) {
            StringBuilder result = new StringBuilder();
            WebRouteInfo routeInfo = context.getWebRoute();
            String parameterName = bodyParameterInfo.getQualifiedName().getParameterName();
            context.getParameterDescription(parameterName).ifPresent(description -> result.append(context.indent(0)).append("description: ").append((CharSequence)description).append("\n"));
            StringBuilder responseSchema = ((WebRouterConfigurerOpenApiGenerationContext)context.withIndentDepthAdd(3)).getSchema(bodyParameterInfo.getType(), false).map(schema -> new StringBuilder(context.indent(2)).append("schema: \n").append((CharSequence)schema)).orElseGet(() -> {
                StringBuilder fallbackSchema = new StringBuilder(context.indent(2)).append("schema: \n");
                fallbackSchema.append(context.indent(3)).append("type: object");
                return fallbackSchema;
            });
            result.append(context.indent(0)).append("content: \n");
            if (routeInfo.getConsumes().length > 0) {
                for (String produce : routeInfo.getConsumes()) {
                    result.append(context.indent(1)).append(produce).append(": \n");
                    result.append((CharSequence)responseSchema);
                }
            } else {
                result.append(context.indent(1)).append("'*/*'").append(": \n");
                result.append((CharSequence)responseSchema);
            }
            return result;
        }
        return new StringBuilder();
    }

    @Override
    public StringBuilder visit(WebExchangeParameterInfo exchangeParameterInfo, WebRouterConfigurerOpenApiGenerationContext context) {
        return new StringBuilder();
    }

    @Override
    public StringBuilder visit(WebSseEventFactoryParameterInfo sseEventFactoryParameterInfo, WebRouterConfigurerOpenApiGenerationContext context) {
        return new StringBuilder();
    }
}

