/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.web.compiler.internal;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.AuthorTree;
import com.sun.source.doctree.CommentTree;
import com.sun.source.doctree.DeprecatedTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocRootTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.DocTreeVisitor;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.EntityTree;
import com.sun.source.doctree.ErroneousTree;
import com.sun.source.doctree.HiddenTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.IndexTree;
import com.sun.source.doctree.InheritDocTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ProvidesTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.SeeTree;
import com.sun.source.doctree.SerialDataTree;
import com.sun.source.doctree.SerialFieldTree;
import com.sun.source.doctree.SerialTree;
import com.sun.source.doctree.SinceTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import com.sun.source.doctree.UnknownInlineTagTree;
import com.sun.source.doctree.UsesTree;
import com.sun.source.doctree.ValueTree;
import com.sun.source.doctree.VersionTree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTrees;
import io.inverno.core.compiler.spi.ModuleQualifiedName;
import io.inverno.core.compiler.spi.support.AbstractSourceGenerationContext;
import io.inverno.mod.http.base.BadRequestException;
import io.inverno.mod.http.base.ForbiddenException;
import io.inverno.mod.http.base.HttpException;
import io.inverno.mod.http.base.InternalServerErrorException;
import io.inverno.mod.http.base.MethodNotAllowedException;
import io.inverno.mod.http.base.NotAcceptableException;
import io.inverno.mod.http.base.NotFoundException;
import io.inverno.mod.http.base.ServiceUnavailableException;
import io.inverno.mod.http.base.UnauthorizedException;
import io.inverno.mod.http.base.UnsupportedMediaTypeException;
import io.inverno.mod.web.compiler.internal.TypeHierarchyExtractor;
import io.inverno.mod.web.compiler.spi.WebRouteInfo;
import io.netty.buffer.ByteBuf;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

class WebRouterConfigurerOpenApiGenerationContext
extends AbstractSourceGenerationContext<WebRouterConfigurerOpenApiGenerationContext, GenerationMode> {
    protected static final String DEFAULT_INDENT = "    ";
    private final DocTrees docUtils;
    private final JavadocToOpenApi javadocToOpenApi;
    private final OpenApiSchemaGenerator openApiSchemaGenerator;
    private final Map<String, DeclaredType> componentSchemaTypes;
    private final TypeHierarchyExtractor typeHierarchyExtractor;
    private TypeMirror webExceptionType;
    private TypeMirror badRequestExceptionType;
    private TypeMirror forbiddenExceptionType;
    private TypeMirror internalServerErrorExceptionType;
    private TypeMirror methodNotAllowedExceptionType;
    private TypeMirror notAcceptableExceptionType;
    private TypeMirror notFoundExceptionType;
    private TypeMirror serviceUnavailableExceptionType;
    private TypeMirror unauthorizedExceptionType;
    private TypeMirror unsupportedMediaTypeExceptionType;
    private TypeMirror classType;
    private TypeMirror objectType;
    private TypeMirror charSequenceType;
    private TypeMirror localDateType;
    private TypeMirror localDateTimeType;
    private TypeMirror zonedDateTimeType;
    private TypeMirror enumType;
    private TypeMirror collectionType;
    private TypeMirror mapType;
    private TypeMirror byteBufType;
    private DocGenerationMode docMode;
    private DocGenerationMode docInheritMode;
    private List<DocCommentTree> docCommentTrees;
    private String docParameterName;
    private String docExceptionName;
    private SchemaGenerationOptions schemaOptions;
    private WebRouteInfo webRoute;
    private String indentList;

    public WebRouterConfigurerOpenApiGenerationContext(Types typeUtils, Elements elementUtils, DocTrees docUtils, GenerationMode mode) {
        super(typeUtils, elementUtils, (Enum)mode, DEFAULT_INDENT);
        this.docUtils = docUtils;
        this.javadocToOpenApi = new JavadocToOpenApi();
        this.openApiSchemaGenerator = new OpenApiSchemaGenerator();
        this.componentSchemaTypes = new HashMap<String, DeclaredType>();
        this.typeHierarchyExtractor = new TypeHierarchyExtractor(this.typeUtils);
        this.webExceptionType = this.elementUtils.getTypeElement(HttpException.class.getCanonicalName()).asType();
        this.badRequestExceptionType = this.elementUtils.getTypeElement(BadRequestException.class.getCanonicalName()).asType();
        this.forbiddenExceptionType = this.elementUtils.getTypeElement(ForbiddenException.class.getCanonicalName()).asType();
        this.internalServerErrorExceptionType = this.elementUtils.getTypeElement(InternalServerErrorException.class.getCanonicalName()).asType();
        this.methodNotAllowedExceptionType = this.elementUtils.getTypeElement(MethodNotAllowedException.class.getCanonicalName()).asType();
        this.notAcceptableExceptionType = this.elementUtils.getTypeElement(NotAcceptableException.class.getCanonicalName()).asType();
        this.notFoundExceptionType = this.elementUtils.getTypeElement(NotFoundException.class.getCanonicalName()).asType();
        this.serviceUnavailableExceptionType = this.elementUtils.getTypeElement(ServiceUnavailableException.class.getCanonicalName()).asType();
        this.unauthorizedExceptionType = this.elementUtils.getTypeElement(UnauthorizedException.class.getCanonicalName()).asType();
        this.unsupportedMediaTypeExceptionType = this.elementUtils.getTypeElement(UnsupportedMediaTypeException.class.getCanonicalName()).asType();
        this.classType = this.typeUtils.erasure(this.elementUtils.getTypeElement(Class.class.getCanonicalName()).asType());
        this.objectType = this.elementUtils.getTypeElement(Object.class.getCanonicalName()).asType();
        this.charSequenceType = this.elementUtils.getTypeElement(CharSequence.class.getCanonicalName()).asType();
        this.localDateType = this.elementUtils.getTypeElement(LocalDate.class.getCanonicalName()).asType();
        this.localDateTimeType = this.elementUtils.getTypeElement(LocalDateTime.class.getCanonicalName()).asType();
        this.zonedDateTimeType = this.elementUtils.getTypeElement(ZonedDateTime.class.getCanonicalName()).asType();
        this.enumType = this.typeUtils.erasure(this.elementUtils.getTypeElement(Enum.class.getCanonicalName()).asType());
        this.collectionType = this.typeUtils.erasure(this.elementUtils.getTypeElement(Collection.class.getCanonicalName()).asType());
        this.mapType = this.typeUtils.erasure(this.elementUtils.getTypeElement(Map.class.getCanonicalName()).asType());
        this.byteBufType = this.elementUtils.getTypeElement(ByteBuf.class.getCanonicalName()).asType();
    }

    private WebRouterConfigurerOpenApiGenerationContext(WebRouterConfigurerOpenApiGenerationContext parentGeneration) {
        super((AbstractSourceGenerationContext)parentGeneration);
        this.docUtils = parentGeneration.docUtils;
        this.javadocToOpenApi = parentGeneration.javadocToOpenApi;
        this.openApiSchemaGenerator = parentGeneration.openApiSchemaGenerator;
        this.componentSchemaTypes = parentGeneration.componentSchemaTypes;
        this.typeHierarchyExtractor = parentGeneration.typeHierarchyExtractor;
        this.webRoute = parentGeneration.webRoute;
        this.docMode = parentGeneration.docMode;
        this.docInheritMode = parentGeneration.docInheritMode;
        this.docCommentTrees = parentGeneration.docCommentTrees;
        this.docParameterName = parentGeneration.docParameterName;
        this.docExceptionName = parentGeneration.docExceptionName;
        this.schemaOptions = parentGeneration.schemaOptions;
    }

    public void setIndent(String indent) {
        super.setIndent(indent);
        if (this.indent.length() < 2) {
            throw new IllegalStateException("Can't insert '-' with a less than 2 spaces indent");
        }
        char[] indentChars = this.indent.toCharArray();
        char[] indentListChars = new char[this.indent.length()];
        for (int i = 0; i < indentListChars.length; ++i) {
            indentListChars[i] = i != indentListChars.length - 2 ? indentChars[i] : 45;
        }
        this.indentList = new String(indentListChars);
    }

    public String indentList(int depth) {
        if (this.indentDepth + depth < 1) {
            throw new IllegalStateException("Can't insert '-' with a 0 depth");
        }
        Object repeatIndent = "";
        for (int i = 0; i < this.indentDepth + depth - 1; ++i) {
            repeatIndent = (String)repeatIndent + this.indent;
        }
        repeatIndent = (String)repeatIndent + this.indentList;
        return repeatIndent;
    }

    public DocTrees getDocUtils() {
        return this.docUtils;
    }

    public WebRouterConfigurerOpenApiGenerationContext withMode(GenerationMode mode) {
        WebRouterConfigurerOpenApiGenerationContext context = new WebRouterConfigurerOpenApiGenerationContext(this);
        context.mode = mode;
        return context;
    }

    public WebRouterConfigurerOpenApiGenerationContext withIndentDepth(int indentDepth) {
        WebRouterConfigurerOpenApiGenerationContext context = new WebRouterConfigurerOpenApiGenerationContext(this);
        context.indentDepth = indentDepth;
        return context;
    }

    public WebRouterConfigurerOpenApiGenerationContext withModule(ModuleQualifiedName moduleQualifiedName) {
        WebRouterConfigurerOpenApiGenerationContext context = new WebRouterConfigurerOpenApiGenerationContext(this);
        context.moduleQualifiedName = moduleQualifiedName;
        return context;
    }

    public WebRouterConfigurerOpenApiGenerationContext withWebRoute(WebRouteInfo webRoute) {
        WebRouterConfigurerOpenApiGenerationContext context = new WebRouterConfigurerOpenApiGenerationContext(this);
        context.webRoute = webRoute;
        return context;
    }

    public WebRouterConfigurerOpenApiGenerationContext withDocElement(Element element) {
        WebRouterConfigurerOpenApiGenerationContext context = new WebRouterConfigurerOpenApiGenerationContext(this);
        if (element == null) {
            context.docCommentTrees = List.of();
        }
        if (element.getKind() == ElementKind.METHOD) {
            ExecutableElement routeElement = (ExecutableElement)element;
            TypeElement controllerElement = (TypeElement)routeElement.getEnclosingElement();
            context.docCommentTrees = this.typeHierarchyExtractor.extractTypeHierarchy(controllerElement).stream().map(typeElement -> ElementFilter.methodsIn(typeElement.getEnclosedElements()).stream().filter(methodElement -> methodElement.equals(routeElement) || this.elementUtils.overrides(routeElement, (ExecutableElement)methodElement, controllerElement)).findFirst()).filter(Optional::isPresent).map(Optional::get).map(this.docUtils::getDocCommentTree).filter(Objects::nonNull).collect(Collectors.toList());
        } else {
            DocCommentTree docCommentTree = this.docUtils.getDocCommentTree(element);
            context.docCommentTrees = docCommentTree != null ? List.of(docCommentTree) : List.of();
        }
        return context;
    }

    private WebRouterConfigurerOpenApiGenerationContext withDocMode(DocGenerationMode docMode) {
        WebRouterConfigurerOpenApiGenerationContext context = new WebRouterConfigurerOpenApiGenerationContext(this);
        if (docMode == DocGenerationMode.DESCRIPTION) {
            context.docInheritMode = DocGenerationMode.DESCRIPTION;
        } else if (docMode == DocGenerationMode.PARAMETER) {
            context.docInheritMode = DocGenerationMode.PARAMETER;
        } else if (docMode == DocGenerationMode.RESPONSE) {
            context.docInheritMode = DocGenerationMode.RESPONSE;
        }
        context.docMode = docMode;
        return context;
    }

    private WebRouterConfigurerOpenApiGenerationContext withDocCommentTrees(List<DocCommentTree> docCommentTrees) {
        WebRouterConfigurerOpenApiGenerationContext context = new WebRouterConfigurerOpenApiGenerationContext(this);
        context.docCommentTrees = docCommentTrees;
        return context;
    }

    private WebRouterConfigurerOpenApiGenerationContext withDocParameterName(String parameterName) {
        WebRouterConfigurerOpenApiGenerationContext context = new WebRouterConfigurerOpenApiGenerationContext(this);
        context.docParameterName = parameterName;
        return context;
    }

    private WebRouterConfigurerOpenApiGenerationContext withDocExceptionName(String exceptionName) {
        WebRouterConfigurerOpenApiGenerationContext context = new WebRouterConfigurerOpenApiGenerationContext(this);
        context.docExceptionName = exceptionName;
        return context;
    }

    private WebRouterConfigurerOpenApiGenerationContext withSchemaOptions(SchemaGenerationOptions schemaOptions) {
        WebRouterConfigurerOpenApiGenerationContext context = new WebRouterConfigurerOpenApiGenerationContext(this);
        context.schemaOptions = schemaOptions;
        return context;
    }

    public WebRouteInfo getWebRoute() {
        return this.webRoute;
    }

    public List<DocCommentTree> getDocCommentTrees() {
        return this.docCommentTrees;
    }

    private TypeMirror getWebExceptionType() {
        return this.webExceptionType != null ? this.webExceptionType : ((WebRouterConfigurerOpenApiGenerationContext)this.parentGeneration).getWebExceptionType();
    }

    private TypeMirror getBadRequestExceptionType() {
        return this.badRequestExceptionType != null ? this.badRequestExceptionType : ((WebRouterConfigurerOpenApiGenerationContext)this.parentGeneration).getBadRequestExceptionType();
    }

    private TypeMirror getForbiddenExceptionType() {
        return this.forbiddenExceptionType != null ? this.forbiddenExceptionType : ((WebRouterConfigurerOpenApiGenerationContext)this.parentGeneration).getForbiddenExceptionType();
    }

    private TypeMirror getInternalServerErrorExceptionType() {
        return this.internalServerErrorExceptionType != null ? this.internalServerErrorExceptionType : ((WebRouterConfigurerOpenApiGenerationContext)this.parentGeneration).getInternalServerErrorExceptionType();
    }

    private TypeMirror getMethodNotAllowedExceptionType() {
        return this.methodNotAllowedExceptionType != null ? this.methodNotAllowedExceptionType : ((WebRouterConfigurerOpenApiGenerationContext)this.parentGeneration).getMethodNotAllowedExceptionType();
    }

    private TypeMirror getNotAcceptableExceptionType() {
        return this.notAcceptableExceptionType != null ? this.notAcceptableExceptionType : ((WebRouterConfigurerOpenApiGenerationContext)this.parentGeneration).getNotAcceptableExceptionType();
    }

    private TypeMirror getNotFoundExceptionType() {
        return this.notFoundExceptionType != null ? this.notFoundExceptionType : ((WebRouterConfigurerOpenApiGenerationContext)this.parentGeneration).getNotFoundExceptionType();
    }

    private TypeMirror getServiceUnavailableExceptionType() {
        return this.serviceUnavailableExceptionType != null ? this.serviceUnavailableExceptionType : ((WebRouterConfigurerOpenApiGenerationContext)this.parentGeneration).getServiceUnavailableExceptionType();
    }

    private TypeMirror getUnauthorizedExceptionType() {
        return this.unauthorizedExceptionType != null ? this.unauthorizedExceptionType : ((WebRouterConfigurerOpenApiGenerationContext)this.parentGeneration).getUnauthorizedExceptionType();
    }

    private TypeMirror getUnsupportedMediaTypeExceptionType() {
        return this.unsupportedMediaTypeExceptionType != null ? this.unsupportedMediaTypeExceptionType : ((WebRouterConfigurerOpenApiGenerationContext)this.parentGeneration).getUnsupportedMediaTypeExceptionType();
    }

    private TypeMirror getClassType() {
        return this.classType != null ? this.classType : ((WebRouterConfigurerOpenApiGenerationContext)this.parentGeneration).getClassType();
    }

    private TypeMirror getObjectType() {
        return this.objectType != null ? this.objectType : ((WebRouterConfigurerOpenApiGenerationContext)this.parentGeneration).getObjectType();
    }

    private TypeMirror getCharSequenceType() {
        return this.charSequenceType != null ? this.charSequenceType : ((WebRouterConfigurerOpenApiGenerationContext)this.parentGeneration).getCharSequenceType();
    }

    private TypeMirror getLocalDateType() {
        return this.localDateType != null ? this.charSequenceType : ((WebRouterConfigurerOpenApiGenerationContext)this.parentGeneration).getCharSequenceType();
    }

    private TypeMirror getLocalDateTimeType() {
        return this.localDateTimeType != null ? this.localDateTimeType : ((WebRouterConfigurerOpenApiGenerationContext)this.parentGeneration).getLocalDateTimeType();
    }

    private TypeMirror getZonedDateTimeType() {
        return this.zonedDateTimeType != null ? this.zonedDateTimeType : ((WebRouterConfigurerOpenApiGenerationContext)this.parentGeneration).getZonedDateTimeType();
    }

    private TypeMirror getEnumType() {
        return this.enumType != null ? this.enumType : ((WebRouterConfigurerOpenApiGenerationContext)this.parentGeneration).getEnumType();
    }

    private TypeMirror getCollectionType() {
        return this.collectionType != null ? this.collectionType : ((WebRouterConfigurerOpenApiGenerationContext)this.parentGeneration).getCollectionType();
    }

    private TypeMirror getMapType() {
        return this.mapType != null ? this.mapType : ((WebRouterConfigurerOpenApiGenerationContext)this.parentGeneration).getMapType();
    }

    private TypeMirror getByteBufType() {
        return this.byteBufType != null ? this.byteBufType : ((WebRouterConfigurerOpenApiGenerationContext)this.parentGeneration).getByteBufType();
    }

    public Optional<StringBuilder> getSummary() {
        if (this.docCommentTrees == null || this.docCommentTrees.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.docCommentTrees.get(0).accept(this.javadocToOpenApi, this.withDocMode(DocGenerationMode.SUMMARY)));
    }

    public Optional<StringBuilder> getDescription() {
        if (this.docCommentTrees == null || this.docCommentTrees.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.docCommentTrees.get(0).accept(this.javadocToOpenApi, this.withDocMode(DocGenerationMode.DESCRIPTION)));
    }

    public Optional<StringBuilder> getVersion() {
        if (this.docCommentTrees == null || this.docCommentTrees.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.docCommentTrees.get(0).accept(this.javadocToOpenApi, this.withDocMode(DocGenerationMode.VERSION)));
    }

    public Optional<StringBuilder> getContact() {
        if (this.docCommentTrees == null || this.docCommentTrees.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.docCommentTrees.get(0).accept(this.javadocToOpenApi, this.withDocMode(DocGenerationMode.CONTACT)));
    }

    public Optional<StringBuilder> getParameterDescription(String parameterName) {
        if (parameterName == null || this.docCommentTrees == null || this.docCommentTrees.isEmpty()) {
            return Optional.empty();
        }
        for (DocCommentTree dct : this.docCommentTrees) {
            Optional<ParamTree> paramTreeOptional = dct.getBlockTags().stream().filter(docTree -> docTree.getKind() == DocTree.Kind.PARAM && ((ParamTree)docTree).getName().toString().equals(parameterName)).findFirst().map(docTree -> (ParamTree)docTree);
            if (!paramTreeOptional.isPresent()) continue;
            return paramTreeOptional.map(paramTree -> paramTree.accept(this.javadocToOpenApi, this.withDocMode(DocGenerationMode.PARAMETER)));
        }
        return Optional.empty();
    }

    public List<ResponseSpec> getResponses(ExecutableElement routeElement, TypeMirror responseBodyType) {
        if (routeElement == null || responseBodyType == null) {
            return List.of();
        }
        ArrayList<ResponseSpec> returnResponses = new ArrayList<ResponseSpec>();
        HashMap<String, ResponseSpec> thrownResponsesByType = new HashMap<String, ResponseSpec>();
        if (this.docCommentTrees != null && !this.docCommentTrees.isEmpty()) {
            for (DocCommentTree docCommentTree : this.docCommentTrees) {
                List returnTags = docCommentTree.getBlockTags().stream().filter(docTree -> docTree.getKind() == DocTree.Kind.RETURN).map(docTree -> (ReturnTree)docTree).collect(Collectors.toList());
                if (returnTags.isEmpty()) continue;
                for (ReturnTree returnTag : returnTags) {
                    String status = returnTag.getDescription().stream().filter(docTree -> docTree.getKind() == DocTree.Kind.UNKNOWN_INLINE_TAG && ((UnknownInlineTagTree)docTree).getTagName().equalsIgnoreCase("inverno.web.status")).findFirst().map(docTree -> docTree.accept(this.javadocToOpenApi, this.withDocMode(DocGenerationMode.RESPONSE))).map(StringBuilder::toString).orElse("200");
                    StringBuilder description = returnTag.accept(this.javadocToOpenApi, this.withDocMode(DocGenerationMode.RESPONSE));
                    returnResponses.add(new ResponseSpec(status, description, responseBodyType));
                }
            }
            for (DocCommentTree docCommentTree : this.docCommentTrees) {
                List throwsTags = docCommentTree.getBlockTags().stream().filter(docTree -> docTree.getKind() == DocTree.Kind.THROWS).map(docTree -> (ThrowsTree)docTree).collect(Collectors.toList());
                if (throwsTags.isEmpty()) continue;
                for (ThrowsTree throwsTag : throwsTags) {
                    DocTreePath thrownPath = DocTreePath.getPath(this.docUtils.getPath(routeElement), docCommentTree, throwsTag.getExceptionName());
                    TypeElement thrownElement = (TypeElement)this.docUtils.getElement(thrownPath);
                    if (thrownElement == null) continue;
                    TypeMirror thrownType = thrownElement.asType();
                    String status = throwsTag.getDescription().stream().filter(docTree -> docTree.getKind() == DocTree.Kind.UNKNOWN_INLINE_TAG && ((UnknownInlineTagTree)docTree).getTagName().equalsIgnoreCase("inverno.web.status")).findFirst().map(docTree -> docTree.accept(this.javadocToOpenApi, this.withDocMode(DocGenerationMode.RESPONSE))).map(StringBuilder::toString).orElse(this.getResponseStatus(thrownType));
                    StringBuilder description = throwsTag.accept(this.javadocToOpenApi, this.withDocMode(DocGenerationMode.RESPONSE));
                    thrownResponsesByType.put(thrownType.toString(), new ResponseSpec(status, description, thrownType));
                }
            }
        }
        if (returnResponses.isEmpty()) {
            returnResponses.add(new ResponseSpec("200", new StringBuilder("''"), responseBodyType));
        }
        for (TypeMirror typeMirror : routeElement.getThrownTypes()) {
            thrownResponsesByType.putIfAbsent(typeMirror.toString(), new ResponseSpec(this.getResponseStatus(typeMirror), new StringBuilder("''"), typeMirror));
        }
        return Stream.concat(returnResponses.stream(), thrownResponsesByType.values().stream()).collect(Collectors.toList());
    }

    private String getResponseStatus(TypeMirror type) {
        String status = "500";
        if (this.typeUtils.isAssignable(type, this.getWebExceptionType())) {
            if (this.typeUtils.isAssignable(type, this.getBadRequestExceptionType())) {
                status = "400";
            } else if (this.typeUtils.isAssignable(type, this.getForbiddenExceptionType())) {
                status = "403";
            } else if (this.typeUtils.isAssignable(type, this.getInternalServerErrorExceptionType())) {
                status = "500";
            } else if (this.typeUtils.isAssignable(type, this.getMethodNotAllowedExceptionType())) {
                status = "405";
            } else if (this.typeUtils.isAssignable(type, this.getNotAcceptableExceptionType())) {
                status = "406";
            } else if (this.typeUtils.isAssignable(type, this.getNotFoundExceptionType())) {
                status = "404";
            } else if (this.typeUtils.isAssignable(type, this.getServiceUnavailableExceptionType())) {
                status = "503";
            } else if (this.typeUtils.isAssignable(type, this.getUnauthorizedExceptionType())) {
                status = "401";
            } else if (this.typeUtils.isAssignable(type, this.getUnsupportedMediaTypeExceptionType())) {
                status = "415";
            }
        }
        return status;
    }

    public Optional<StringBuilder> getSchema(TypeMirror type, boolean inList) {
        return Optional.ofNullable(type.accept(this.openApiSchemaGenerator, this.withSchemaOptions(new SchemaGenerationOptions(inList, true)))).filter(sb -> sb.length() > 0);
    }

    public Optional<StringBuilder> getComponentsSchemas() {
        StringBuilder result = new StringBuilder();
        HashSet<String> generatedSchemas = new HashSet<String>();
        while (generatedSchemas.size() < this.componentSchemaTypes.size()) {
            for (Map.Entry<String, DeclaredType> e : new HashMap<String, DeclaredType>(this.componentSchemaTypes).entrySet()) {
                StringBuilder schema;
                if (!generatedSchemas.add(e.getValue().toString()) || (schema = e.getValue().accept(this.openApiSchemaGenerator, ((WebRouterConfigurerOpenApiGenerationContext)this.withIndentDepthAdd(1)).withSchemaOptions(new SchemaGenerationOptions(false, false)))).length() <= 0) continue;
                result.append(this.indent(0)).append(e.getKey()).append(": \n");
                result.append((CharSequence)schema).append("\n");
            }
        }
        return Optional.of(result).filter(sb -> sb.length() > 0);
    }

    private static class SchemaGenerationOptions {
        boolean inList;
        boolean useReference;

        SchemaGenerationOptions(boolean inList, boolean useReference) {
            this.inList = inList;
            this.useReference = useReference;
        }
    }

    private static enum DocGenerationMode {
        DESCRIPTION,
        SUMMARY,
        VERSION,
        CONTACT,
        PARAMETER,
        RESPONSE,
        RICH_TEXT,
        PLAIN_TEXT;

    }

    private static class JavadocToOpenApi
    implements DocTreeVisitor<StringBuilder, WebRouterConfigurerOpenApiGenerationContext> {
        private JavadocToOpenApi() {
        }

        @Override
        public StringBuilder visitAttribute(AttributeTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            if (context.docMode == DocGenerationMode.RICH_TEXT) {
                return new StringBuilder(node.getName().toString()).append("=\"").append((CharSequence)node.getValue().stream().map(docTree -> docTree.accept(this, context.withDocMode(DocGenerationMode.PLAIN_TEXT))).collect(context.joining())).append("\"");
            }
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitAuthor(AuthorTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            if (context.docMode == DocGenerationMode.CONTACT) {
                StringBuilder result = new StringBuilder();
                StringBuilder nameBuilder = new StringBuilder(context.indent(1)).append("name: '");
                Optional<StringBuilder> linkBuilderOptional = Optional.empty();
                for (DocTree docTree : node.getName()) {
                    if (!linkBuilderOptional.isPresent() && docTree.getKind() == DocTree.Kind.START_ELEMENT && ((StartElementTree)docTree).getName().toString().equalsIgnoreCase("a")) {
                        linkBuilderOptional = ((StartElementTree)docTree).getAttributes().stream().filter(attribute -> attribute.getKind() == DocTree.Kind.ATTRIBUTE && ((AttributeTree)attribute).getName().toString().equalsIgnoreCase("href")).findFirst().map(attribute -> {
                            StringBuilder linkBuilder = new StringBuilder();
                            String value = ((StringBuilder)((AttributeTree)attribute).getValue().stream().map(docTree -> docTree.accept(this, context.withDocMode(DocGenerationMode.PLAIN_TEXT))).collect(context.joining())).toString();
                            if (value.startsWith("mailto:")) {
                                linkBuilder.append(context.indent(1)).append("email: '").append(value.substring(7)).append("'");
                            } else {
                                linkBuilder.append(context.indent(1)).append("url: '").append(value).append("'");
                            }
                            return linkBuilder;
                        });
                        continue;
                    }
                    nameBuilder.append((CharSequence)docTree.accept(this, context.withDocMode(DocGenerationMode.PLAIN_TEXT)));
                }
                result.append((CharSequence)nameBuilder).append("'");
                linkBuilderOptional.ifPresent(link -> result.append("\n").append((CharSequence)link));
                return result;
            }
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitComment(CommentTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitDeprecated(DeprecatedTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitDocComment(DocCommentTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            if (context.docMode == DocGenerationMode.SUMMARY) {
                return new StringBuilder().append("'").append((CharSequence)node.getFirstSentence().stream().map(docTree -> docTree.accept(this, context.withDocMode(DocGenerationMode.PLAIN_TEXT))).collect(context.joining())).append("'");
            }
            if (context.docMode == DocGenerationMode.DESCRIPTION) {
                return new StringBuilder().append("'").append((CharSequence)node.getFullBody().stream().map(docTree -> docTree.accept(this, context.withDocMode(DocGenerationMode.RICH_TEXT))).collect(context.joining())).append("'");
            }
            if (context.docMode == DocGenerationMode.CONTACT) {
                return node.getBlockTags().stream().filter(docTree -> docTree.getKind() == DocTree.Kind.AUTHOR).findFirst().map(authorTree -> authorTree.accept(this, context)).orElse(null);
            }
            if (context.docMode == DocGenerationMode.VERSION) {
                return node.getBlockTags().stream().filter(docTree -> docTree.getKind() == DocTree.Kind.VERSION).findFirst().map(versionTree -> versionTree.accept(this, context)).orElse(null);
            }
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitDocRoot(DocRootTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitEndElement(EndElementTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            if (context.docMode == DocGenerationMode.RICH_TEXT) {
                return new StringBuilder("</").append(node.getName().toString()).append(">");
            }
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitEntity(EntityTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            return new StringBuilder(node.getName().toString());
        }

        @Override
        public StringBuilder visitErroneous(ErroneousTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitHidden(HiddenTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitIdentifier(IdentifierTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            return new StringBuilder(node.getName().toString());
        }

        @Override
        public StringBuilder visitIndex(IndexTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitInheritDoc(InheritDocTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            block7: {
                block8: {
                    if (context.docCommentTrees.size() <= 1) break block7;
                    if (context.docInheritMode == DocGenerationMode.DESCRIPTION) {
                        StringBuilder inheritDescription = this.visitDocComment((DocCommentTree)context.docCommentTrees.get(1), context.withDocMode(DocGenerationMode.DESCRIPTION).withDocCommentTrees(context.docCommentTrees.subList(1, context.docCommentTrees.size())));
                        return inheritDescription.deleteCharAt(0).deleteCharAt(inheritDescription.length() - 1);
                    }
                    if (context.docInheritMode != DocGenerationMode.PARAMETER) break block8;
                    if (context.docParameterName == null) break block7;
                    for (int i = 1; i < context.docCommentTrees.size(); ++i) {
                        DocCommentTree dct = (DocCommentTree)context.docCommentTrees.get(i);
                        Optional<ParamTree> paramTreeOptional = dct.getBlockTags().stream().filter(docTree -> docTree.getKind() == DocTree.Kind.PARAM && ((ParamTree)docTree).getName().toString().equals(context.docParameterName)).findFirst().map(docTree -> (ParamTree)docTree);
                        if (!paramTreeOptional.isPresent()) continue;
                        StringBuilder inheritParameterDescription = this.visitParam(paramTreeOptional.get(), context.withDocMode(DocGenerationMode.PARAMETER).withDocCommentTrees(context.docCommentTrees.subList(i, context.docCommentTrees.size())));
                        return inheritParameterDescription.deleteCharAt(0).deleteCharAt(inheritParameterDescription.length() - 1);
                    }
                    break block7;
                }
                if (context.docInheritMode == DocGenerationMode.RESPONSE) {
                    if (context.docExceptionName != null) {
                        for (int i = 1; i < context.docCommentTrees.size(); ++i) {
                            DocCommentTree dct = (DocCommentTree)context.docCommentTrees.get(i);
                            Optional<ThrowsTree> throwsTreeOptional = dct.getBlockTags().stream().filter(docTree -> docTree.getKind() == DocTree.Kind.THROWS && ((ThrowsTree)docTree).getExceptionName().toString().equals(context.docExceptionName)).findFirst().map(docTree -> (ThrowsTree)docTree);
                            if (!throwsTreeOptional.isPresent()) continue;
                            StringBuilder inheritReponseDescription = this.visitThrows(throwsTreeOptional.get(), context.withDocMode(DocGenerationMode.RESPONSE).withDocCommentTrees(context.docCommentTrees.subList(i, context.docCommentTrees.size())));
                            return inheritReponseDescription.deleteCharAt(0).deleteCharAt(inheritReponseDescription.length() - 1);
                        }
                    } else {
                        for (int i = 1; i < context.docCommentTrees.size(); ++i) {
                            DocCommentTree dct = (DocCommentTree)context.docCommentTrees.get(i);
                            Optional<ReturnTree> returnTreeOptional = dct.getBlockTags().stream().filter(docTree -> docTree.getKind() == DocTree.Kind.RETURN).findFirst().map(docTree -> (ReturnTree)docTree);
                            if (!returnTreeOptional.isPresent()) continue;
                            StringBuilder inheritReponseDescription = this.visitReturn(returnTreeOptional.get(), context.withDocMode(DocGenerationMode.RESPONSE).withDocCommentTrees(context.docCommentTrees.subList(i, context.docCommentTrees.size())));
                            return inheritReponseDescription.deleteCharAt(0).deleteCharAt(inheritReponseDescription.length() - 1);
                        }
                    }
                }
            }
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitLink(LinkTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            StringBuilder result = new StringBuilder();
            if (node.getLabel().isEmpty()) {
                result.append(node.getReference().toString());
            } else {
                result.append((CharSequence)node.getLabel().stream().map(docTree -> docTree.accept(this, context)).collect(context.joining()));
            }
            return result;
        }

        @Override
        public StringBuilder visitLiteral(LiteralTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            return node.getBody().accept(this, context);
        }

        @Override
        public StringBuilder visitParam(ParamTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            if (context.docMode == DocGenerationMode.PARAMETER) {
                return new StringBuilder("'").append((CharSequence)node.getDescription().stream().map(docTree -> docTree.accept(this, context.withDocParameterName(node.getName().toString()).withDocMode(DocGenerationMode.RICH_TEXT))).collect(context.joining())).append("'");
            }
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitProvides(ProvidesTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitReference(ReferenceTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitReturn(ReturnTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            if (context.docMode == DocGenerationMode.RESPONSE) {
                StringBuilder result = new StringBuilder();
                result.append("'");
                if (!node.getDescription().isEmpty()) {
                    result.append((CharSequence)node.getDescription().stream().map(docTree -> docTree.accept(this, context.withDocMode(DocGenerationMode.RICH_TEXT))).collect(context.joining()));
                }
                result.append("'");
                return result;
            }
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitSee(SeeTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitSerial(SerialTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitSerialData(SerialDataTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitSerialField(SerialFieldTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitSince(SinceTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitStartElement(StartElementTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            if (context.docMode == DocGenerationMode.RICH_TEXT) {
                StringBuilder result = new StringBuilder();
                result.append("<").append(node.getName().toString());
                if (!node.getAttributes().isEmpty()) {
                    result.append(" ");
                    result.append((CharSequence)node.getAttributes().stream().map(docTree -> docTree.accept(this, context)).collect(context.joining(" ")));
                }
                if (node.isSelfClosing()) {
                    result.append("/>");
                } else {
                    result.append(">");
                }
                return result;
            }
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitText(TextTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            return new StringBuilder().append(node.getBody().replace("'", "''"));
        }

        @Override
        public StringBuilder visitThrows(ThrowsTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            if (context.docMode == DocGenerationMode.RESPONSE) {
                StringBuilder result = new StringBuilder();
                result.append("'");
                if (!node.getDescription().isEmpty()) {
                    result.append((CharSequence)node.getDescription().stream().map(docTree -> docTree.accept(this, context.withDocExceptionName(node.getExceptionName().toString()).withDocMode(DocGenerationMode.RICH_TEXT))).collect(context.joining()));
                }
                result.append("'");
                return result;
            }
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitUnknownBlockTag(UnknownBlockTagTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitUnknownInlineTag(UnknownInlineTagTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            if (context.docMode == DocGenerationMode.RESPONSE && node.getTagName().equalsIgnoreCase("inverno.web.status")) {
                return new StringBuilder().append((CharSequence)node.getContent().stream().map(docTree -> docTree.accept(this, context.withDocMode(DocGenerationMode.PLAIN_TEXT))).collect(context.joining()));
            }
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitUses(UsesTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitValue(ValueTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitVersion(VersionTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            if (context.docMode == DocGenerationMode.VERSION) {
                return new StringBuilder().append("'").append(node.getBody().stream().map(docTree -> docTree.accept(this, context.withDocMode(DocGenerationMode.PLAIN_TEXT))).collect(Collectors.joining())).append("'");
            }
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitOther(DocTree node, WebRouterConfigurerOpenApiGenerationContext context) {
            return new StringBuilder();
        }
    }

    private static class OpenApiSchemaGenerator
    implements TypeVisitor<StringBuilder, WebRouterConfigurerOpenApiGenerationContext> {
        private OpenApiSchemaGenerator() {
        }

        @Override
        public StringBuilder visit(TypeMirror type, WebRouterConfigurerOpenApiGenerationContext context) {
            Objects.requireNonNull(type, "type");
            if (type instanceof PrimitiveType) {
                return this.visitPrimitive((PrimitiveType)type, context);
            }
            if (type instanceof ArrayType) {
                return this.visitArray((ArrayType)type, context);
            }
            if (type instanceof DeclaredType) {
                return this.visitDeclared((DeclaredType)type, context);
            }
            if (type instanceof WildcardType) {
                return this.visitWildcard((WildcardType)type, context);
            }
            if (type instanceof IntersectionType) {
                return this.visitIntersection((IntersectionType)type, context);
            }
            if (type instanceof NoType) {
                return this.visitNoType((NoType)type, context);
            }
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitPrimitive(PrimitiveType type, WebRouterConfigurerOpenApiGenerationContext context) {
            Objects.requireNonNull(type, "type");
            StringBuilder result = new StringBuilder();
            if (((WebRouterConfigurerOpenApiGenerationContext)context).schemaOptions.inList) {
                result.append(context.indentList(0));
            } else {
                result.append(context.indent(0));
            }
            result.append("type: ");
            if (type.getKind() == TypeKind.CHAR) {
                result.append("string");
            } else if (type.getKind() == TypeKind.BOOLEAN) {
                result.append("boolean");
            } else if (type.getKind() == TypeKind.BYTE || type.getKind() == TypeKind.SHORT || type.getKind() == TypeKind.INT) {
                result.append("integer").append("\n");
                result.append(context.indent(0)).append("format: ").append("int32");
            } else if (type.getKind() == TypeKind.LONG) {
                result.append("integer").append("\n");
                result.append(context.indent(0)).append("format: ").append("int64");
            } else if (type.getKind() == TypeKind.FLOAT) {
                result.append("number").append("\n");
                result.append(context.indent(0)).append("format: ").append("float");
            } else if (type.getKind() == TypeKind.DOUBLE) {
                result.append("number").append("\n");
                result.append(context.indent(0)).append("format: ").append("double");
            }
            return result;
        }

        @Override
        public StringBuilder visitNull(NullType type, WebRouterConfigurerOpenApiGenerationContext context) {
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitArray(ArrayType type, WebRouterConfigurerOpenApiGenerationContext context) {
            Objects.requireNonNull(type, "type");
            StringBuilder result = new StringBuilder();
            if (((WebRouterConfigurerOpenApiGenerationContext)context).schemaOptions.inList) {
                result.append(context.indentList(0));
            } else {
                result.append(context.indent(0));
            }
            result.append("type: ");
            result.append("array").append("\n");
            result.append(context.indent(0)).append("items: ").append("\n");
            StringBuilder componentSchema = this.visit(type.getComponentType(), ((WebRouterConfigurerOpenApiGenerationContext)context.withIndentDepthAdd(1)).withSchemaOptions(new SchemaGenerationOptions(false, true)));
            if (componentSchema.length() > 0) {
                result.append((CharSequence)componentSchema);
            } else {
                result.append(context.indent(1)).append("type: object");
            }
            return result;
        }

        @Override
        public StringBuilder visitDeclared(DeclaredType type, WebRouterConfigurerOpenApiGenerationContext context) {
            Objects.requireNonNull(type, "type");
            try {
                return this.visit((TypeMirror)context.typeUtils.unboxedType(type), context);
            }
            catch (Exception exception) {
                StringBuilder result = new StringBuilder();
                if (((WebRouterConfigurerOpenApiGenerationContext)context).schemaOptions.inList) {
                    result.append(context.indentList(0));
                } else {
                    result.append(context.indent(0));
                }
                result.append("type: ");
                if (context.typeUtils.isAssignable(context.typeUtils.erasure(type), context.getClassType())) {
                    result.append("string");
                } else if (context.typeUtils.isAssignable(type, context.getCharSequenceType())) {
                    result.append("string");
                } else if (context.typeUtils.isSameType(type, context.getByteBufType())) {
                    result.append("string");
                } else if (context.typeUtils.isSameType(type, context.getLocalDateType())) {
                    result.append("string").append("\n");
                    result.append(context.indent(0)).append("format: ").append("date");
                } else if (context.typeUtils.isSameType(type, context.getLocalDateTimeType())) {
                    result.append("string").append("\n");
                    result.append(context.indent(0)).append("format: ").append("date-time");
                } else if (context.typeUtils.isSameType(type, context.getZonedDateTimeType())) {
                    result.append("string").append("\n");
                    result.append(context.indent(0)).append("format: ").append("date-time");
                } else if (context.typeUtils.isAssignable(context.typeUtils.erasure(type), context.getEnumType())) {
                    if (((WebRouterConfigurerOpenApiGenerationContext)context).schemaOptions.useReference) {
                        StringBuilder reference = new StringBuilder();
                        if (((WebRouterConfigurerOpenApiGenerationContext)context).schemaOptions.inList) {
                            reference.append(context.indentList(0));
                        } else {
                            reference.append(context.indent(0));
                        }
                        reference.append("$ref: '#/components/schemas/").append(type.toString()).append("'");
                        context.componentSchemaTypes.put(type.toString(), type);
                        return reference;
                    }
                    result.append("string").append("\n");
                    result.append(context.indent(0)).append("enum: ").append("\n");
                    result.append((CharSequence)context.typeUtils.asElement(type).getEnclosedElements().stream().filter(element -> element.getKind() == ElementKind.ENUM_CONSTANT).map(enumConstant -> new StringBuilder(context.indentList(1)).append(enumConstant.toString())).collect(context.joining("\n")));
                } else if (context.typeUtils.isAssignable(context.typeUtils.erasure(type), context.getCollectionType())) {
                    result.append("array").append("\n");
                    result.append(context.indent(0)).append("items: ").append("\n");
                    StringBuilder componentSchema = this.visit(type.getTypeArguments().get(0), ((WebRouterConfigurerOpenApiGenerationContext)context.withIndentDepthAdd(1)).withSchemaOptions(new SchemaGenerationOptions(false, true)));
                    if (componentSchema.length() > 0) {
                        result.append((CharSequence)componentSchema);
                    } else {
                        result.append(context.indent(1)).append("type: object");
                    }
                } else if (context.typeUtils.isAssignable(context.typeUtils.erasure(type), context.getMapType())) {
                    result.append("object").append("\n");
                    result.append(context.indent(0)).append("additionalProperties: ").append("\n");
                    StringBuilder componentSchema = this.visit(type.getTypeArguments().get(1), ((WebRouterConfigurerOpenApiGenerationContext)context.withIndentDepthAdd(1)).withSchemaOptions(new SchemaGenerationOptions(false, true)));
                    if (componentSchema.length() > 0) {
                        result.append((CharSequence)componentSchema);
                    } else {
                        result.append(context.indent(1)).append("type: object");
                    }
                } else {
                    if (((WebRouterConfigurerOpenApiGenerationContext)context).schemaOptions.useReference) {
                        StringBuilder reference = new StringBuilder();
                        if (((WebRouterConfigurerOpenApiGenerationContext)context).schemaOptions.inList) {
                            reference.append(context.indentList(0));
                        } else {
                            reference.append(context.indent(0));
                        }
                        reference.append("$ref: '#/components/schemas/").append(type.toString()).append("'");
                        context.componentSchemaTypes.put(type.toString(), type);
                        return reference;
                    }
                    result.append("object");
                    List typeMemberElements = context.elementUtils.getAllMembers((TypeElement)context.typeUtils.asElement(type)).stream().filter(element -> !context.typeUtils.isSameType(element.getEnclosingElement().asType(), context.getObjectType())).collect(Collectors.toList());
                    StringBuilder publicFieldsProperties = (StringBuilder)ElementFilter.fieldsIn(typeMemberElements).stream().filter(element -> element.getModifiers().contains((Object)Modifier.PUBLIC) && !element.getModifiers().contains((Object)Modifier.STATIC)).map(element -> {
                        StringBuilder property = new StringBuilder();
                        TypeMirror propertyType = ((ExecutableType)context.typeUtils.asMemberOf(type, (Element)element)).getReturnType();
                        property.append(context.indent(1)).append(element.getSimpleName().toString()).append(": ").append("\n");
                        StringBuilder propertySchema = this.visit(propertyType, ((WebRouterConfigurerOpenApiGenerationContext)context.withIndentDepthAdd(2)).withSchemaOptions(new SchemaGenerationOptions(false, true)));
                        if (propertySchema.length() > 0) {
                            property.append((CharSequence)propertySchema);
                        } else {
                            property.append(context.indent(1)).append("type: object");
                        }
                        return property;
                    }).collect(context.joining("\n"));
                    Map<String, List<ExecutableElement>> accessorsByPropertyName = ElementFilter.methodsIn(typeMemberElements).stream().filter(element -> element.getParameters().size() <= 1).filter(element -> element.getModifiers().contains((Object)Modifier.PUBLIC) && !element.getModifiers().contains((Object)Modifier.ABSTRACT) && !element.getModifiers().contains((Object)Modifier.STATIC)).filter(element -> {
                        String elementName = element.getSimpleName().toString();
                        if (elementName.startsWith("get")) {
                            return element.getParameters().isEmpty() && element.getReturnType().getKind() != TypeKind.VOID;
                        }
                        if (elementName.startsWith("set")) {
                            return element.getParameters().size() == 1 && element.getReturnType().getKind() == TypeKind.VOID;
                        }
                        return false;
                    }).collect(Collectors.groupingBy(element -> element.getSimpleName().toString().substring(3)));
                    StringBuilder accessorsProperties = (StringBuilder)accessorsByPropertyName.entrySet().stream().map(e -> {
                        Object propertyName = (String)e.getKey();
                        propertyName = Character.toLowerCase(((String)propertyName).charAt(0)) + ((String)propertyName).substring(1);
                        boolean hasGetter = false;
                        boolean hasSetter = false;
                        HashMap<String, TypeMirror> propertyTypeByName = new HashMap<String, TypeMirror>();
                        for (ExecutableElement element : (List)e.getValue()) {
                            TypeMirror propertyType2;
                            String accessorName = element.getSimpleName().toString();
                            if (accessorName.startsWith("get")) {
                                hasGetter = true;
                                propertyType2 = ((ExecutableType)context.typeUtils.asMemberOf(type, element)).getReturnType();
                            } else if (accessorName.startsWith("set")) {
                                hasSetter = true;
                                propertyType2 = ((ExecutableType)context.typeUtils.asMemberOf(type, element)).getParameterTypes().get(0);
                            } else {
                                throw new IllegalStateException("Element should be an accessor");
                            }
                            propertyTypeByName.put(propertyType2.toString(), propertyType2);
                        }
                        int propertyTypesCount = propertyTypeByName.size();
                        if (propertyTypesCount > 0) {
                            StringBuilder propertySchema;
                            StringBuilder property = new StringBuilder();
                            property.append(context.indent(1)).append((String)propertyName).append(": ").append("\n");
                            if (hasGetter && !hasSetter) {
                                property.append(context.indent(2)).append("readOnly: true").append("\n");
                            }
                            if (!hasGetter && hasSetter) {
                                property.append(context.indent(2)).append("writeOnly: true").append("\n");
                            }
                            if (propertyTypesCount > 1) {
                                propertySchema = (StringBuilder)propertyTypeByName.values().stream().map(propertyType -> this.visit((TypeMirror)propertyType, ((WebRouterConfigurerOpenApiGenerationContext)context.withIndentDepthAdd(3)).withSchemaOptions(new SchemaGenerationOptions(true, true)))).filter(sb -> sb.length() > 0).collect(context.joining("\n"));
                                if (propertySchema.length() > 0) {
                                    property.append(context.indent(2)).append("oneOf: ").append("\n");
                                    property.append((CharSequence)propertySchema);
                                } else {
                                    property.append(context.indent(1)).append("type: object");
                                }
                            } else {
                                propertySchema = this.visit((TypeMirror)propertyTypeByName.values().iterator().next(), ((WebRouterConfigurerOpenApiGenerationContext)context.withIndentDepthAdd(2)).withSchemaOptions(new SchemaGenerationOptions(false, true)));
                                if (propertySchema.length() > 0) {
                                    property.append((CharSequence)propertySchema);
                                } else {
                                    property.append(context.indent(1)).append("type: object");
                                }
                            }
                            return property;
                        }
                        return null;
                    }).filter(Objects::nonNull).collect(context.joining("\n"));
                    StringBuilder properties = (StringBuilder)Stream.of(publicFieldsProperties, accessorsProperties).filter(sb -> sb.length() > 0).collect(context.joining("\n"));
                    if (properties.length() > 0) {
                        result.append("\n").append(context.indent(0)).append("properties: ").append("\n");
                        result.append((CharSequence)properties);
                    }
                }
                return result;
            }
        }

        @Override
        public StringBuilder visitError(ErrorType type, WebRouterConfigurerOpenApiGenerationContext context) {
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitTypeVariable(TypeVariable type, WebRouterConfigurerOpenApiGenerationContext context) {
            Objects.requireNonNull(type, "type");
            if (type.getLowerBound() != null && type.getLowerBound().getKind() != TypeKind.NULL) {
                return this.visit(type.getLowerBound(), context);
            }
            StringBuilder result = new StringBuilder();
            if (((WebRouterConfigurerOpenApiGenerationContext)context).schemaOptions.inList) {
                result.append(context.indentList(0));
            } else {
                result.append(context.indent(0));
            }
            result.append("type: ").append("object");
            return result;
        }

        @Override
        public StringBuilder visitWildcard(WildcardType type, WebRouterConfigurerOpenApiGenerationContext context) {
            Objects.requireNonNull(type, "type");
            if (type.getExtendsBound() != null) {
                return this.visit(type.getExtendsBound(), context);
            }
            StringBuilder result = new StringBuilder();
            if (((WebRouterConfigurerOpenApiGenerationContext)context).schemaOptions.inList) {
                result.append(context.indentList(0));
            } else {
                result.append(context.indent(0));
            }
            result.append("type: ").append("object");
            return result;
        }

        @Override
        public StringBuilder visitExecutable(ExecutableType t, WebRouterConfigurerOpenApiGenerationContext p) {
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitNoType(NoType t, WebRouterConfigurerOpenApiGenerationContext p) {
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitUnknown(TypeMirror t, WebRouterConfigurerOpenApiGenerationContext p) {
            return new StringBuilder();
        }

        @Override
        public StringBuilder visitUnion(UnionType type, WebRouterConfigurerOpenApiGenerationContext context) {
            Objects.requireNonNull(type, "type");
            StringBuilder result = new StringBuilder();
            if (((WebRouterConfigurerOpenApiGenerationContext)context).schemaOptions.inList) {
                result.append(context.indentList(0));
            } else {
                result.append(context.indent(0));
            }
            result.append("type: ").append("object");
            return result;
        }

        @Override
        public StringBuilder visitIntersection(IntersectionType type, WebRouterConfigurerOpenApiGenerationContext context) {
            StringBuilder result = new StringBuilder();
            if (((WebRouterConfigurerOpenApiGenerationContext)context).schemaOptions.inList) {
                result.append(context.indentList(0));
            } else {
                result.append(context.indent(0));
            }
            result.append("type: ").append("object");
            return result;
        }
    }

    public static class ResponseSpec {
        private final String status;
        private final StringBuilder description;
        private final TypeMirror type;

        private ResponseSpec(String status, StringBuilder description, TypeMirror type) {
            this.status = status;
            this.type = type;
            this.description = description;
        }

        public String getStatus() {
            return this.status;
        }

        public StringBuilder getDescription() {
            return this.description;
        }

        public TypeMirror getType() {
            return this.type;
        }
    }

    public static enum GenerationMode {
        ROUTER_SPEC,
        CONTROLLER_TAG,
        ROUTE_PATH,
        ROUTE_PARAMETER,
        ROUTE_BODY;

    }
}

