/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.web.compiler.internal;

import io.inverno.core.compiler.spi.BeanInfo;
import io.inverno.core.compiler.spi.ReporterInfo;
import io.inverno.core.compiler.spi.plugin.CompilerPlugin;
import io.inverno.core.compiler.spi.plugin.PluginContext;
import io.inverno.core.compiler.spi.plugin.PluginExecution;
import io.inverno.core.compiler.spi.plugin.PluginExecutionException;
import io.inverno.mod.web.WebExchange;
import io.inverno.mod.web.WebRouterConfigurer;
import io.inverno.mod.web.annotation.WebController;
import io.inverno.mod.web.annotation.WebRoute;
import io.inverno.mod.web.annotation.WebRoutes;
import io.inverno.mod.web.compiler.internal.GenericWebControllerInfo;
import io.inverno.mod.web.compiler.internal.GenericWebProvidedRouterConfigurerInfo;
import io.inverno.mod.web.compiler.internal.GenericWebRouteInfo;
import io.inverno.mod.web.compiler.internal.GenericWebRouterConfigurerInfo;
import io.inverno.mod.web.compiler.internal.ProvidedWebRouteInfo;
import io.inverno.mod.web.compiler.internal.TypeHierarchyExtractor;
import io.inverno.mod.web.compiler.internal.WebRouteDuplicateDetector;
import io.inverno.mod.web.compiler.internal.WebRouteInfoFactory;
import io.inverno.mod.web.compiler.internal.WebRouterConfigurerClassGenerationContext;
import io.inverno.mod.web.compiler.internal.WebRouterConfigurerClassGenerator;
import io.inverno.mod.web.compiler.internal.WebRouterConfigurerOpenApiGenerationContext;
import io.inverno.mod.web.compiler.internal.WebRouterConfigurerOpenApiGenerator;
import io.inverno.mod.web.compiler.spi.WebControllerInfo;
import io.inverno.mod.web.compiler.spi.WebProvidedRouterConfigurerInfo;
import io.inverno.mod.web.compiler.spi.WebRouteInfo;
import io.inverno.mod.web.compiler.spi.WebRouterConfigurerQualifiedName;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class WebRouterConfigurerCompilerPlugin
implements CompilerPlugin {
    private static final String OPTION_GENERATE_OPENAPI_DEFINITION = "inverno.web.generateOpenApiDefinition";
    private final WebRouterConfigurerOpenApiGenerator openApiGenrator;
    private final WebRouterConfigurerClassGenerator webRouterConfigurerClassGenerator = new WebRouterConfigurerClassGenerator();
    private final WebRouteDuplicateDetector webRouteDuplicateDectector;
    private PluginContext pluginContext;
    private TypeHierarchyExtractor typeHierarchyExtractor;
    private TypeMirror webControllerAnnotationType;
    private TypeMirror webRoutesAnnotationType;
    private TypeMirror webRouterConfigurerType;
    private boolean enabled = true;

    public WebRouterConfigurerCompilerPlugin() {
        this.openApiGenrator = new WebRouterConfigurerOpenApiGenerator();
        this.webRouteDuplicateDectector = new WebRouteDuplicateDetector();
    }

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(WebRoute.class.getCanonicalName(), WebController.class.getCanonicalName());
    }

    public Set<String> getSupportedOptions() {
        return Set.of(OPTION_GENERATE_OPENAPI_DEFINITION);
    }

    public void init(PluginContext pluginContext) {
        this.pluginContext = pluginContext;
        TypeElement webControllerElement = this.pluginContext.getElementUtils().getTypeElement(WebController.class.getCanonicalName());
        if (webControllerElement == null) {
            this.enabled = false;
            if (pluginContext.getOptions().isDebug()) {
                System.err.println("Plugin " + WebRouterConfigurerCompilerPlugin.class.getCanonicalName() + " disabled due to missing dependencies");
            }
            return;
        }
        this.webControllerAnnotationType = webControllerElement.asType();
        this.webRoutesAnnotationType = this.pluginContext.getElementUtils().getTypeElement(WebRoutes.class.getCanonicalName()).asType();
        TypeMirror webExchangeType = this.pluginContext.getElementUtils().getTypeElement(WebExchange.class.getCanonicalName()).asType();
        TypeElement webRouterConfigurerTypeElement = this.pluginContext.getElementUtils().getTypeElement(WebRouterConfigurer.class.getCanonicalName());
        this.webRouterConfigurerType = this.pluginContext.getTypeUtils().getDeclaredType(webRouterConfigurerTypeElement, webExchangeType);
        this.typeHierarchyExtractor = new TypeHierarchyExtractor(this.pluginContext.getTypeUtils());
    }

    public boolean canExecute(ModuleElement moduleElement) {
        return this.enabled && this.pluginContext.getElementUtils().getTypeElement(moduleElement, WebController.class.getCanonicalName()) != null;
    }

    public void execute(PluginExecution execution) throws PluginExecutionException {
        WebRouteInfoFactory webRouteFactory = new WebRouteInfoFactory(this.pluginContext, execution);
        WebRouterConfigurerQualifiedName webRouterConfigurerQName = new WebRouterConfigurerQualifiedName(execution.getModuleQualifiedName());
        this.processWebRoutes(execution, webRouteFactory);
        List<? extends WebControllerInfo> webControllers = this.processWebControllers(execution, webRouteFactory);
        List<? extends WebProvidedRouterConfigurerInfo> webRouters = this.processWebRouters(execution, webRouteFactory);
        GenericWebRouterConfigurerInfo webRouterConfigurerInfo = new GenericWebRouterConfigurerInfo(execution.getModuleElement(), webRouterConfigurerQName, webControllers, webRouters);
        for (Map.Entry<WebRouteInfo, Set<WebRouteInfo>> e : this.webRouteDuplicateDectector.findDuplicates(Stream.concat(webControllers.stream().flatMap(controller -> Arrays.stream(controller.getRoutes())), webRouters.stream().flatMap(router -> Arrays.stream(router.getRoutes()))).collect(Collectors.toList())).entrySet()) {
            e.getKey().error("Route " + e.getKey().getQualifiedName() + " is conflicting with route(s):\n" + e.getValue().stream().map(route -> "- " + route.getQualifiedName()).collect(Collectors.joining("\n")));
        }
        if (!(webRouterConfigurerInfo.hasError() || webRouterConfigurerInfo.getControllers().length <= 0 && webRouterConfigurerInfo.getRouters().length <= 0)) {
            try {
                execution.createSourceFile(webRouterConfigurerInfo.getQualifiedName().getClassName(), (Element[])execution.getElements().stream().toArray(Element[]::new), () -> webRouterConfigurerInfo.accept(this.webRouterConfigurerClassGenerator, new WebRouterConfigurerClassGenerationContext(this.pluginContext.getTypeUtils(), this.pluginContext.getElementUtils(), WebRouterConfigurerClassGenerationContext.GenerationMode.CONFIGURER_CLASS)).toString());
            }
            catch (IOException e) {
                throw new PluginExecutionException("Unable to generate web router configurer class " + webRouterConfigurerInfo.getQualifiedName().getClassName(), (Throwable)e);
            }
            if (webRouterConfigurerInfo.getControllers().length > 0 && this.pluginContext.getOptions().isOptionActivated(OPTION_GENERATE_OPENAPI_DEFINITION, false)) {
                try {
                    execution.createResourceFile("META-INF/inverno/web/openapi.yml", (Element[])execution.getElements().stream().toArray(Element[]::new), () -> webRouterConfigurerInfo.accept(this.openApiGenrator, new WebRouterConfigurerOpenApiGenerationContext(this.pluginContext.getTypeUtils(), this.pluginContext.getElementUtils(), this.pluginContext.getDocUtils(), WebRouterConfigurerOpenApiGenerationContext.GenerationMode.ROUTER_SPEC)).toString());
                }
                catch (Exception e) {
                    System.err.print("\n");
                    System.err.println("Error generating OpenApi specification for module : " + execution.getModuleQualifiedName());
                    if (this.pluginContext.getOptions().isDebug()) {
                        e.printStackTrace();
                    }
                    System.out.print("... ");
                }
            }
        }
    }

    private void processWebRoutes(PluginExecution execution, WebRouteInfoFactory webRouteFactory) {
        for (ExecutableElement routeElement : execution.getElementsAnnotatedWith(WebRoute.class)) {
            webRouteFactory.compileRoute(routeElement);
        }
    }

    private List<? extends WebControllerInfo> processWebControllers(PluginExecution execution, WebRouteInfoFactory webRouteFactory) {
        return Arrays.stream(execution.getBeans()).map(bean -> {
            TypeElement beanElement = (TypeElement)this.pluginContext.getTypeUtils().asElement(bean.getType());
            return this.typeHierarchyExtractor.extractTypeHierarchy(beanElement).stream().map(element -> this.pluginContext.getElementUtils().getAllAnnotationMirrors((Element)element).stream().filter(annotation -> this.pluginContext.getTypeUtils().isSameType(annotation.getAnnotationType(), this.webControllerAnnotationType)).findFirst()).filter(Optional::isPresent).map(Optional::get).findFirst().map(webControllerAnnotation -> {
                String controllerRootPath = null;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> value : this.pluginContext.getElementUtils().getElementValuesWithDefaults((AnnotationMirror)webControllerAnnotation).entrySet()) {
                    switch (value.getKey().getSimpleName().toString()) {
                        case "path": {
                            controllerRootPath = (String)value.getValue().getValue();
                        }
                    }
                }
                List<GenericWebRouteInfo> webRoutes = webRouteFactory.compileControllerRoutes((BeanInfo)bean);
                if (webRoutes.isEmpty()) {
                    bean.warning("Ignoring web controller which does not define any route");
                    return null;
                }
                return new GenericWebControllerInfo(beanElement, bean.getQualifiedName(), (ReporterInfo)bean, (DeclaredType)bean.getType(), controllerRootPath, webRoutes);
            });
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private List<? extends WebProvidedRouterConfigurerInfo> processWebRouters(PluginExecution execution, WebRouteInfoFactory webRouteFactory) {
        return Arrays.stream(execution.getBeans()).filter(bean -> this.pluginContext.getTypeUtils().isAssignable(bean.getType(), this.webRouterConfigurerType)).map(bean -> {
            TypeElement beanElement = (TypeElement)this.pluginContext.getTypeUtils().asElement(bean.getType());
            Optional<GenericWebProvidedRouterConfigurerInfo> providedRouterConfigurerInfo = this.pluginContext.getElementUtils().getAllAnnotationMirrors(beanElement).stream().filter(annotation -> this.pluginContext.getTypeUtils().isSameType(annotation.getAnnotationType(), this.webRoutesAnnotationType)).findFirst().map(webRouterConfigurerAnnotation -> {
                List<ProvidedWebRouteInfo> webRoutes = webRouteFactory.compileRouterRoutes((BeanInfo)bean);
                if (webRoutes.isEmpty()) {
                    return null;
                }
                return new GenericWebProvidedRouterConfigurerInfo(beanElement, new WebRouterConfigurerQualifiedName(bean.getQualifiedName(), this.pluginContext.getTypeUtils().asElement(this.pluginContext.getTypeUtils().erasure(bean.getType())).getSimpleName().toString()), (BeanInfo)bean, (List<? extends WebRouteInfo>)webRoutes);
            });
            if (!providedRouterConfigurerInfo.isPresent()) {
                bean.warning("Ignoring web router configurer which does not define any route");
                return null;
            }
            return providedRouterConfigurerInfo.get();
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

