/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.web.compiler.internal;

import io.inverno.core.annotation.Bean;
import io.inverno.core.compiler.spi.QualifiedName;
import io.inverno.mod.base.net.URIs;
import io.inverno.mod.web.WebExchange;
import io.inverno.mod.web.WebRouter;
import io.inverno.mod.web.WebRouterConfigurer;
import io.inverno.mod.web.annotation.WebRoutes;
import io.inverno.mod.web.compiler.internal.WebRouterConfigurerClassGenerationContext;
import io.inverno.mod.web.compiler.spi.WebBasicParameterInfo;
import io.inverno.mod.web.compiler.spi.WebControllerInfo;
import io.inverno.mod.web.compiler.spi.WebCookieParameterInfo;
import io.inverno.mod.web.compiler.spi.WebExchangeParameterInfo;
import io.inverno.mod.web.compiler.spi.WebFormParameterInfo;
import io.inverno.mod.web.compiler.spi.WebHeaderParameterInfo;
import io.inverno.mod.web.compiler.spi.WebParameterInfo;
import io.inverno.mod.web.compiler.spi.WebPathParameterInfo;
import io.inverno.mod.web.compiler.spi.WebProvidedRouterConfigurerInfo;
import io.inverno.mod.web.compiler.spi.WebQueryParameterInfo;
import io.inverno.mod.web.compiler.spi.WebRequestBodyParameterInfo;
import io.inverno.mod.web.compiler.spi.WebResponseBodyInfo;
import io.inverno.mod.web.compiler.spi.WebRouteInfo;
import io.inverno.mod.web.compiler.spi.WebRouterConfigurerInfo;
import io.inverno.mod.web.compiler.spi.WebRouterConfigurerInfoVisitor;
import io.inverno.mod.web.compiler.spi.WebSseEventFactoryParameterInfo;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

class WebRouterConfigurerClassGenerator
implements WebRouterConfigurerInfoVisitor<StringBuilder, WebRouterConfigurerClassGenerationContext> {
    WebRouterConfigurerClassGenerator() {
    }

    @Override
    public StringBuilder visit(WebRouterConfigurerInfo routerConfigurerInfo, WebRouterConfigurerClassGenerationContext context) {
        String configurerClassName = routerConfigurerInfo.getQualifiedName().getClassName();
        String configurerPackageName = configurerClassName.lastIndexOf(".") != -1 ? configurerClassName.substring(0, configurerClassName.lastIndexOf(".")) : "";
        configurerClassName = configurerClassName.substring(configurerPackageName.length() + 1);
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.CONFIGURER_CLASS) {
            TypeMirror beanAnnotationType = context.getElementUtils().getTypeElement(Bean.class.getCanonicalName()).asType();
            TypeMirror webExchangeType = context.getElementUtils().getTypeElement(WebExchange.class.getCanonicalName()).asType();
            DeclaredType webRouterConfigurerType = context.getTypeUtils().getDeclaredType(context.getElementUtils().getTypeElement(WebRouterConfigurer.class.getCanonicalName()), webExchangeType);
            DeclaredType routerType = context.getTypeUtils().getDeclaredType(context.getElementUtils().getTypeElement(WebRouter.class.getCanonicalName()), webExchangeType);
            context.addImport(configurerClassName, configurerPackageName + "." + configurerClassName);
            StringBuilder configurerAnnotation = this.visit(routerConfigurerInfo, context.withIndentDepth(1).withMode(WebRouterConfigurerClassGenerationContext.GenerationMode.CONFIGURER_ANNOTATION));
            StringBuilder configurer_controller_fields = (StringBuilder)Arrays.stream(routerConfigurerInfo.getControllers()).map(controllerInfo -> this.visit((WebControllerInfo)controllerInfo, context.withIndentDepth(1).withMode(WebRouterConfigurerClassGenerationContext.GenerationMode.CONTROLLER_FIELD))).collect(context.joining("\n"));
            StringBuilder configurer_router_fields = (StringBuilder)Arrays.stream(routerConfigurerInfo.getRouters()).map(routerInfo -> this.visit((WebProvidedRouterConfigurerInfo)routerInfo, context.withIndentDepth(1).withMode(WebRouterConfigurerClassGenerationContext.GenerationMode.CONFIGURER_FIELD))).collect(context.joining("\n"));
            StringBuilder configurer_constructor = new StringBuilder(context.indent(1)).append("public ").append(configurerClassName).append("(");
            configurer_constructor.append((CharSequence)Stream.concat(Arrays.stream(routerConfigurerInfo.getControllers()).map(controllerInfo -> this.visit((WebControllerInfo)controllerInfo, context.withIndentDepth(0).withMode(WebRouterConfigurerClassGenerationContext.GenerationMode.CONTROLLER_PARAMETER))), Arrays.stream(routerConfigurerInfo.getRouters()).map(routerInfo -> this.visit((WebProvidedRouterConfigurerInfo)routerInfo, context.withIndentDepth(0).withMode(WebRouterConfigurerClassGenerationContext.GenerationMode.CONFIGURER_PARAMETER)))).collect(context.joining(", ")));
            configurer_constructor.append(") {\n");
            configurer_constructor.append((CharSequence)Stream.concat(Arrays.stream(routerConfigurerInfo.getControllers()).map(controllerInfo -> this.visit((WebControllerInfo)controllerInfo, context.withIndentDepth(2).withMode(WebRouterConfigurerClassGenerationContext.GenerationMode.CONTROLLER_ASSIGNMENT))), Arrays.stream(routerConfigurerInfo.getRouters()).map(routerInfo -> this.visit((WebProvidedRouterConfigurerInfo)routerInfo, context.withIndentDepth(2).withMode(WebRouterConfigurerClassGenerationContext.GenerationMode.CONFIGURER_ASSIGNMENT)))).collect(context.joining("\n")));
            configurer_constructor.append("\n").append(context.indent(1)).append("}");
            StringBuilder configurer_accept = new StringBuilder(context.indent(1)).append("@Override\n");
            configurer_accept.append(context.indent(1)).append("public void accept(").append(context.getTypeName(routerType)).append(" router) {");
            if (routerConfigurerInfo.getRouters().length > 0) {
                configurer_accept.append("\n").append((CharSequence)Arrays.stream(routerConfigurerInfo.getRouters()).map(routerInfo -> this.visit((WebProvidedRouterConfigurerInfo)routerInfo, context.withIndentDepth(2).withMode(WebRouterConfigurerClassGenerationContext.GenerationMode.CONFIGURER_INVOKE))).collect(context.joining("\n"))).append("\n");
            }
            if (routerConfigurerInfo.getControllers().length > 0) {
                configurer_accept.append("\n").append(context.indent(2)).append("router\n");
                configurer_accept.append((CharSequence)Arrays.stream(routerConfigurerInfo.getControllers()).map(controllerInfo -> this.visit((WebControllerInfo)controllerInfo, context.withIndentDepth(3).withMode(WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_DECLARATION))).collect(context.joining("\n")));
                configurer_accept.append(";\n");
            }
            configurer_accept.append(context.indent(1)).append("}");
            StringBuilder configurer_class = new StringBuilder();
            configurer_class.append((CharSequence)configurerAnnotation).append("\n");
            configurer_class.append("@").append(context.getTypeName(beanAnnotationType)).append("\n");
            configurer_class.append("public final class ").append(configurerClassName).append(" implements ").append(context.getTypeName(webRouterConfigurerType)).append(" {\n\n");
            if (routerConfigurerInfo.getControllers().length > 0) {
                configurer_class.append((CharSequence)configurer_controller_fields).append("\n\n");
            }
            if (routerConfigurerInfo.getRouters().length > 0) {
                configurer_class.append((CharSequence)configurer_router_fields).append("\n\n");
            }
            configurer_class.append((CharSequence)configurer_constructor).append("\n\n");
            configurer_class.append((CharSequence)configurer_accept).append("\n");
            configurer_class.append("}");
            context.removeImport(configurerClassName);
            configurer_class.insert(0, "\n\n").insert(0, (CharSequence)context.getImports().stream().sorted().filter(i -> i.lastIndexOf(".") > 0 && !i.substring(0, i.lastIndexOf(".")).equals(configurerPackageName)).map(i -> new StringBuilder().append("import ").append((String)i).append(";")).collect(context.joining("\n")));
            if (!configurerPackageName.equals("")) {
                configurer_class.insert(0, ";\n\n").insert(0, configurerPackageName).insert(0, "package ");
            }
            return configurer_class;
        }
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.CONFIGURER_ANNOTATION) {
            TypeMirror webRoutesAnnotationType = context.getElementUtils().getTypeElement(WebRoutes.class.getCanonicalName()).asType();
            StringBuilder result = new StringBuilder();
            result.append("@").append(context.getTypeName(webRoutesAnnotationType)).append("({\n");
            result.append((CharSequence)Stream.concat(Arrays.stream(routerConfigurerInfo.getRouters()).map(routerInfo -> this.visit((WebProvidedRouterConfigurerInfo)routerInfo, context)), Arrays.stream(routerConfigurerInfo.getControllers()).flatMap(controllerInfo -> Arrays.stream(controllerInfo.getRoutes()).map(routeInfo -> this.visit((WebRouteInfo)routeInfo, context.withWebController((WebControllerInfo)controllerInfo).withMode(WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_ANNOTATION))))).collect(context.joining(",\n")));
            result.append("\n})");
            return result;
        }
        return new StringBuilder();
    }

    @Override
    public StringBuilder visit(WebProvidedRouterConfigurerInfo providedRouterConfigurerInfo, WebRouterConfigurerClassGenerationContext context) {
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.CONFIGURER_ANNOTATION) {
            return (StringBuilder)Arrays.stream(providedRouterConfigurerInfo.getRoutes()).map(routeInfo -> this.visit((WebRouteInfo)routeInfo, context.withMode(WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_ANNOTATION))).collect(context.joining(",\n"));
        }
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.CONFIGURER_FIELD) {
            return new StringBuilder(context.indent(0)).append("private ").append(context.getTypeName(providedRouterConfigurerInfo.getType())).append(" ").append(context.getFieldName((QualifiedName)providedRouterConfigurerInfo.getQualifiedName())).append(";");
        }
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.CONFIGURER_PARAMETER) {
            return new StringBuilder(context.indent(0)).append(context.getTypeName(providedRouterConfigurerInfo.getType())).append(" ").append(context.getFieldName((QualifiedName)providedRouterConfigurerInfo.getQualifiedName()));
        }
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.CONFIGURER_ASSIGNMENT) {
            return new StringBuilder(context.indent(0)).append("this.").append(context.getFieldName((QualifiedName)providedRouterConfigurerInfo.getQualifiedName())).append(" = ").append(context.getFieldName((QualifiedName)providedRouterConfigurerInfo.getQualifiedName())).append(";");
        }
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.CONFIGURER_INVOKE) {
            return new StringBuilder(context.indent(0)).append("this.").append(context.getFieldName((QualifiedName)providedRouterConfigurerInfo.getQualifiedName())).append(".accept(router);");
        }
        return new StringBuilder();
    }

    @Override
    public StringBuilder visit(WebControllerInfo controllerInfo, WebRouterConfigurerClassGenerationContext context) {
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.CONTROLLER_FIELD) {
            return new StringBuilder(context.indent(0)).append("private ").append(context.getTypeName(controllerInfo.getType())).append(" ").append(context.getFieldName((QualifiedName)controllerInfo.getQualifiedName())).append(";");
        }
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.CONTROLLER_PARAMETER) {
            return new StringBuilder(context.indent(0)).append(context.getTypeName(controllerInfo.getType())).append(" ").append(context.getFieldName((QualifiedName)controllerInfo.getQualifiedName()));
        }
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.CONTROLLER_ASSIGNMENT) {
            return new StringBuilder(context.indent(0)).append("this.").append(context.getFieldName((QualifiedName)controllerInfo.getQualifiedName())).append(" = ").append(context.getFieldName((QualifiedName)controllerInfo.getQualifiedName())).append(";");
        }
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_DECLARATION) {
            return (StringBuilder)Arrays.stream(controllerInfo.getRoutes()).map(routeInfo -> this.visit((WebRouteInfo)routeInfo, context.withWebController(controllerInfo))).collect(context.joining("\n"));
        }
        return new StringBuilder();
    }

    @Override
    public StringBuilder visit(WebRouteInfo routeInfo, WebRouterConfigurerClassGenerationContext context) {
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_ANNOTATION) {
            StringBuilder result = new StringBuilder();
            result.append(context.indent(0)).append("@").append(context.getWebRouteAnnotationTypeName()).append("(");
            result.append("path = { ");
            if (routeInfo.getPaths().length > 0) {
                result.append(Arrays.stream(routeInfo.getPaths()).map(path -> "\"" + routeInfo.getController().map(WebControllerInfo::getRootPath).map(rootPath -> URIs.uri((String)rootPath, (URIs.Option[])new URIs.Option[]{URIs.Option.PARAMETERIZED, URIs.Option.NORMALIZED}).path(path, false).buildRawPath()).orElse((String)path) + "\"").collect(Collectors.joining(", ")));
            } else {
                routeInfo.getController().map(WebControllerInfo::getRootPath).map(rootPath -> URIs.uri((String)rootPath, (URIs.Option[])new URIs.Option[]{URIs.Option.PARAMETERIZED, URIs.Option.NORMALIZED}).buildRawPath()).ifPresent(rootPath -> result.append("\"").append((String)rootPath).append("\""));
            }
            result.append(" }");
            if (routeInfo.isMatchTrailingSlash()) {
                result.append(", matchTrailingSlash = true");
            }
            if (routeInfo.getMethods() != null && routeInfo.getMethods().length > 0) {
                result.append(", method = { ").append(Arrays.stream(routeInfo.getMethods()).map(method -> context.getMethodTypeName() + "." + method.toString()).collect(Collectors.joining(", "))).append(" }");
            }
            if (routeInfo.getConsumes() != null && routeInfo.getConsumes().length > 0) {
                result.append(", consumes = { ").append(Arrays.stream(routeInfo.getConsumes()).map(consumes -> "\"" + consumes + "\"").collect(Collectors.joining(", "))).append(" }");
            }
            if (routeInfo.getProduces() != null && routeInfo.getProduces().length > 0) {
                result.append(", produces = { ").append(Arrays.stream(routeInfo.getProduces()).map(produces -> "\"" + produces + "\"").collect(Collectors.joining(", "))).append(" }");
            }
            if (routeInfo.getLanguages() != null && routeInfo.getLanguages().length > 0) {
                result.append(", language = { ").append(Arrays.stream(routeInfo.getLanguages()).map(language -> "\"" + language + "\"").collect(Collectors.joining(", "))).append(" }");
            }
            result.append(")");
            return result;
        }
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_DECLARATION) {
            boolean typesMode = context.isTypeMode(routeInfo);
            WebRouterConfigurerClassGenerationContext.GenerationMode handlerBodyMode = typesMode ? WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_HANDLER_BODY_TYPE : WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_HANDLER_BODY_CLASS;
            StringBuilder routeHandler = new StringBuilder("exchange -> {\n");
            routeHandler.append((CharSequence)this.visit(routeInfo.getResponseBody(), context.withIndentDepth(context.getIndentDepth() + (typesMode ? 2 : 1)).withWebRoute(routeInfo).withMode(handlerBodyMode)));
            routeHandler.append(context.indent(typesMode ? 1 : 0)).append("}");
            StringBuilder routeManager = new StringBuilder();
            if (routeInfo.getPaths().length > 0) {
                routeManager.append(Arrays.stream(routeInfo.getPaths()).map(path -> ".path(\"" + routeInfo.getController().map(WebControllerInfo::getRootPath).map(rootPath -> URIs.uri((String)rootPath, (URIs.Option[])new URIs.Option[]{URIs.Option.PARAMETERIZED, URIs.Option.NORMALIZED}).path(path, false).buildRawPath()).orElse((String)path) + "\", " + routeInfo.isMatchTrailingSlash() + ")").collect(Collectors.joining()));
            } else {
                routeInfo.getController().map(WebControllerInfo::getRootPath).map(rootPath -> URIs.uri((String)rootPath, (URIs.Option[])new URIs.Option[]{URIs.Option.PARAMETERIZED, URIs.Option.NORMALIZED}).buildRawPath()).ifPresent(rootPath -> routeManager.append(".path(\"").append((String)rootPath).append("\", ").append(routeInfo.isMatchTrailingSlash()).append(")"));
            }
            if (routeInfo.getMethods() != null && routeInfo.getMethods().length > 0) {
                routeManager.append(Arrays.stream(routeInfo.getMethods()).map(method -> ".method(" + context.getMethodTypeName() + "." + method.toString() + ")").collect(Collectors.joining()));
            }
            if (routeInfo.getConsumes() != null && routeInfo.getConsumes().length > 0) {
                routeManager.append(Arrays.stream(routeInfo.getConsumes()).map(consumes -> ".consumes(\"" + consumes + "\")").collect(Collectors.joining()));
            }
            if (routeInfo.getProduces() != null && routeInfo.getProduces().length > 0) {
                routeManager.append(Arrays.stream(routeInfo.getProduces()).map(produces -> ".produces(\"" + produces + "\")").collect(Collectors.joining()));
            }
            if (routeInfo.getLanguages() != null && routeInfo.getLanguages().length > 0) {
                routeManager.append(Arrays.stream(routeInfo.getLanguages()).map(language -> ".language(\"" + language + "\")").collect(Collectors.joining()));
            }
            routeManager.append(".handler(").append((CharSequence)routeHandler).append(")");
            if (typesMode) {
                StringBuilder routeTypes = new StringBuilder(context.getTypeTypeName()).append("[] routeTypes = new ").append(context.getTypeTypeName()).append("[] {\n");
                routeTypes.append((CharSequence)Stream.concat(Arrays.stream(routeInfo.getParameters()).map(parameterInfo -> {
                    if (parameterInfo instanceof WebRequestBodyParameterInfo) {
                        return parameterInfo.getType();
                    }
                    return context.getParameterConverterType(parameterInfo.getType());
                }), routeInfo.getResponseBody().getBodyKind() != WebResponseBodyInfo.ResponseBodyKind.EMPTY ? Stream.of(routeInfo.getResponseBody().getType()) : Stream.of(new TypeMirror[0])).map(converterType -> new StringBuilder(context.indent(2)).append((CharSequence)context.getTypeGenerator((TypeMirror)converterType))).collect(context.joining(",\n")));
                routeTypes.append("\n").append(context.indent(1)).append("}");
                StringBuilder result = new StringBuilder(context.indent(0)).append(".route(route -> {\n");
                result.append(context.indent(1)).append((CharSequence)routeTypes).append(";\n");
                result.append(context.indent(1)).append("route").append((CharSequence)routeManager).append(";\n");
                result.append(context.indent(0)).append("})");
                return result;
            }
            return new StringBuilder(context.indent(0)).append(".route()").append((CharSequence)routeManager);
        }
        return new StringBuilder();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public StringBuilder visit(WebResponseBodyInfo responseBodyInfo, WebRouterConfigurerClassGenerationContext context) {
        if (context.getMode() != WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_HANDLER_BODY_CLASS && context.getMode() != WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_HANDLER_BODY_TYPE) return new StringBuilder();
        boolean typesMode = context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_HANDLER_BODY_TYPE;
        StringBuilder result = new StringBuilder();
        WebRouteInfo routeInfo = context.getWebRoute();
        StringBuilder requestParameters = new StringBuilder();
        WebRouterConfigurerClassGenerationContext.GenerationMode parameterReferenceMode = typesMode ? WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_TYPE : WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_CLASS;
        Integer nonReactiveRequestBodyParameterIndex = null;
        boolean hasFormParameters = false;
        WebRequestBodyParameterInfo requestBodyInfo = null;
        int parameterIndex = 0;
        Iterator parameterInfoIterator = Arrays.stream(routeInfo.getParameters()).iterator();
        while (parameterInfoIterator.hasNext()) {
            WebParameterInfo parameterInfo = (WebParameterInfo)parameterInfoIterator.next();
            if (parameterInfo instanceof WebRequestBodyParameterInfo && ((WebRequestBodyParameterInfo)parameterInfo).getBodyReactiveKind() == WebRequestBodyParameterInfo.RequestBodyReactiveKind.NONE) {
                nonReactiveRequestBodyParameterIndex = parameterIndex;
                requestParameters.append("body");
            } else {
                requestParameters.append((CharSequence)this.visit(parameterInfo, context.withIndentDepth(0).withMode(parameterReferenceMode).withParameterIndex(parameterIndex)));
            }
            if (parameterInfo instanceof WebFormParameterInfo) {
                hasFormParameters = true;
            }
            if (parameterInfo instanceof WebRequestBodyParameterInfo) {
                requestBodyInfo = (WebRequestBodyParameterInfo)parameterInfo;
            }
            if (parameterInfoIterator.hasNext()) {
                requestParameters.append(", ");
            }
            ++parameterIndex;
        }
        StringBuilder controllerInvoke = new StringBuilder("this.").append(context.getFieldName((QualifiedName)context.getWebController().getQualifiedName())).append(".").append(routeInfo.getElement().get().getSimpleName().toString()).append("(").append((CharSequence)requestParameters).append(")");
        if (responseBodyInfo.getBodyKind() == WebResponseBodyInfo.ResponseBodyKind.EMPTY && responseBodyInfo.getBodyReactiveKind() == WebResponseBodyInfo.ResponseBodyReactiveKind.NONE) {
            if (hasFormParameters) {
                result.append(context.indent(0)).append("exchange.response().body().raw().stream(");
                result.append(context.getFluxTypeName()).append(".from(exchange.request().body().get().urlEncoded().stream()).collectMultimap(").append(context.getParameterTypeName()).append("::getName)").append(".flatMap(formParameters -> ");
                result.append("{ ").append((CharSequence)controllerInvoke).append("; return ").append(context.getMonoTypeName()).append(".empty(); }");
                result.append("));\n");
                return result;
            } else if (nonReactiveRequestBodyParameterIndex != null) {
                result.append(context.indent(0)).append("exchange.response().body().raw().stream(");
                result.append((CharSequence)this.visit(routeInfo.getParameters()[nonReactiveRequestBodyParameterIndex], context.withIndentDepth(0).withMode(parameterReferenceMode).withParameterIndex(nonReactiveRequestBodyParameterIndex))).append(".flatMap(body -> ");
                result.append("{ ").append((CharSequence)controllerInvoke).append("; return ").append(context.getMonoTypeName()).append(".empty(); }");
                result.append("));\n");
                return result;
            } else {
                result.append(context.indent(0)).append((CharSequence)controllerInvoke).append(";\n");
                result.append(context.indent(0)).append("exchange.response().body().empty();\n");
            }
            return result;
        } else {
            String responseBodyDataMethod;
            if (nonReactiveRequestBodyParameterIndex != null) {
                if (responseBodyInfo.getBodyReactiveKind() == WebResponseBodyInfo.ResponseBodyReactiveKind.NONE) {
                    controllerInvoke.insert(0, this.visit(routeInfo.getParameters()[nonReactiveRequestBodyParameterIndex], context.withIndentDepth(0).withMode(parameterReferenceMode).withParameterIndex(nonReactiveRequestBodyParameterIndex)).append(".map(body -> ")).append(")");
                } else if (responseBodyInfo.getBodyReactiveKind() == WebResponseBodyInfo.ResponseBodyReactiveKind.ONE) {
                    controllerInvoke.insert(0, this.visit(routeInfo.getParameters()[nonReactiveRequestBodyParameterIndex], context.withIndentDepth(0).withMode(parameterReferenceMode).withParameterIndex(nonReactiveRequestBodyParameterIndex)).append(".flatMap(body -> ")).append(")");
                } else {
                    if (responseBodyInfo.getBodyReactiveKind() != WebResponseBodyInfo.ResponseBodyReactiveKind.PUBLISHER && responseBodyInfo.getBodyReactiveKind() != WebResponseBodyInfo.ResponseBodyReactiveKind.MANY) throw new IllegalStateException("Unknown response body reactive kind: " + responseBodyInfo.getBodyReactiveKind());
                    controllerInvoke.insert(0, this.visit(routeInfo.getParameters()[nonReactiveRequestBodyParameterIndex], context.withIndentDepth(0).withMode(parameterReferenceMode).withParameterIndex(nonReactiveRequestBodyParameterIndex)).append(".flatMapMany(body -> ")).append(")");
                }
            } else if (hasFormParameters) {
                controllerInvoke.insert(0, new StringBuilder(context.getFluxTypeName()).append(".from(exchange.request().body().get().urlEncoded().stream()).collectMultimap(").append(context.getParameterTypeName()).append("::getName)").append(".map(formParameters -> ")).append(")");
            }
            if (responseBodyInfo.getBodyKind() == WebResponseBodyInfo.ResponseBodyKind.EMPTY) {
                if (responseBodyInfo.getBodyReactiveKind() == WebResponseBodyInfo.ResponseBodyReactiveKind.PUBLISHER) {
                    controllerInvoke.insert(0, new StringBuilder(context.getFluxTypeName()).append(".from(")).append(")");
                }
                result.append(context.indent(0)).append("exchange.response().body().raw().stream(");
                result.append((CharSequence)controllerInvoke).append(".then().cast(").append(context.getByteBufTypeName()).append(".class)");
                result.append(");\n");
                return result;
            } else if (responseBodyInfo.getBodyKind() == WebResponseBodyInfo.ResponseBodyKind.RAW) {
                responseBodyDataMethod = responseBodyInfo.getBodyReactiveKind() == WebResponseBodyInfo.ResponseBodyReactiveKind.NONE ? (hasFormParameters || requestBodyInfo != null ? "stream" : "value") : "stream";
                result.append(context.indent(0)).append("exchange.response().body().raw().").append(responseBodyDataMethod).append("(");
                result.append((CharSequence)controllerInvoke);
                result.append(");\n");
                return result;
            } else if (responseBodyInfo.getBodyKind() == WebResponseBodyInfo.ResponseBodyKind.CHARSEQUENCE) {
                responseBodyDataMethod = responseBodyInfo.getBodyReactiveKind() == WebResponseBodyInfo.ResponseBodyReactiveKind.NONE ? (hasFormParameters || requestBodyInfo != null ? "stream" : "value") : "stream";
                result.append(context.indent(0)).append("exchange.response().body().string().").append(responseBodyDataMethod).append("(");
                result.append((CharSequence)controllerInvoke);
                result.append(");\n");
                return result;
            } else if (responseBodyInfo.getBodyKind() == WebResponseBodyInfo.ResponseBodyKind.ENCODED) {
                if (responseBodyInfo.getBodyReactiveKind() == WebResponseBodyInfo.ResponseBodyReactiveKind.NONE) {
                    responseBodyDataMethod = hasFormParameters || requestBodyInfo != null ? "one" : "value";
                } else if (responseBodyInfo.getBodyKind() == WebResponseBodyInfo.ResponseBodyKind.RAW) {
                    responseBodyDataMethod = "stream";
                } else if (responseBodyInfo.getBodyReactiveKind() == WebResponseBodyInfo.ResponseBodyReactiveKind.ONE) {
                    responseBodyDataMethod = "one";
                } else if (responseBodyInfo.getBodyReactiveKind() == WebResponseBodyInfo.ResponseBodyReactiveKind.MANY) {
                    responseBodyDataMethod = "many";
                } else {
                    if (responseBodyInfo.getBodyReactiveKind() != WebResponseBodyInfo.ResponseBodyReactiveKind.PUBLISHER) throw new IllegalStateException("Unknown response body reactive kind: " + responseBodyInfo.getBodyReactiveKind());
                    responseBodyDataMethod = "stream";
                }
                result.append(context.indent(0)).append("exchange.response().body()");
                if (typesMode) {
                    result.append(".<").append(context.getTypeName(responseBodyInfo.getType())).append(">encoder(routeTypes[").append(routeInfo.getParameters().length).append("]).");
                } else {
                    result.append(".encoder(").append(context.getTypeName(responseBodyInfo.getType())).append(".class).");
                }
                result.append(responseBodyDataMethod).append("(");
                result.append((CharSequence)controllerInvoke);
                result.append(");\n");
                return result;
            } else if (responseBodyInfo.getBodyKind() == WebResponseBodyInfo.ResponseBodyKind.RESOURCE) {
                result.append(context.indent(0)).append("exchange.response().body().resource().value(");
                result.append((CharSequence)controllerInvoke);
                result.append(");\n");
                return result;
            } else if (responseBodyInfo.getBodyKind() == WebResponseBodyInfo.ResponseBodyKind.SSE_RAW) {
                result.append(context.indent(0)).append("exchange.response().body().sse().from((events, data) -> data.stream(");
                result.append((CharSequence)controllerInvoke);
                result.append("));\n");
                return result;
            } else if (responseBodyInfo.getBodyKind() == WebResponseBodyInfo.ResponseBodyKind.SSE_CHARSEQUENCE) {
                result.append(context.indent(0)).append("exchange.response().body().<").append(context.getTypeName(responseBodyInfo.getType())).append(">sseString().from((events, data) -> data.stream(");
                result.append((CharSequence)controllerInvoke);
                result.append("));\n");
                return result;
            } else {
                if (responseBodyInfo.getBodyKind() != WebResponseBodyInfo.ResponseBodyKind.SSE_ENCODED) return result;
                WebSseEventFactoryParameterInfo sseEventFactoryParameter = (WebSseEventFactoryParameterInfo)Arrays.stream(context.getWebRoute().getParameters()).filter(parameter -> parameter instanceof WebSseEventFactoryParameterInfo).findFirst().get();
                result.append(context.indent(0)).append("exchange.response().body()");
                if (typesMode) {
                    result.append(".<").append(context.getTypeName(responseBodyInfo.getType())).append(">sseEncoder(\"").append(sseEventFactoryParameter.getDataMediaType().orElse("text/plain")).append("\", ").append("routeTypes[").append(routeInfo.getParameters().length).append("])");
                } else {
                    result.append(".sseEncoder(\"").append(sseEventFactoryParameter.getDataMediaType().orElse("text/plain")).append("\", ").append(context.getTypeName(responseBodyInfo.getType())).append(".class)");
                }
                result.append(".from((events, data) -> data.stream(");
                result.append((CharSequence)controllerInvoke);
                result.append("));\n");
            }
        }
        return result;
    }

    @Override
    public StringBuilder visit(WebParameterInfo parameterInfo, WebRouterConfigurerClassGenerationContext context) {
        if (parameterInfo instanceof WebCookieParameterInfo) {
            return this.visit((WebCookieParameterInfo)parameterInfo, context);
        }
        if (parameterInfo instanceof WebExchangeParameterInfo) {
            return this.visit((WebExchangeParameterInfo)parameterInfo, context);
        }
        if (parameterInfo instanceof WebFormParameterInfo) {
            return this.visit((WebFormParameterInfo)parameterInfo, context);
        }
        if (parameterInfo instanceof WebHeaderParameterInfo) {
            return this.visit((WebHeaderParameterInfo)parameterInfo, context);
        }
        if (parameterInfo instanceof WebPathParameterInfo) {
            return this.visit((WebPathParameterInfo)parameterInfo, context);
        }
        if (parameterInfo instanceof WebQueryParameterInfo) {
            return this.visit((WebQueryParameterInfo)parameterInfo, context);
        }
        if (parameterInfo instanceof WebRequestBodyParameterInfo) {
            return this.visit((WebRequestBodyParameterInfo)parameterInfo, context);
        }
        if (parameterInfo instanceof WebSseEventFactoryParameterInfo) {
            return this.visit((WebSseEventFactoryParameterInfo)parameterInfo, context);
        }
        return new StringBuilder();
    }

    @Override
    public StringBuilder visit(WebBasicParameterInfo basicParameterInfo, WebRouterConfigurerClassGenerationContext context) {
        block22: {
            StringBuilder result;
            block24: {
                TypeMirror basicParameterType;
                String parameterType;
                boolean typesMode;
                block28: {
                    block27: {
                        block26: {
                            block25: {
                                block23: {
                                    if (context.getMode() != WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_CLASS && context.getMode() != WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_TYPE) break block22;
                                    typesMode = context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_TYPE;
                                    parameterType = typesMode ? "routeTypes[" + context.getParameterIndex() + "]" : null;
                                    result = new StringBuilder();
                                    basicParameterType = basicParameterInfo.getType();
                                    if (basicParameterType.getKind() != TypeKind.ARRAY) break block23;
                                    if (!typesMode) {
                                        parameterType = context.getTypeName(((ArrayType)basicParameterType).getComponentType()) + ".class";
                                    }
                                    result.append(context.getOptionalTypeName()).append(".ofNullable(");
                                    result.append((CharSequence)this.visit(basicParameterInfo, context.withMode(WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_MANY))).append(")");
                                    result.append(".<").append(context.getTypeName(basicParameterType)).append(">map(parameters -> parameters.stream().flatMap(parameter -> parameter.asListOf(").append(parameterType).append(").stream())");
                                    result.append(".toArray(").append(context.getTypeName(((ArrayType)basicParameterType).getComponentType())).append("[]::new)).filter(l -> l.length > 0)");
                                    break block24;
                                }
                                if (!context.getTypeUtils().isSameType(context.getCollectionType(), context.getTypeUtils().erasure(basicParameterType))) break block25;
                                if (!typesMode) {
                                    parameterType = context.getTypeName(((DeclaredType)basicParameterType).getTypeArguments().get(0)) + ".class";
                                }
                                result.append(context.getOptionalTypeName()).append(".ofNullable(");
                                result.append((CharSequence)this.visit(basicParameterInfo, context.withMode(WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_MANY))).append(")");
                                result.append(".<").append(context.getTypeName(basicParameterType)).append(">map(parameters -> parameters.stream().flatMap(parameter -> parameter.asListOf(").append(parameterType).append(").stream())");
                                result.append(".collect(").append(context.getCollectorsTypeName()).append(".toList())).filter(l -> !l.isEmpty())");
                                break block24;
                            }
                            if (!context.getTypeUtils().isSameType(context.getListType(), context.getTypeUtils().erasure(basicParameterType))) break block26;
                            if (!typesMode) {
                                parameterType = context.getTypeName(((DeclaredType)basicParameterType).getTypeArguments().get(0)) + ".class";
                            }
                            result.append(context.getOptionalTypeName()).append(".ofNullable(");
                            result.append((CharSequence)this.visit(basicParameterInfo, context.withMode(WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_MANY))).append(")");
                            result.append(".<").append(context.getTypeName(basicParameterType)).append(">map(parameters -> parameters.stream().flatMap(parameter -> parameter.asListOf(").append(parameterType).append(").stream())");
                            result.append(".collect(").append(context.getCollectorsTypeName()).append(".toList())).filter(l -> !l.isEmpty())");
                            break block24;
                        }
                        if (!context.getTypeUtils().isSameType(context.getSetType(), context.getTypeUtils().erasure(basicParameterType))) break block27;
                        if (!typesMode) {
                            parameterType = context.getTypeName(((DeclaredType)basicParameterType).getTypeArguments().get(0)) + ".class";
                        }
                        result.append(context.getOptionalTypeName()).append(".ofNullable(");
                        result.append((CharSequence)this.visit(basicParameterInfo, context.withMode(WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_MANY))).append(")");
                        result.append(".<").append(context.getTypeName(basicParameterType)).append(">map(parameters -> parameters.stream().flatMap(parameter -> parameter.asListOf(").append(parameterType).append(").stream())");
                        result.append(".collect(").append(context.getCollectorsTypeName()).append(".toSet())).filter(l -> !l.isEmpty())");
                        break block24;
                    }
                    result.append((CharSequence)this.visit(basicParameterInfo, context.withMode(WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_ONE)));
                    result.append(".map(parameter -> parameter.");
                    if (!(basicParameterType instanceof PrimitiveType)) break block28;
                    switch (basicParameterType.getKind()) {
                        case BOOLEAN: {
                            result.append("asBoolean())");
                            break block24;
                        }
                        case BYTE: {
                            result.append("asByte())");
                            break block24;
                        }
                        case SHORT: {
                            result.append("asShort())");
                            break block24;
                        }
                        case INT: {
                            result.append("asInteger())");
                            break block24;
                        }
                        case LONG: {
                            result.append("asLong())");
                            break block24;
                        }
                        case CHAR: {
                            result.append("asCharacter())");
                            break block24;
                        }
                        case FLOAT: {
                            result.append("asFloat())");
                            break block24;
                        }
                        case DOUBLE: {
                            result.append("asDouble())");
                            break block24;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported primitive type: " + basicParameterType);
                        }
                    }
                }
                if (!typesMode) {
                    parameterType = context.getTypeName(basicParameterType) + ".class";
                } else {
                    result.append("<").append(context.getTypeName(basicParameterType)).append(">");
                }
                result.append("as(").append(parameterType).append("))");
            }
            if (basicParameterInfo.isRequired()) {
                result.append(".orElseThrow(() -> new ").append(context.getMissingRequiredParameterExceptionTypeName()).append("(\"").append(basicParameterInfo.getQualifiedName().getParameterName()).append("\"))");
            }
            return result;
        }
        if (basicParameterInfo instanceof WebCookieParameterInfo) {
            return this.visit((WebCookieParameterInfo)basicParameterInfo, context);
        }
        if (basicParameterInfo instanceof WebFormParameterInfo) {
            return this.visit((WebFormParameterInfo)basicParameterInfo, context);
        }
        if (basicParameterInfo instanceof WebHeaderParameterInfo) {
            return this.visit((WebHeaderParameterInfo)basicParameterInfo, context);
        }
        if (basicParameterInfo instanceof WebPathParameterInfo) {
            return this.visit((WebPathParameterInfo)basicParameterInfo, context);
        }
        if (basicParameterInfo instanceof WebQueryParameterInfo) {
            return this.visit((WebQueryParameterInfo)basicParameterInfo, context);
        }
        return new StringBuilder();
    }

    @Override
    public StringBuilder visit(WebCookieParameterInfo cookieParameterInfo, WebRouterConfigurerClassGenerationContext context) {
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_ONE) {
            return new StringBuilder("exchange.request().cookies().get(\"").append(cookieParameterInfo.getQualifiedName().getParameterName()).append("\")");
        }
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_MANY) {
            return new StringBuilder("exchange.request().cookies().getAll(\"").append(cookieParameterInfo.getQualifiedName().getParameterName()).append("\")");
        }
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_CLASS || context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_TYPE) {
            return this.visit((WebBasicParameterInfo)cookieParameterInfo, context);
        }
        return new StringBuilder();
    }

    @Override
    public StringBuilder visit(WebFormParameterInfo formParameterInfo, WebRouterConfigurerClassGenerationContext context) {
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_ONE) {
            return new StringBuilder(context.getOptionalTypeName()).append(".ofNullable(formParameters.get(\"").append(formParameterInfo.getQualifiedName().getParameterName()).append("\")).flatMap(parameter -> parameter.stream().findFirst())");
        }
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_MANY) {
            return new StringBuilder("formParameters.get(\"").append(formParameterInfo.getQualifiedName().getParameterName()).append("\")");
        }
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_CLASS || context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_TYPE) {
            return this.visit((WebBasicParameterInfo)formParameterInfo, context);
        }
        return new StringBuilder();
    }

    @Override
    public StringBuilder visit(WebHeaderParameterInfo headerParameterInfo, WebRouterConfigurerClassGenerationContext context) {
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_ONE) {
            return new StringBuilder("exchange.request().headers().getParameter(\"").append(headerParameterInfo.getQualifiedName().getParameterName()).append("\")");
        }
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_MANY) {
            return new StringBuilder("exchange.request().headers().getAllParameter(\"").append(headerParameterInfo.getQualifiedName().getParameterName()).append("\")");
        }
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_CLASS || context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_TYPE) {
            return this.visit((WebBasicParameterInfo)headerParameterInfo, context);
        }
        return new StringBuilder();
    }

    @Override
    public StringBuilder visit(WebPathParameterInfo pathParameterInfo, WebRouterConfigurerClassGenerationContext context) {
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_ONE) {
            return new StringBuilder("exchange.request().pathParameters().get(\"").append(pathParameterInfo.getQualifiedName().getParameterName()).append("\")");
        }
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_MANY) {
            return new StringBuilder("exchange.request().pathParameters().get(\"").append(pathParameterInfo.getQualifiedName().getParameterName()).append("\").map(parameter -> ").append(context.getListTypeName()).append(".of(parameter)).orElse(").append(context.getListTypeName()).append(".of())");
        }
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_CLASS || context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_TYPE) {
            return this.visit((WebBasicParameterInfo)pathParameterInfo, context);
        }
        return new StringBuilder();
    }

    @Override
    public StringBuilder visit(WebQueryParameterInfo queryParameterInfo, WebRouterConfigurerClassGenerationContext context) {
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_ONE) {
            return new StringBuilder("exchange.request().queryParameters().get(\"").append(queryParameterInfo.getQualifiedName().getParameterName()).append("\")");
        }
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_MANY) {
            return new StringBuilder("exchange.request().queryParameters().getAll(\"").append(queryParameterInfo.getQualifiedName().getParameterName()).append("\")");
        }
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_CLASS || context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_TYPE) {
            return this.visit((WebBasicParameterInfo)queryParameterInfo, context);
        }
        return new StringBuilder();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public StringBuilder visit(WebRequestBodyParameterInfo bodyParameterInfo, WebRouterConfigurerClassGenerationContext context) {
        if (context.getMode() != WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_CLASS && context.getMode() != WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_TYPE) return new StringBuilder();
        boolean typesMode = context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_TYPE;
        String parameterType = typesMode ? "routeTypes[" + context.getParameterIndex() + "]" : null;
        StringBuilder result = new StringBuilder();
        TypeMirror bodyParameterType = bodyParameterInfo.getType();
        if (bodyParameterInfo.getBodyReactiveKind() == WebRequestBodyParameterInfo.RequestBodyReactiveKind.NONE) {
            if (bodyParameterInfo.getBodyKind() == WebRequestBodyParameterInfo.RequestBodyKind.RAW) {
                result.append(context.getFluxTypeName()).append(".from(exchange.request().body().get().raw().stream()).reduceWith(() -> ").append(context.getUnpooledTypeName()).append(".unreleasableBuffer(").append(context.getUnpooledTypeName()).append(".buffer()), (acc, chunk) -> { try { return acc.writeBytes(chunk); } finally { chunk.release(); } })");
                return result;
            } else {
                if (bodyParameterInfo.getBodyKind() != WebRequestBodyParameterInfo.RequestBodyKind.ENCODED) throw new IllegalStateException("Can't generate non-reactive body parameter of kind: " + bodyParameterInfo.getBodyKind());
                result.append("exchange.request().body().get().");
                if (!typesMode) {
                    parameterType = context.getTypeName(bodyParameterType) + ".class";
                } else {
                    result.append("<").append(context.getTypeName(bodyParameterType)).append(">");
                }
                result.append("decoder(").append(parameterType).append(").one()");
            }
            return result;
        } else {
            result.append("exchange.request().body().get().");
            if (bodyParameterInfo.getBodyKind() == WebRequestBodyParameterInfo.RequestBodyKind.ENCODED) {
                if (!typesMode) {
                    parameterType = context.getTypeName(bodyParameterInfo.getType()) + ".class";
                } else {
                    result.append("<").append(context.getTypeName(bodyParameterType)).append(">");
                }
                result.append("decoder(").append(parameterType).append(")");
                if (bodyParameterInfo.getBodyReactiveKind() == WebRequestBodyParameterInfo.RequestBodyReactiveKind.ONE) {
                    result.append(".one()");
                    return result;
                } else {
                    if (bodyParameterInfo.getBodyReactiveKind() != WebRequestBodyParameterInfo.RequestBodyReactiveKind.PUBLISHER && bodyParameterInfo.getBodyReactiveKind() != WebRequestBodyParameterInfo.RequestBodyReactiveKind.MANY) throw new IllegalStateException("Unknown request body reactive kind: " + bodyParameterInfo.getBodyReactiveKind());
                    result.append(".many()");
                }
                return result;
            } else {
                if (bodyParameterInfo.getBodyKind() == WebRequestBodyParameterInfo.RequestBodyKind.RAW) {
                    result.append("raw().stream()");
                } else if (bodyParameterInfo.getBodyKind() == WebRequestBodyParameterInfo.RequestBodyKind.MULTIPART) {
                    result.append("multipart().stream()");
                } else {
                    if (bodyParameterInfo.getBodyKind() != WebRequestBodyParameterInfo.RequestBodyKind.URLENCODED) throw new IllegalStateException("Unknown request body kind: " + bodyParameterInfo.getBodyKind());
                    result.append("urlEncoded().stream()");
                }
                if (bodyParameterInfo.getBodyReactiveKind() == WebRequestBodyParameterInfo.RequestBodyReactiveKind.ONE) {
                    result.insert(0, ".from(").insert(0, context.getMonoTypeName()).append(")");
                    return result;
                } else {
                    if (bodyParameterInfo.getBodyReactiveKind() != WebRequestBodyParameterInfo.RequestBodyReactiveKind.MANY && bodyParameterInfo.getBodyReactiveKind() != WebRequestBodyParameterInfo.RequestBodyReactiveKind.PUBLISHER) throw new IllegalStateException("Unknown request body reactive kind: " + bodyParameterInfo.getBodyReactiveKind());
                    result.insert(0, ".from(").insert(0, context.getFluxTypeName()).append(")");
                }
            }
        }
        return result;
    }

    @Override
    public StringBuilder visit(WebExchangeParameterInfo exchangeParameterInfo, WebRouterConfigurerClassGenerationContext context) {
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_CLASS || context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_TYPE) {
            return new StringBuilder("exchange");
        }
        return new StringBuilder();
    }

    @Override
    public StringBuilder visit(WebSseEventFactoryParameterInfo sseEventFactoryParameterInfo, WebRouterConfigurerClassGenerationContext context) {
        if (context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_CLASS || context.getMode() == WebRouterConfigurerClassGenerationContext.GenerationMode.ROUTE_PARAMETER_REFERENCE_TYPE) {
            return new StringBuilder("events");
        }
        return new StringBuilder();
    }
}

