/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.web.compiler.internal;

import io.inverno.core.compiler.spi.ModuleQualifiedName;
import io.inverno.core.compiler.spi.support.AbstractSourceGenerationContext;
import io.inverno.mod.http.base.Method;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.web.MissingRequiredParameterException;
import io.inverno.mod.web.WebExchange;
import io.inverno.mod.web.annotation.WebRoute;
import io.inverno.mod.web.compiler.spi.WebControllerInfo;
import io.inverno.mod.web.compiler.spi.WebExchangeParameterInfo;
import io.inverno.mod.web.compiler.spi.WebRequestBodyParameterInfo;
import io.inverno.mod.web.compiler.spi.WebRouteInfo;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class WebRouterConfigurerClassGenerationContext
extends AbstractSourceGenerationContext<WebRouterConfigurerClassGenerationContext, GenerationMode> {
    private TypeGenerator typeGenerator;
    private WebControllerInfo webController;
    private WebRouteInfo webRoute;
    private Integer parameterIndex;
    private TypeMirror collectionType;
    private TypeMirror listType;
    private TypeMirror setType;
    private TypeMirror optionalType;
    private TypeMirror collectorsType;
    private TypeMirror webRouteAnnotationType;
    private TypeMirror webExchangeType;
    private TypeMirror methodType;
    private TypeMirror missingRequiredParameterExceptionType;
    private TypeMirror publisherType;
    private TypeMirror monoType;
    private TypeMirror fluxType;
    private TypeMirror parameterType;
    private TypeMirror unpooledType;
    private TypeMirror typeType;
    private TypeMirror typesType;
    private TypeMirror voidType;
    private TypeMirror byteBufType;

    public WebRouterConfigurerClassGenerationContext(Types typeUtils, Elements elementUtils, GenerationMode mode) {
        super(typeUtils, elementUtils, (Enum)mode);
        this.typeGenerator = new TypeGenerator();
        this.collectionType = typeUtils.erasure(elementUtils.getTypeElement(Collection.class.getCanonicalName()).asType());
        this.listType = typeUtils.erasure(elementUtils.getTypeElement(List.class.getCanonicalName()).asType());
        this.setType = typeUtils.erasure(elementUtils.getTypeElement(Set.class.getCanonicalName()).asType());
        this.optionalType = typeUtils.erasure(elementUtils.getTypeElement(Optional.class.getCanonicalName()).asType());
        this.collectorsType = elementUtils.getTypeElement(Collectors.class.getCanonicalName()).asType();
        this.webRouteAnnotationType = elementUtils.getTypeElement(WebRoute.class.getCanonicalName()).asType();
        this.webExchangeType = elementUtils.getTypeElement(WebExchange.class.getCanonicalName()).asType();
        this.methodType = elementUtils.getTypeElement(Method.class.getCanonicalName()).asType();
        this.missingRequiredParameterExceptionType = elementUtils.getTypeElement(MissingRequiredParameterException.class.getCanonicalName()).asType();
        this.publisherType = typeUtils.erasure(elementUtils.getTypeElement(Publisher.class.getCanonicalName()).asType());
        this.monoType = typeUtils.erasure(elementUtils.getTypeElement(Mono.class.getCanonicalName()).asType());
        this.fluxType = typeUtils.erasure(elementUtils.getTypeElement(Flux.class.getCanonicalName()).asType());
        this.parameterType = elementUtils.getTypeElement(Parameter.class.getCanonicalName()).asType();
        this.unpooledType = elementUtils.getTypeElement(Unpooled.class.getCanonicalName()).asType();
        this.typeType = elementUtils.getTypeElement(Type.class.getCanonicalName()).asType();
        this.typesType = elementUtils.getTypeElement(io.inverno.mod.base.reflect.Types.class.getCanonicalName()).asType();
        this.voidType = elementUtils.getTypeElement(Void.class.getCanonicalName()).asType();
        this.byteBufType = elementUtils.getTypeElement(ByteBuf.class.getCanonicalName()).asType();
    }

    private WebRouterConfigurerClassGenerationContext(WebRouterConfigurerClassGenerationContext parentGeneration) {
        super((AbstractSourceGenerationContext)parentGeneration);
        this.typeGenerator = parentGeneration.typeGenerator;
        this.webController = parentGeneration.webController;
        this.webRoute = parentGeneration.webRoute;
        this.parameterIndex = parentGeneration.parameterIndex;
    }

    public WebRouterConfigurerClassGenerationContext withMode(GenerationMode mode) {
        WebRouterConfigurerClassGenerationContext context = new WebRouterConfigurerClassGenerationContext(this);
        context.mode = mode;
        return context;
    }

    public WebRouterConfigurerClassGenerationContext withIndentDepth(int indentDepth) {
        WebRouterConfigurerClassGenerationContext context = new WebRouterConfigurerClassGenerationContext(this);
        context.indentDepth = indentDepth;
        return context;
    }

    public WebRouterConfigurerClassGenerationContext withModule(ModuleQualifiedName moduleQualifiedName) {
        WebRouterConfigurerClassGenerationContext context = new WebRouterConfigurerClassGenerationContext(this);
        context.moduleQualifiedName = moduleQualifiedName;
        return context;
    }

    public WebRouterConfigurerClassGenerationContext withWebController(WebControllerInfo webController) {
        WebRouterConfigurerClassGenerationContext context = new WebRouterConfigurerClassGenerationContext(this);
        context.webController = webController;
        return context;
    }

    public WebRouterConfigurerClassGenerationContext withWebRoute(WebRouteInfo webRoute) {
        WebRouterConfigurerClassGenerationContext context = new WebRouterConfigurerClassGenerationContext(this);
        context.webRoute = webRoute;
        return context;
    }

    public WebRouterConfigurerClassGenerationContext withParameterIndex(int parameterIndex) {
        WebRouterConfigurerClassGenerationContext context = new WebRouterConfigurerClassGenerationContext(this);
        context.parameterIndex = parameterIndex;
        return context;
    }

    public WebControllerInfo getWebController() {
        return this.webController;
    }

    public WebRouteInfo getWebRoute() {
        return this.webRoute;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public TypeMirror getParameterConverterType(TypeMirror type) {
        if (this.isArrayType(type)) {
            return ((ArrayType)type).getComponentType();
        }
        if (this.isCollectionType(type)) {
            return ((DeclaredType)type).getTypeArguments().get(0);
        }
        return type;
    }

    public boolean isArrayType(TypeMirror type) {
        return type.getKind() == TypeKind.ARRAY;
    }

    public boolean isCollectionType(TypeMirror type) {
        if (type.getKind() == TypeKind.VOID) {
            return false;
        }
        TypeMirror erasedType = this.typeUtils.erasure(type);
        return this.typeUtils.isSameType(erasedType, this.getCollectionType()) || this.typeUtils.isSameType(erasedType, this.getListType()) || this.typeUtils.isSameType(erasedType, this.getSetType());
    }

    public boolean isReactiveType(TypeMirror type) {
        if (type.getKind() == TypeKind.VOID) {
            return false;
        }
        TypeMirror erasedType = this.typeUtils.erasure(type);
        return this.typeUtils.isSameType(erasedType, this.getPublisherType()) || this.typeUtils.isSameType(erasedType, this.getMonoType()) || this.typeUtils.isSameType(erasedType, this.getFluxType());
    }

    public boolean isTypeMode(WebRouteInfo routeInfo) {
        if (routeInfo.getResponseBody().getType().getKind() != TypeKind.VOID && !this.isClassType(routeInfo.getResponseBody().getType())) {
            return true;
        }
        return Arrays.stream(routeInfo.getParameters()).filter(parameter -> !(parameter instanceof WebExchangeParameterInfo)).anyMatch(parameter -> {
            if (parameter instanceof WebRequestBodyParameterInfo) {
                return !this.isClassType(parameter.getType());
            }
            return !this.isClassType(this.getParameterConverterType(parameter.getType()));
        });
    }

    public boolean isClassType(TypeMirror type) {
        if (type.getKind() == TypeKind.ARRAY) {
            return false;
        }
        if (type.getKind() == TypeKind.DECLARED) {
            return ((DeclaredType)type).getTypeArguments().size() == 0;
        }
        return true;
    }

    public TypeMirror getCollectionType() {
        return this.collectionType != null ? this.collectionType : ((WebRouterConfigurerClassGenerationContext)this.parentGeneration).getCollectionType();
    }

    public String getCollectionTypeName() {
        return this.getTypeName(this.getCollectionType());
    }

    public TypeMirror getListType() {
        return this.listType != null ? this.listType : ((WebRouterConfigurerClassGenerationContext)this.parentGeneration).getListType();
    }

    public String getListTypeName() {
        return this.getTypeName(this.getListType());
    }

    public TypeMirror getSetType() {
        return this.setType != null ? this.setType : ((WebRouterConfigurerClassGenerationContext)this.parentGeneration).getSetType();
    }

    public String getSetTypeName() {
        return this.getTypeName(this.getSetType());
    }

    public TypeMirror getOptionalType() {
        return this.optionalType != null ? this.optionalType : ((WebRouterConfigurerClassGenerationContext)this.parentGeneration).getOptionalType();
    }

    public String getOptionalTypeName() {
        return this.getTypeName(this.getOptionalType());
    }

    public TypeMirror getCollectorsType() {
        return this.collectorsType != null ? this.collectorsType : ((WebRouterConfigurerClassGenerationContext)this.parentGeneration).getCollectorsType();
    }

    public String getCollectorsTypeName() {
        return this.getTypeName(this.getCollectorsType());
    }

    public TypeMirror getWebRouteAnnotationType() {
        return this.webRouteAnnotationType != null ? this.webRouteAnnotationType : ((WebRouterConfigurerClassGenerationContext)this.parentGeneration).getWebRouteAnnotationType();
    }

    public String getWebRouteAnnotationTypeName() {
        return this.getTypeName(this.getWebRouteAnnotationType());
    }

    public TypeMirror getWebExchangeType() {
        return this.webExchangeType != null ? this.webExchangeType : ((WebRouterConfigurerClassGenerationContext)this.parentGeneration).getWebExchangeType();
    }

    public String getWebExchangeTypeName() {
        return this.getTypeName(this.getWebExchangeType());
    }

    public TypeMirror getMethodType() {
        return this.methodType != null ? this.methodType : ((WebRouterConfigurerClassGenerationContext)this.parentGeneration).getMethodType();
    }

    public String getMethodTypeName() {
        return this.getTypeName(this.getMethodType());
    }

    public TypeMirror getMissingRequiredParameterExceptionType() {
        return this.missingRequiredParameterExceptionType != null ? this.missingRequiredParameterExceptionType : ((WebRouterConfigurerClassGenerationContext)this.parentGeneration).getMissingRequiredParameterExceptionType();
    }

    public String getMissingRequiredParameterExceptionTypeName() {
        return this.getTypeName(this.getMissingRequiredParameterExceptionType());
    }

    public TypeMirror getPublisherType() {
        return this.publisherType != null ? this.publisherType : ((WebRouterConfigurerClassGenerationContext)this.parentGeneration).getPublisherType();
    }

    public String getPublisherTypeName() {
        return this.getTypeName(this.getPublisherType());
    }

    public TypeMirror getMonoType() {
        return this.monoType != null ? this.monoType : ((WebRouterConfigurerClassGenerationContext)this.parentGeneration).getMonoType();
    }

    public String getMonoTypeName() {
        return this.getTypeName(this.getMonoType());
    }

    public TypeMirror getFluxType() {
        return this.fluxType != null ? this.fluxType : ((WebRouterConfigurerClassGenerationContext)this.parentGeneration).getFluxType();
    }

    public String getFluxTypeName() {
        return this.getTypeName(this.getFluxType());
    }

    public TypeMirror getParameterType() {
        return this.parameterType != null ? this.parameterType : ((WebRouterConfigurerClassGenerationContext)this.parentGeneration).getParameterType();
    }

    public String getParameterTypeName() {
        return this.getTypeName(this.getParameterType());
    }

    public TypeMirror getUnpooledType() {
        return this.unpooledType != null ? this.unpooledType : ((WebRouterConfigurerClassGenerationContext)this.parentGeneration).getUnpooledType();
    }

    public String getUnpooledTypeName() {
        return this.getTypeName(this.getUnpooledType());
    }

    public TypeMirror getTypeType() {
        return this.typeType != null ? this.typeType : ((WebRouterConfigurerClassGenerationContext)this.parentGeneration).getTypeType();
    }

    public String getTypeTypeName() {
        return this.getTypeName(this.getTypeType());
    }

    public TypeMirror getTypesType() {
        return this.typesType != null ? this.typesType : ((WebRouterConfigurerClassGenerationContext)this.parentGeneration).getTypesType();
    }

    public String getTypesTypeName() {
        return this.getTypeName(this.getTypesType());
    }

    public TypeMirror getVoidType() {
        return this.voidType != null ? this.voidType : ((WebRouterConfigurerClassGenerationContext)this.parentGeneration).getVoidType();
    }

    public String getVoidTypeName() {
        return this.getTypeName(this.getVoidType());
    }

    public TypeMirror getByteBufType() {
        return this.byteBufType != null ? this.byteBufType : ((WebRouterConfigurerClassGenerationContext)this.parentGeneration).getByteBufType();
    }

    public String getByteBufTypeName() {
        return this.getTypeName(this.getByteBufType());
    }

    public StringBuilder getTypeGenerator(TypeMirror type) {
        return (StringBuilder)this.typeGenerator.visit(type);
    }

    private class TypeGenerator
    implements TypeVisitor<StringBuilder, TypeGenerationKind> {
        private TypeGenerator() {
        }

        @Override
        public StringBuilder visit(TypeMirror type, TypeGenerationKind kind) {
            Objects.requireNonNull(type, "type");
            if (type instanceof PrimitiveType) {
                return this.visitPrimitive((PrimitiveType)type, kind);
            }
            if (type instanceof ArrayType) {
                return this.visitArray((ArrayType)type, kind);
            }
            if (type instanceof DeclaredType) {
                return this.visitDeclared((DeclaredType)type, kind);
            }
            if (type instanceof WildcardType) {
                return this.visitWildcard((WildcardType)type, kind);
            }
            if (type instanceof ExecutableType) {
                return this.visitExecutable((ExecutableType)type, kind);
            }
            if (type instanceof NoType) {
                return this.visitNoType((NoType)type, kind);
            }
            if (type instanceof IntersectionType) {
                return this.visitIntersection((IntersectionType)type, kind);
            }
            throw new IllegalStateException();
        }

        @Override
        public StringBuilder visitPrimitive(PrimitiveType type, TypeGenerationKind kind) {
            if (kind == null) {
                return new StringBuilder(WebRouterConfigurerClassGenerationContext.this.getTypesTypeName()).append(".type(").append(WebRouterConfigurerClassGenerationContext.this.getTypeName(type)).append(".class).build()");
            }
            StringBuilder result = new StringBuilder();
            if (kind == TypeGenerationKind.PARAMETERIZED) {
                result.append(".type(");
            } else if (kind == TypeGenerationKind.UPPERBOUND) {
                result.append(".upperBoundType(");
            } else if (kind == TypeGenerationKind.LOWERBOUND) {
                result.append(".lowerBoundType(");
            } else if (kind == TypeGenerationKind.COMPONENT) {
                result.append(".componentType(");
            } else {
                throw new IllegalStateException("A primitive type can't appear as a " + kind + " type");
            }
            result.append(WebRouterConfigurerClassGenerationContext.this.getTypeName(WebRouterConfigurerClassGenerationContext.this.typeUtils.boxedClass(type).asType())).append(".class).and()");
            return result;
        }

        @Override
        public StringBuilder visitNull(NullType type, TypeGenerationKind kind) {
            throw new IllegalStateException(type.getKind() + " can't be converted to a viable Type");
        }

        @Override
        public StringBuilder visitArray(ArrayType type, TypeGenerationKind kind) {
            if (kind == null) {
                return new StringBuilder(WebRouterConfigurerClassGenerationContext.this.getTypesTypeName()).append(".arrayType()").append((CharSequence)this.visit(type.getComponentType(), TypeGenerationKind.COMPONENT)).append(".build()");
            }
            StringBuilder result = new StringBuilder();
            if (kind == TypeGenerationKind.PARAMETERIZED) {
                result.append(".arrayType()");
            } else if (kind == TypeGenerationKind.UPPERBOUND) {
                result.append(".upperBoundArrayType()");
            } else if (kind == TypeGenerationKind.LOWERBOUND) {
                result.append(".lowerBoundArrayType()");
            } else if (kind == TypeGenerationKind.COMPONENT) {
                result.append(".componentArrayType()");
            } else {
                throw new IllegalStateException("An array type can't appear as a " + kind + " type");
            }
            result.append((CharSequence)this.visit(type.getComponentType(), TypeGenerationKind.COMPONENT)).append(".and()");
            return result;
        }

        @Override
        public StringBuilder visitDeclared(DeclaredType type, TypeGenerationKind kind) {
            if (kind == null) {
                StringBuilder result = new StringBuilder(WebRouterConfigurerClassGenerationContext.this.getTypesTypeName()).append(".type(").append(WebRouterConfigurerClassGenerationContext.this.getTypeName(WebRouterConfigurerClassGenerationContext.this.typeUtils.erasure(type))).append(".class)");
                if (type.getEnclosingType() instanceof DeclaredType) {
                    result.append((CharSequence)this.visit(type.getEnclosingType(), TypeGenerationKind.OWNER));
                }
                for (TypeMirror typeMirror : type.getTypeArguments()) {
                    result.append((CharSequence)this.visit(typeMirror, TypeGenerationKind.PARAMETERIZED));
                }
                result.append(".build()");
                return result;
            }
            StringBuilder result = new StringBuilder();
            if (kind == TypeGenerationKind.PARAMETERIZED) {
                result.append(".type(");
            } else if (kind == TypeGenerationKind.UPPERBOUND) {
                result.append(".upperBoundType(");
            } else if (kind == TypeGenerationKind.LOWERBOUND) {
                result.append(".lowerBoundType(");
            } else if (kind == TypeGenerationKind.COMPONENT) {
                result.append(".componentType(");
            } else {
                throw new IllegalStateException("A declared type can't appear as a " + kind + " type");
            }
            result.append(WebRouterConfigurerClassGenerationContext.this.getTypeName(WebRouterConfigurerClassGenerationContext.this.typeUtils.erasure(type))).append(".class)");
            if (type.getEnclosingType() instanceof DeclaredType) {
                result.append((CharSequence)this.visit(type.getEnclosingType(), TypeGenerationKind.OWNER));
            }
            for (TypeMirror typeMirror : type.getTypeArguments()) {
                result.append((CharSequence)this.visit(typeMirror, TypeGenerationKind.PARAMETERIZED));
            }
            result.append(".and()");
            return result;
        }

        @Override
        public StringBuilder visitError(ErrorType type, TypeGenerationKind kind) {
            throw new IllegalStateException(type.getKind() + " can't be converted to a viable Type");
        }

        @Override
        public StringBuilder visitTypeVariable(TypeVariable type, TypeGenerationKind kind) {
            throw new IllegalStateException(type.getKind() + " can't be converted to a viable Type");
        }

        @Override
        public StringBuilder visitWildcard(WildcardType type, TypeGenerationKind kind) {
            if (kind == null) {
                throw new IllegalStateException("WildcardType can't exist on its own");
            }
            StringBuilder result = new StringBuilder();
            if (kind != TypeGenerationKind.PARAMETERIZED) {
                throw new IllegalStateException("A wildcard type can't appear as a " + kind + " type");
            }
            result.append(".wildcardType()");
            if (type.getExtendsBound() != null) {
                result.append((CharSequence)this.visit(type.getExtendsBound(), TypeGenerationKind.UPPERBOUND));
            } else if (type.getSuperBound() != null) {
                result.append((CharSequence)this.visit(type.getSuperBound(), TypeGenerationKind.LOWERBOUND));
            }
            result.append(".and()");
            return result;
        }

        @Override
        public StringBuilder visitExecutable(ExecutableType type, TypeGenerationKind kind) {
            if (kind == null) {
                throw new IllegalStateException("ExecutableType can't appear as a " + kind + " type");
            }
            return (StringBuilder)this.visit(type.getReturnType());
        }

        @Override
        public StringBuilder visitNoType(NoType type, TypeGenerationKind kind) {
            if (type.getKind() != TypeKind.VOID) {
                throw new IllegalStateException(type.getKind() + " can't be converted to a viable Type");
            }
            if (kind == null) {
                return new StringBuilder(WebRouterConfigurerClassGenerationContext.this.getTypesTypeName()).append(".type(").append(WebRouterConfigurerClassGenerationContext.this.getVoidTypeName()).append(".class).build()");
            }
            StringBuilder result = new StringBuilder();
            if (kind == TypeGenerationKind.PARAMETERIZED) {
                result.append(".type(");
            } else if (kind == TypeGenerationKind.UPPERBOUND) {
                result.append(".upperBoundType(");
            } else if (kind == TypeGenerationKind.LOWERBOUND) {
                result.append(".lowerBoundType(");
            } else if (kind == TypeGenerationKind.COMPONENT) {
                result.append(".componentType(");
            } else {
                throw new IllegalStateException("Void type can't appear as a " + kind + " type");
            }
            result.append(WebRouterConfigurerClassGenerationContext.this.getVoidTypeName()).append(".class).build()");
            return result;
        }

        @Override
        public StringBuilder visitUnknown(TypeMirror type, TypeGenerationKind kind) {
            throw new IllegalStateException(type.getKind() + " can't be converted to a viable Type");
        }

        @Override
        public StringBuilder visitUnion(UnionType type, TypeGenerationKind kind) {
            throw new IllegalStateException(type.getKind() + " can't be converted to a viable Type");
        }

        @Override
        public StringBuilder visitIntersection(IntersectionType type, TypeGenerationKind kind) {
            if (kind == null) {
                throw new IllegalStateException("IntersectionType can't exist on its own");
            }
            StringBuilder result = new StringBuilder();
            if (kind != TypeGenerationKind.UPPERBOUND && kind != TypeGenerationKind.LOWERBOUND) {
                throw new IllegalStateException("A wildcard type can't appear as a " + kind + " type");
            }
            for (TypeMirror typeMirror : type.getBounds()) {
                result.append((CharSequence)this.visit(typeMirror, kind));
            }
            return result;
        }
    }

    public static enum GenerationMode {
        CONFIGURER_CLASS,
        CONFIGURER_ANNOTATION,
        CONFIGURER_FIELD,
        CONFIGURER_PARAMETER,
        CONFIGURER_ASSIGNMENT,
        CONFIGURER_INVOKE,
        CONTROLLER_FIELD,
        CONTROLLER_PARAMETER,
        CONTROLLER_ASSIGNMENT,
        ROUTE_ANNOTATION,
        ROUTE_DECLARATION,
        ROUTE_HANDLER_BODY_CLASS,
        ROUTE_HANDLER_BODY_TYPE,
        ROUTE_PARAMETER_REFERENCE_CLASS,
        ROUTE_PARAMETER_REFERENCE_TYPE,
        ROUTE_PARAMETER_REFERENCE_ONE,
        ROUTE_PARAMETER_REFERENCE_MANY;

    }

    private static enum TypeGenerationKind {
        PARAMETERIZED,
        UPPERBOUND,
        LOWERBOUND,
        COMPONENT,
        OWNER;

    }
}

