/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.web.compiler.internal;

import io.inverno.core.compiler.spi.BeanInfo;
import io.inverno.core.compiler.spi.BeanQualifiedName;
import io.inverno.core.compiler.spi.ReporterInfo;
import io.inverno.core.compiler.spi.plugin.PluginContext;
import io.inverno.core.compiler.spi.plugin.PluginExecution;
import io.inverno.mod.base.resource.Resource;
import io.inverno.mod.http.base.Method;
import io.inverno.mod.http.server.ResponseBody;
import io.inverno.mod.web.WebResponseBody;
import io.inverno.mod.web.annotation.WebController;
import io.inverno.mod.web.annotation.WebRoute;
import io.inverno.mod.web.annotation.WebRoutes;
import io.inverno.mod.web.compiler.internal.AbstractWebParameterInfo;
import io.inverno.mod.web.compiler.internal.GenericWebResponseBodyInfo;
import io.inverno.mod.web.compiler.internal.GenericWebRouteInfo;
import io.inverno.mod.web.compiler.internal.NoOpReporterInfo;
import io.inverno.mod.web.compiler.internal.ProvidedWebRouteInfo;
import io.inverno.mod.web.compiler.internal.TypeHierarchyExtractor;
import io.inverno.mod.web.compiler.internal.WebParameterInfoFactory;
import io.inverno.mod.web.compiler.spi.WebFormParameterInfo;
import io.inverno.mod.web.compiler.spi.WebRequestBodyParameterInfo;
import io.inverno.mod.web.compiler.spi.WebResponseBodyInfo;
import io.inverno.mod.web.compiler.spi.WebRouteQualifiedName;
import io.inverno.mod.web.compiler.spi.WebSseEventFactoryParameterInfo;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class WebRouteInfoFactory {
    private final PluginContext pluginContext;
    private final PluginExecution pluginExecution;
    private final WebParameterInfoFactory parameterFactory;
    private final Map<ExecutableElement, GenericWebRouteInfo> routes;
    private final TypeHierarchyExtractor typeHierarchyExtractor;
    private final TypeMirror webControllerAnnotationType;
    private final TypeMirror webRoutesAnnotationType;
    private final TypeMirror webRouteAnnotationType;
    private final TypeMirror publisherType;
    private final TypeMirror monoType;
    private final TypeMirror fluxType;
    private final TypeMirror voidType;
    private final TypeMirror byteBufType;
    private final TypeMirror charSequenceType;
    private final TypeMirror sseRawEventType;
    private final TypeMirror sseEncoderEventType;
    private final TypeMirror resourceType;

    public WebRouteInfoFactory(PluginContext pluginContext, PluginExecution pluginExecution) {
        this.pluginContext = Objects.requireNonNull(pluginContext);
        this.pluginExecution = Objects.requireNonNull(pluginExecution);
        this.parameterFactory = new WebParameterInfoFactory(this.pluginContext, this.pluginExecution);
        this.routes = new HashMap<ExecutableElement, GenericWebRouteInfo>();
        this.typeHierarchyExtractor = new TypeHierarchyExtractor(this.pluginContext.getTypeUtils());
        this.webControllerAnnotationType = this.pluginContext.getElementUtils().getTypeElement(WebController.class.getCanonicalName()).asType();
        this.webRoutesAnnotationType = this.pluginContext.getElementUtils().getTypeElement(WebRoutes.class.getCanonicalName()).asType();
        this.webRouteAnnotationType = this.pluginContext.getElementUtils().getTypeElement(WebRoute.class.getCanonicalName()).asType();
        this.publisherType = this.pluginContext.getTypeUtils().erasure(this.pluginContext.getElementUtils().getTypeElement(Publisher.class.getCanonicalName()).asType());
        this.monoType = this.pluginContext.getTypeUtils().erasure(this.pluginContext.getElementUtils().getTypeElement(Mono.class.getCanonicalName()).asType());
        this.fluxType = this.pluginContext.getTypeUtils().erasure(this.pluginContext.getElementUtils().getTypeElement(Flux.class.getCanonicalName()).asType());
        this.voidType = this.pluginContext.getElementUtils().getTypeElement(Void.class.getCanonicalName()).asType();
        this.byteBufType = this.pluginContext.getElementUtils().getTypeElement(ByteBuf.class.getCanonicalName()).asType();
        this.charSequenceType = this.pluginContext.getElementUtils().getTypeElement(CharSequence.class.getCanonicalName()).asType();
        this.sseRawEventType = this.pluginContext.getTypeUtils().erasure(this.pluginContext.getElementUtils().getTypeElement(ResponseBody.Sse.Event.class.getCanonicalName()).asType());
        this.sseEncoderEventType = this.pluginContext.getTypeUtils().erasure(this.pluginContext.getElementUtils().getTypeElement(WebResponseBody.SseEncoder.Event.class.getCanonicalName()).asType());
        this.resourceType = this.pluginContext.getElementUtils().getTypeElement(Resource.class.getCanonicalName()).asType();
    }

    public Optional<GenericWebRouteInfo> compileRoute(ExecutableElement routeElement) {
        AnnotationMirror webRouteAnnotation = null;
        for (AnnotationMirror annotationMirror : this.pluginContext.getElementUtils().getAllAnnotationMirrors(routeElement)) {
            if (!this.pluginContext.getTypeUtils().isSameType(annotationMirror.getAnnotationType(), this.webRouteAnnotationType)) continue;
            webRouteAnnotation = annotationMirror;
            break;
        }
        if (webRouteAnnotation == null) {
            return Optional.empty();
        }
        GenericWebRouteInfo routeInfo = this.routes.get(routeElement);
        if (routeInfo != null) {
            return Optional.of(routeInfo);
        }
        return Optional.ofNullable(this.createRoute(webRouteAnnotation, null, routeElement, routeElement, (ExecutableType)routeElement.asType(), null));
    }

    /*
     * Enabled aggressive block sorting
     */
    private GenericWebRouteInfo createRoute(AnnotationMirror webRouteAnnotation, BeanQualifiedName controllerQName, ExecutableElement routeElement, ExecutableElement routeAnnotatedElement, ExecutableType routeType, Integer discriminator) {
        ArrayList<AbstractWebParameterInfo> parameters;
        GenericWebResponseBodyInfo responseBodyInfo;
        WebRouteQualifiedName routeQName;
        HashSet<String> languages;
        HashSet<String> produces;
        HashSet<String> consumes;
        HashSet<Method> methods;
        boolean matchTrailingSlash;
        HashSet<String> paths;
        ReporterInfo routeReporter;
        block56: {
            block54: {
                WebSseEventFactoryParameterInfo sseFactoryParameter;
                block57: {
                    block55: {
                        WebResponseBodyInfo.ResponseBodyKind responseBodyKind;
                        WebResponseBodyInfo.ResponseBodyReactiveKind responseBodyReactiveKind;
                        TypeMirror responseBodyType;
                        block48: {
                            block49: {
                                block53: {
                                    block52: {
                                        block51: {
                                            block50: {
                                                routeReporter = this.routes.containsKey(routeElement) ? new NoOpReporterInfo((ReporterInfo)this.routes.get(routeElement)) : (routeElement == routeAnnotatedElement ? this.pluginExecution.getReporter((Element)routeElement, webRouteAnnotation) : this.pluginExecution.getReporter((Element)routeElement));
                                                paths = new HashSet<String>();
                                                matchTrailingSlash = false;
                                                methods = new HashSet<Method>();
                                                consumes = new HashSet<String>();
                                                produces = new HashSet<String>();
                                                languages = new HashSet<String>();
                                                block18: for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> value : this.pluginContext.getElementUtils().getElementValuesWithDefaults(webRouteAnnotation).entrySet()) {
                                                    switch (value.getKey().getSimpleName().toString()) {
                                                        case "value": {
                                                            paths.addAll(((List)value.getValue().getValue()).stream().map(v -> v.getValue().toString()).collect(Collectors.toSet()));
                                                            break block18;
                                                        }
                                                        case "path": {
                                                            paths.addAll(((List)value.getValue().getValue()).stream().map(v -> v.getValue().toString()).collect(Collectors.toSet()));
                                                            break;
                                                        }
                                                        case "matchTrailingSlash": {
                                                            matchTrailingSlash = (Boolean)value.getValue().getValue();
                                                            break;
                                                        }
                                                        case "method": {
                                                            methods.addAll(((List)value.getValue().getValue()).stream().map(v -> Method.valueOf((String)v.getValue().toString())).collect(Collectors.toSet()));
                                                            break;
                                                        }
                                                        case "consumes": {
                                                            consumes.addAll(((List)value.getValue().getValue()).stream().map(v -> v.getValue().toString()).collect(Collectors.toSet()));
                                                            break;
                                                        }
                                                        case "produces": {
                                                            produces.addAll(((List)value.getValue().getValue()).stream().map(v -> v.getValue().toString()).collect(Collectors.toSet()));
                                                            break;
                                                        }
                                                        case "language": {
                                                            languages.addAll(((List)value.getValue().getValue()).stream().map(v -> v.getValue().toString()).collect(Collectors.toSet()));
                                                        }
                                                    }
                                                }
                                                Object routeName = routeElement.getSimpleName().toString();
                                                if (discriminator != null) {
                                                    routeName = (String)routeName + "_" + discriminator;
                                                }
                                                routeQName = controllerQName != null ? new WebRouteQualifiedName(controllerQName, (String)routeName) : new WebRouteQualifiedName((String)routeName);
                                                responseBodyType = routeElement.getReturnType();
                                                TypeMirror erasedResponseBodyType = this.pluginContext.getTypeUtils().erasure(responseBodyType);
                                                responseBodyReactiveKind = null;
                                                responseBodyReactiveKind = this.pluginContext.getTypeUtils().isSameType(erasedResponseBodyType, this.publisherType) ? WebResponseBodyInfo.ResponseBodyReactiveKind.PUBLISHER : (this.pluginContext.getTypeUtils().isSameType(erasedResponseBodyType, this.monoType) ? WebResponseBodyInfo.ResponseBodyReactiveKind.ONE : (this.pluginContext.getTypeUtils().isSameType(erasedResponseBodyType, this.fluxType) ? WebResponseBodyInfo.ResponseBodyReactiveKind.MANY : WebResponseBodyInfo.ResponseBodyReactiveKind.NONE));
                                                responseBodyKind = WebResponseBodyInfo.ResponseBodyKind.ENCODED;
                                                if (responseBodyReactiveKind == WebResponseBodyInfo.ResponseBodyReactiveKind.NONE) break block49;
                                                responseBodyType = ((DeclaredType)responseBodyType).getTypeArguments().get(0);
                                                if (!this.pluginContext.getTypeUtils().isSameType(responseBodyType, this.voidType)) break block50;
                                                responseBodyKind = WebResponseBodyInfo.ResponseBodyKind.EMPTY;
                                                break block48;
                                            }
                                            if (!this.pluginContext.getTypeUtils().isSameType(responseBodyType, this.byteBufType)) break block51;
                                            responseBodyKind = WebResponseBodyInfo.ResponseBodyKind.RAW;
                                            break block48;
                                        }
                                        if (!this.pluginContext.getTypeUtils().isAssignable(responseBodyType, this.charSequenceType)) break block52;
                                        if (produces.isEmpty()) {
                                            responseBodyKind = WebResponseBodyInfo.ResponseBodyKind.CHARSEQUENCE;
                                        }
                                        break block48;
                                    }
                                    if (!this.pluginContext.getTypeUtils().isSameType(this.pluginContext.getTypeUtils().erasure(responseBodyType), this.sseRawEventType)) break block53;
                                    responseBodyType = ((DeclaredType)responseBodyType).getTypeArguments().get(0);
                                    if (this.pluginContext.getTypeUtils().isSameType(responseBodyType, this.byteBufType)) {
                                        responseBodyKind = WebResponseBodyInfo.ResponseBodyKind.SSE_RAW;
                                        break block48;
                                    } else if (this.pluginContext.getTypeUtils().isAssignable(responseBodyType, this.charSequenceType)) {
                                        responseBodyKind = WebResponseBodyInfo.ResponseBodyKind.SSE_CHARSEQUENCE;
                                        break block48;
                                    } else {
                                        routeReporter.error("Unsupported server-sent event type: " + responseBodyType);
                                    }
                                    break block48;
                                }
                                if (this.pluginContext.getTypeUtils().isSameType(this.pluginContext.getTypeUtils().erasure(responseBodyType), this.sseEncoderEventType)) {
                                    responseBodyKind = WebResponseBodyInfo.ResponseBodyKind.SSE_ENCODED;
                                    responseBodyType = ((DeclaredType)responseBodyType).getTypeArguments().get(0);
                                }
                                break block48;
                            }
                            if (responseBodyType.getKind() == TypeKind.VOID) {
                                responseBodyKind = WebResponseBodyInfo.ResponseBodyKind.EMPTY;
                            } else if (this.pluginContext.getTypeUtils().isSameType(responseBodyType, this.byteBufType)) {
                                responseBodyKind = WebResponseBodyInfo.ResponseBodyKind.RAW;
                            } else if (this.pluginContext.getTypeUtils().isAssignable(responseBodyType, this.charSequenceType)) {
                                if (produces.isEmpty()) {
                                    responseBodyKind = WebResponseBodyInfo.ResponseBodyKind.CHARSEQUENCE;
                                }
                            } else if (this.pluginContext.getTypeUtils().isSameType(responseBodyType, this.resourceType)) {
                                responseBodyKind = WebResponseBodyInfo.ResponseBodyKind.RESOURCE;
                            }
                        }
                        responseBodyInfo = new GenericWebResponseBodyInfo(responseBodyType, responseBodyKind, responseBodyReactiveKind);
                        parameters = new ArrayList<AbstractWebParameterInfo>();
                        boolean hasFormParameters = false;
                        ArrayList<AbstractWebParameterInfo> bodyParameters = new ArrayList<AbstractWebParameterInfo>();
                        sseFactoryParameter = null;
                        List<? extends VariableElement> routeParameters = routeElement.getParameters();
                        List<? extends VariableElement> routeAnnotatedParameters = routeAnnotatedElement.getParameters();
                        List<? extends TypeMirror> routeParameterTypes = routeType.getParameterTypes();
                        for (int i = 0; i < routeParameters.size(); ++i) {
                            TypeMirror routeParameterType;
                            VariableElement routeAnnotatedParameterElement;
                            VariableElement routeParameterElement = routeParameters.get(i);
                            AbstractWebParameterInfo parameterInfo = this.parameterFactory.createParameter(routeQName, routeParameterElement, routeAnnotatedParameterElement = routeAnnotatedParameters.get(i), routeParameterType = routeParameterTypes.get(i));
                            if (parameterInfo instanceof WebRequestBodyParameterInfo) {
                                bodyParameters.add(parameterInfo);
                            } else if (parameterInfo instanceof WebFormParameterInfo) {
                                hasFormParameters = true;
                            } else if (parameterInfo instanceof WebSseEventFactoryParameterInfo) {
                                sseFactoryParameter = (WebSseEventFactoryParameterInfo)((Object)parameterInfo);
                            }
                            parameters.add(parameterInfo);
                        }
                        if (hasFormParameters && bodyParameters.size() > 0) {
                            routeReporter.error("Can't mix Body and Form parameters");
                        }
                        if (bodyParameters.size() > 1) {
                            routeReporter.error("Multiple Body parameters");
                        }
                        if (sseFactoryParameter == null) break block54;
                        if (responseBodyInfo.getBodyKind() != WebResponseBodyInfo.ResponseBodyKind.SSE_RAW) break block55;
                        if (sseFactoryParameter.getEventFactoryKind() != WebSseEventFactoryParameterInfo.SseEventFactoryKind.RAW) {
                            routeReporter.error("SSE event factory " + sseFactoryParameter.getType() + " doesn't match sse response " + responseBodyInfo.getType());
                        }
                        break block56;
                    }
                    if (responseBodyInfo.getBodyKind() != WebResponseBodyInfo.ResponseBodyKind.SSE_CHARSEQUENCE) break block57;
                    if (sseFactoryParameter.getEventFactoryKind() != WebSseEventFactoryParameterInfo.SseEventFactoryKind.CHARSEQUENCE) {
                        routeReporter.error("SSE event factory " + sseFactoryParameter.getType() + " doesn't match sse response " + responseBodyInfo.getType());
                    }
                    break block56;
                }
                if (responseBodyInfo.getBodyKind() == WebResponseBodyInfo.ResponseBodyKind.SSE_ENCODED) {
                    if (sseFactoryParameter.getEventFactoryKind() != WebSseEventFactoryParameterInfo.SseEventFactoryKind.ENCODED || !this.pluginContext.getTypeUtils().isSameType(responseBodyInfo.getType(), sseFactoryParameter.getType())) {
                        routeReporter.error("SSE event factory " + sseFactoryParameter.getType() + " doesn't match sse response " + responseBodyInfo.getType());
                    }
                    break block56;
                } else {
                    routeReporter.error("Invalid SSE route declaration which must return a publisher of SSE events and define a corresponding SSE event factory parameter");
                }
                break block56;
            }
            if (responseBodyInfo.getBodyKind() == WebResponseBodyInfo.ResponseBodyKind.SSE_RAW || responseBodyInfo.getBodyKind() == WebResponseBodyInfo.ResponseBodyKind.SSE_ENCODED) {
                routeReporter.error("Invalid SSE route declaration which must return a publisher of SSE events and define a corresponding SSE event factory parameter");
            }
        }
        GenericWebRouteInfo routeInfo = new GenericWebRouteInfo(routeElement, routeQName, routeReporter, paths, matchTrailingSlash, methods, consumes, produces, languages, parameters, responseBodyInfo);
        this.routes.putIfAbsent(routeElement, routeInfo);
        return routeInfo;
    }

    public List<ProvidedWebRouteInfo> compileRouterRoutes(BeanInfo bean) throws IllegalArgumentException {
        TypeElement beanElement = (TypeElement)this.pluginContext.getTypeUtils().asElement(bean.getType());
        AnnotationMirror webRoutesAnnotation = this.pluginContext.getElementUtils().getAllAnnotationMirrors(beanElement).stream().filter(annotation -> this.pluginContext.getTypeUtils().isSameType(annotation.getAnnotationType(), this.webRoutesAnnotationType)).findFirst().orElseThrow(() -> new IllegalArgumentException("bean " + bean + " is not annotated with " + WebRoutes.class));
        if (webRoutesAnnotation.getElementValues().isEmpty()) {
            return List.of();
        }
        AtomicInteger routeIndex = new AtomicInteger();
        return ((Collection)webRoutesAnnotation.getElementValues().values().iterator().next().getValue()).stream().map(value -> (AnnotationMirror)value.getValue()).map(webRouteAnnotation -> {
            HashSet<String> paths = new HashSet<String>();
            boolean matchTrailingSlash = false;
            HashSet<Method> methods = new HashSet<Method>();
            HashSet<String> consumes = new HashSet<String>();
            HashSet<String> produces = new HashSet<String>();
            HashSet<String> languages = new HashSet<String>();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> value : this.pluginContext.getElementUtils().getElementValuesWithDefaults((AnnotationMirror)webRouteAnnotation).entrySet()) {
                switch (value.getKey().getSimpleName().toString()) {
                    case "path": {
                        paths.addAll(((List)value.getValue().getValue()).stream().map(v -> v.getValue().toString()).collect(Collectors.toSet()));
                        break;
                    }
                    case "matchTrailingSlash": {
                        matchTrailingSlash = (Boolean)value.getValue().getValue();
                        break;
                    }
                    case "method": {
                        methods.addAll(((List)value.getValue().getValue()).stream().map(v -> Method.valueOf((String)v.getValue().toString())).collect(Collectors.toSet()));
                        break;
                    }
                    case "consumes": {
                        consumes.addAll(((List)value.getValue().getValue()).stream().map(v -> v.getValue().toString()).collect(Collectors.toSet()));
                        break;
                    }
                    case "produces": {
                        produces.addAll(((List)value.getValue().getValue()).stream().map(v -> v.getValue().toString()).collect(Collectors.toSet()));
                        break;
                    }
                    case "language": {
                        languages.addAll(((List)value.getValue().getValue()).stream().map(v -> v.getValue().toString()).collect(Collectors.toSet()));
                    }
                }
            }
            WebRouteQualifiedName routeQName = new WebRouteQualifiedName(bean.getQualifiedName(), "route_" + routeIndex.getAndIncrement());
            return new ProvidedWebRouteInfo(routeQName, (ReporterInfo)bean, paths, matchTrailingSlash, methods, consumes, produces, languages);
        }).collect(Collectors.toList());
    }

    public List<GenericWebRouteInfo> compileControllerRoutes(BeanInfo bean) throws IllegalArgumentException {
        TypeElement beanElement = (TypeElement)this.pluginContext.getTypeUtils().asElement(bean.getType());
        this.typeHierarchyExtractor.extractTypeHierarchy(beanElement).stream().map(element -> this.pluginContext.getElementUtils().getAllAnnotationMirrors((Element)element).stream().filter(annotation -> this.pluginContext.getTypeUtils().isSameType(annotation.getAnnotationType(), this.webControllerAnnotationType)).findFirst()).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new IllegalArgumentException("bean " + bean + " is not annotated with " + WebController.class));
        HashMap routesByMethodName = new HashMap();
        for (ExecutableElement routeElement : ElementFilter.methodsIn(this.pluginContext.getElementUtils().getAllMembers(beanElement))) {
            this.getWebRouteAnnotatedElement(routeElement, beanElement).ifPresent(routeAnnotatedElement -> {
                AnnotationMirror webRouteAnnotation = null;
                for (AnnotationMirror annotationMirror : this.pluginContext.getElementUtils().getAllAnnotationMirrors((Element)routeAnnotatedElement)) {
                    if (!this.pluginContext.getTypeUtils().isSameType(annotationMirror.getAnnotationType(), this.webRouteAnnotationType)) continue;
                    webRouteAnnotation = annotationMirror;
                    break;
                }
                ExecutableType routeElementType = (ExecutableType)this.pluginContext.getTypeUtils().asMemberOf((DeclaredType)bean.getType(), routeElement);
                String string = routeElement.getSimpleName().toString();
                LinkedList<GenericWebRouteInfo> currentRoutes = (LinkedList<GenericWebRouteInfo>)routesByMethodName.get(string);
                if (currentRoutes == null) {
                    currentRoutes = new LinkedList<GenericWebRouteInfo>();
                    routesByMethodName.put(string, currentRoutes);
                }
                currentRoutes.add(this.createRoute(webRouteAnnotation, bean.getQualifiedName(), routeElement, (ExecutableElement)routeAnnotatedElement, routeElementType, currentRoutes.isEmpty() ? null : Integer.valueOf(currentRoutes.size())));
            });
        }
        return routesByMethodName.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Optional<ExecutableElement> getWebRouteAnnotatedElement(ExecutableElement executableElement, TypeElement typeElement) {
        return this.typeHierarchyExtractor.extractTypeHierarchy(typeElement).stream().map(element -> ElementFilter.methodsIn(element.getEnclosedElements()).stream().filter(methodElement -> methodElement.equals(executableElement) || this.pluginContext.getElementUtils().overrides(executableElement, (ExecutableElement)methodElement, typeElement)).findFirst()).filter(Optional::isPresent).map(Optional::get).filter(overriddenElement -> overriddenElement.getAnnotationMirrors().stream().anyMatch(annotation -> this.pluginContext.getTypeUtils().isSameType(annotation.getAnnotationType(), this.webRouteAnnotationType))).findFirst();
    }
}

