/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.web.compiler.internal;

import io.inverno.mod.base.net.URIs;
import io.inverno.mod.http.base.Method;
import io.inverno.mod.web.compiler.spi.WebControllerInfo;
import io.inverno.mod.web.compiler.spi.WebRouteInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class WebRouteDuplicateDetector {
    WebRouteDuplicateDetector() {
    }

    public Map<WebRouteInfo, Set<WebRouteInfo>> findDuplicates(List<? extends WebRouteInfo> routes) {
        HashMap<WebRouteInfo, Set<WebRouteInfo>> result = new HashMap<WebRouteInfo, Set<WebRouteInfo>>();
        int routeIndex = 0;
        for (WebRouteInfo webRouteInfo : routes) {
            List<WebRouteInfo> duplicates = this.visitRoute(webRouteInfo, routes.subList(++routeIndex, routes.size()));
            if (duplicates.isEmpty()) continue;
            HashSet<WebRouteInfo> routeDuplicates = (HashSet<WebRouteInfo>)result.get(webRouteInfo);
            if (routeDuplicates == null) {
                routeDuplicates = new HashSet<WebRouteInfo>();
                result.put(webRouteInfo, routeDuplicates);
            }
            routeDuplicates.addAll(duplicates);
            for (WebRouteInfo duplicateRoute : routeDuplicates) {
                HashSet<WebRouteInfo> duplicateRouteDuplicates = (HashSet<WebRouteInfo>)result.get(duplicateRoute);
                if (duplicateRouteDuplicates == null) {
                    duplicateRouteDuplicates = new HashSet<WebRouteInfo>();
                    result.put(duplicateRoute, duplicateRouteDuplicates);
                }
                duplicateRouteDuplicates.add(webRouteInfo);
                duplicateRouteDuplicates.addAll(routeDuplicates.stream().filter(duplicate -> !duplicate.equals(duplicateRoute)).collect(Collectors.toSet()));
            }
        }
        return result;
    }

    private List<WebRouteInfo> visitRoute(WebRouteInfo route, List<? extends WebRouteInfo> routes) {
        if (routes.isEmpty()) {
            return List.of();
        }
        if (route.getPaths().length > 0) {
            ArrayList<WebRouteInfo> duplicates = new ArrayList<WebRouteInfo>();
            for (String path : route.getPaths()) {
                duplicates.addAll(this.visitPath(route, route.getController().map(WebControllerInfo::getRootPath).map(rootPath -> URIs.uri((String)rootPath, (URIs.Option[])new URIs.Option[0]).path(path, false).buildRawPath()).orElse(path), route.isMatchTrailingSlash(), routes));
            }
            return duplicates;
        }
        return this.visitPath(route, null, false, routes);
    }

    private List<WebRouteInfo> visitPath(WebRouteInfo route, String path, boolean matchingTrailingSlash, List<? extends WebRouteInfo> routes) {
        if (routes.isEmpty()) {
            return List.of();
        }
        List reducedRoutes = routes.stream().filter(r -> {
            if (path != null) {
                boolean pathMatch;
                boolean bl = pathMatch = Arrays.binarySearch(r.getPaths(), path) >= 0;
                if (route.isMatchTrailingSlash()) {
                    Object otherPath = path.endsWith("/") ? path.substring(0, path.length() - 1) : path + "/";
                    pathMatch |= Arrays.binarySearch(r.getPaths(), otherPath) >= 0;
                }
                return pathMatch;
            }
            return r.getPaths().length == 0;
        }).collect(Collectors.toList());
        if (route.getMethods().length > 0) {
            ArrayList<WebRouteInfo> duplicates = new ArrayList<WebRouteInfo>();
            for (Method method : route.getMethods()) {
                duplicates.addAll(this.visitMethod(route, method, reducedRoutes));
            }
            return duplicates;
        }
        return this.visitMethod(route, null, reducedRoutes);
    }

    private List<WebRouteInfo> visitMethod(WebRouteInfo route, Method method, List<? extends WebRouteInfo> routes) {
        if (routes.isEmpty()) {
            return List.of();
        }
        List reducedRoutes = routes.stream().filter(r -> {
            if (method != null) {
                return Arrays.binarySearch(r.getMethods(), method) >= 0;
            }
            return r.getMethods().length == 0;
        }).collect(Collectors.toList());
        if (route.getConsumes().length > 0) {
            ArrayList<WebRouteInfo> duplicates = new ArrayList<WebRouteInfo>();
            for (String consume : route.getConsumes()) {
                duplicates.addAll(this.visitConsumes(route, consume, reducedRoutes));
            }
            return duplicates;
        }
        return this.visitConsumes(route, null, reducedRoutes);
    }

    private List<WebRouteInfo> visitConsumes(WebRouteInfo route, String consumes, List<? extends WebRouteInfo> routes) {
        if (routes.isEmpty()) {
            return List.of();
        }
        List reducedRoutes = routes.stream().filter(r -> {
            if (consumes != null) {
                return Arrays.binarySearch(r.getConsumes(), consumes) >= 0;
            }
            return r.getConsumes().length == 0;
        }).collect(Collectors.toList());
        if (route.getProduces().length > 0) {
            ArrayList<WebRouteInfo> duplicates = new ArrayList<WebRouteInfo>();
            for (String produce : route.getProduces()) {
                duplicates.addAll(this.visitProduces(route, produce, reducedRoutes));
            }
            return duplicates;
        }
        return this.visitProduces(route, null, reducedRoutes);
    }

    private List<WebRouteInfo> visitProduces(WebRouteInfo route, String produces, List<? extends WebRouteInfo> routes) {
        if (routes.isEmpty()) {
            return List.of();
        }
        List reducedRoutes = routes.stream().filter(r -> {
            if (produces != null) {
                return Arrays.binarySearch(r.getProduces(), produces) >= 0;
            }
            return r.getProduces().length == 0;
        }).collect(Collectors.toList());
        if (route.getLanguages().length > 0) {
            ArrayList<WebRouteInfo> duplicates = new ArrayList<WebRouteInfo>();
            for (String language : route.getLanguages()) {
                duplicates.addAll(this.visitLanguage(route, language, reducedRoutes));
            }
            return duplicates;
        }
        return this.visitLanguage(route, null, reducedRoutes);
    }

    private List<WebRouteInfo> visitLanguage(WebRouteInfo route, String language, List<? extends WebRouteInfo> routes) {
        if (routes.isEmpty()) {
            return List.of();
        }
        return routes.stream().filter(r -> {
            if (language != null) {
                return Arrays.binarySearch(r.getLanguages(), language) >= 0;
            }
            return r.getLanguages().length == 0;
        }).collect(Collectors.toList());
    }
}

