/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.web.compiler.internal;

import io.inverno.core.compiler.spi.ReporterInfo;
import io.inverno.core.compiler.spi.plugin.PluginContext;
import io.inverno.core.compiler.spi.plugin.PluginExecution;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.server.ResponseBody;
import io.inverno.mod.web.WebExchange;
import io.inverno.mod.web.WebPart;
import io.inverno.mod.web.WebResponseBody;
import io.inverno.mod.web.annotation.Body;
import io.inverno.mod.web.annotation.CookieParam;
import io.inverno.mod.web.annotation.FormParam;
import io.inverno.mod.web.annotation.HeaderParam;
import io.inverno.mod.web.annotation.PathParam;
import io.inverno.mod.web.annotation.QueryParam;
import io.inverno.mod.web.annotation.SseEventFactory;
import io.inverno.mod.web.compiler.internal.AbstractWebParameterInfo;
import io.inverno.mod.web.compiler.internal.GenericWebCookieParameterInfo;
import io.inverno.mod.web.compiler.internal.GenericWebExchangeParameterInfo;
import io.inverno.mod.web.compiler.internal.GenericWebFormParameterInfo;
import io.inverno.mod.web.compiler.internal.GenericWebHeaderParameterInfo;
import io.inverno.mod.web.compiler.internal.GenericWebPathParameterInfo;
import io.inverno.mod.web.compiler.internal.GenericWebQueryParameterInfo;
import io.inverno.mod.web.compiler.internal.GenericWebRequestBodyParameterInfo;
import io.inverno.mod.web.compiler.internal.GenericWebSseEventFactoryParameterInfo;
import io.inverno.mod.web.compiler.internal.InvalidWebParameterInfo;
import io.inverno.mod.web.compiler.internal.NoOpReporterInfo;
import io.inverno.mod.web.compiler.spi.WebParameterQualifiedName;
import io.inverno.mod.web.compiler.spi.WebRequestBodyParameterInfo;
import io.inverno.mod.web.compiler.spi.WebRouteQualifiedName;
import io.inverno.mod.web.compiler.spi.WebSseEventFactoryParameterInfo;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class WebParameterInfoFactory {
    private final PluginContext pluginContext;
    private final PluginExecution pluginExecution;
    private final Map<VariableElement, AbstractWebParameterInfo> processedParameterElements;
    private final TypeMirror bodyAnnotationType;
    private final TypeMirror cookieParameterAnnotationType;
    private final TypeMirror formParameterAnnotationType;
    private final TypeMirror headerParameterAnnotationType;
    private final TypeMirror pathParameterAnnotationType;
    private final TypeMirror queryParameterAnnotationType;
    private final TypeMirror sseEventFactoryAnnotationType;
    private final TypeMirror webExchangeType;
    private final TypeMirror sseEventFactoryType;
    private final TypeMirror sseEncoderEventFactoryType;
    private final TypeMirror optionalType;
    private final TypeMirror monoType;
    private final TypeMirror fluxType;
    private final TypeMirror publisherType;
    private final TypeMirror byteBufType;
    private final TypeMirror charSequenceType;
    private final TypeMirror webPartType;
    private final TypeMirror parameterType;

    public WebParameterInfoFactory(PluginContext pluginContext, PluginExecution pluginExecution) {
        this.pluginContext = Objects.requireNonNull(pluginContext);
        this.pluginExecution = Objects.requireNonNull(pluginExecution);
        this.processedParameterElements = new HashMap<VariableElement, AbstractWebParameterInfo>();
        this.bodyAnnotationType = this.pluginContext.getElementUtils().getTypeElement(Body.class.getCanonicalName()).asType();
        this.cookieParameterAnnotationType = this.pluginContext.getElementUtils().getTypeElement(CookieParam.class.getCanonicalName()).asType();
        this.formParameterAnnotationType = this.pluginContext.getElementUtils().getTypeElement(FormParam.class.getCanonicalName()).asType();
        this.headerParameterAnnotationType = this.pluginContext.getElementUtils().getTypeElement(HeaderParam.class.getCanonicalName()).asType();
        this.pathParameterAnnotationType = this.pluginContext.getElementUtils().getTypeElement(PathParam.class.getCanonicalName()).asType();
        this.queryParameterAnnotationType = this.pluginContext.getElementUtils().getTypeElement(QueryParam.class.getCanonicalName()).asType();
        this.sseEventFactoryAnnotationType = this.pluginContext.getElementUtils().getTypeElement(SseEventFactory.class.getCanonicalName()).asType();
        this.optionalType = this.pluginContext.getTypeUtils().erasure(this.pluginContext.getElementUtils().getTypeElement(Optional.class.getCanonicalName()).asType());
        this.monoType = this.pluginContext.getTypeUtils().erasure(this.pluginContext.getElementUtils().getTypeElement(Mono.class.getCanonicalName()).asType());
        this.fluxType = this.pluginContext.getTypeUtils().erasure(this.pluginContext.getElementUtils().getTypeElement(Flux.class.getCanonicalName()).asType());
        this.publisherType = this.pluginContext.getTypeUtils().erasure(this.pluginContext.getElementUtils().getTypeElement(Publisher.class.getCanonicalName()).asType());
        this.byteBufType = this.pluginContext.getElementUtils().getTypeElement(ByteBuf.class.getCanonicalName()).asType();
        this.charSequenceType = this.pluginContext.getElementUtils().getTypeElement(CharSequence.class.getCanonicalName()).asType();
        this.webPartType = this.pluginContext.getElementUtils().getTypeElement(WebPart.class.getCanonicalName()).asType();
        this.parameterType = this.pluginContext.getElementUtils().getTypeElement(Parameter.class.getCanonicalName()).asType();
        this.webExchangeType = this.pluginContext.getElementUtils().getTypeElement(WebExchange.class.getCanonicalName()).asType();
        this.sseEventFactoryType = this.pluginContext.getTypeUtils().erasure(this.pluginContext.getElementUtils().getTypeElement(ResponseBody.Sse.EventFactory.class.getCanonicalName()).asType());
        this.sseEncoderEventFactoryType = this.pluginContext.getTypeUtils().erasure(this.pluginContext.getElementUtils().getTypeElement(WebResponseBody.SseEncoder.EventFactory.class.getCanonicalName()).asType());
    }

    public AbstractWebParameterInfo createParameter(WebRouteQualifiedName routeQName, VariableElement parameterElement, VariableElement annotatedParameterElement, TypeMirror parameterType) {
        boolean required;
        AbstractWebParameterInfo result = null;
        WebParameterQualifiedName parameterQName = new WebParameterQualifiedName(routeQName, annotatedParameterElement.getSimpleName().toString());
        boolean bl = required = !this.pluginContext.getTypeUtils().isSameType(this.pluginContext.getTypeUtils().erasure(parameterType), this.optionalType);
        if (!required) {
            parameterType = ((DeclaredType)parameterType).getTypeArguments().get(0);
        }
        ReporterInfo parameterReporter = this.pluginExecution.getReporter((Element)parameterElement);
        parameterReporter = this.processedParameterElements.containsKey(parameterElement) ? new NoOpReporterInfo((ReporterInfo)this.processedParameterElements.get(parameterElement)) : this.pluginExecution.getReporter((Element)parameterElement);
        for (AnnotationMirror annotationMirror : annotatedParameterElement.getAnnotationMirrors()) {
            AbstractWebParameterInfo currentParameterInfo = null;
            if (this.pluginContext.getTypeUtils().isSameType(annotationMirror.getAnnotationType(), this.bodyAnnotationType)) {
                if (!required) {
                    parameterReporter.error("Request body parameter can't be optional");
                } else {
                    currentParameterInfo = this.createRequestBodyParameter(parameterReporter, parameterQName, parameterElement, parameterType);
                }
            } else if (this.pluginContext.getTypeUtils().isSameType(annotationMirror.getAnnotationType(), this.cookieParameterAnnotationType)) {
                currentParameterInfo = this.createCookieParameter(parameterReporter, parameterQName, parameterElement, parameterType, required);
            } else if (this.pluginContext.getTypeUtils().isSameType(annotationMirror.getAnnotationType(), this.formParameterAnnotationType)) {
                currentParameterInfo = this.createFormParameter(parameterReporter, parameterQName, parameterElement, parameterType, required);
            } else if (this.pluginContext.getTypeUtils().isSameType(annotationMirror.getAnnotationType(), this.headerParameterAnnotationType)) {
                currentParameterInfo = this.createHeaderParameter(parameterReporter, parameterQName, parameterElement, parameterType, required);
            } else if (this.pluginContext.getTypeUtils().isSameType(annotationMirror.getAnnotationType(), this.pathParameterAnnotationType)) {
                currentParameterInfo = this.createPathParameter(parameterReporter, parameterQName, parameterElement, parameterType, required);
            } else if (this.pluginContext.getTypeUtils().isSameType(annotationMirror.getAnnotationType(), this.queryParameterAnnotationType)) {
                currentParameterInfo = this.createQueryParameter(parameterReporter, parameterQName, parameterElement, parameterType, required);
            } else if (this.pluginContext.getTypeUtils().isSameType(annotationMirror.getAnnotationType(), this.sseEventFactoryAnnotationType)) {
                if (!required) {
                    parameterReporter.error("SSE event factory parameter can't be optional");
                } else {
                    currentParameterInfo = this.createSseEventFactoryParameter(parameterReporter, parameterQName, parameterElement);
                }
            }
            if (currentParameterInfo == null) continue;
            if (result != null) {
                parameterReporter.error("Too many web parameter annotations specified, only one is allowed");
                break;
            }
            result = currentParameterInfo;
        }
        if (result == null && this.pluginContext.getTypeUtils().isAssignable(this.webExchangeType, parameterElement.asType())) {
            result = this.createExchangeParameter(parameterReporter, parameterQName, parameterElement);
        }
        if (result == null) {
            if (!parameterReporter.hasError()) {
                parameterReporter.error("Invalid parameter which is neither a web parameter, nor a valid contextual parameter");
            }
            result = new InvalidWebParameterInfo(parameterQName, parameterReporter, parameterElement, required);
        }
        this.processedParameterElements.putIfAbsent(parameterElement, result);
        return result;
    }

    private GenericWebCookieParameterInfo createCookieParameter(ReporterInfo reporter, WebParameterQualifiedName parameterQName, VariableElement parameterElement, TypeMirror parameterType, boolean required) {
        return new GenericWebCookieParameterInfo(parameterQName, reporter, parameterElement, parameterType, required);
    }

    private GenericWebExchangeParameterInfo createExchangeParameter(ReporterInfo reporter, WebParameterQualifiedName parameterQName, VariableElement parameterElement) {
        return new GenericWebExchangeParameterInfo(parameterQName, reporter, parameterElement);
    }

    private GenericWebSseEventFactoryParameterInfo createSseEventFactoryParameter(ReporterInfo reporter, WebParameterQualifiedName parameterQName, VariableElement parameterElement) {
        if (this.pluginContext.getTypeUtils().isSameType(this.sseEncoderEventFactoryType, this.pluginContext.getTypeUtils().erasure(parameterElement.asType()))) {
            return new GenericWebSseEventFactoryParameterInfo(parameterQName, reporter, parameterElement, ((DeclaredType)parameterElement.asType()).getTypeArguments().get(0), WebSseEventFactoryParameterInfo.SseEventFactoryKind.ENCODED, parameterElement.getAnnotation(SseEventFactory.class).value());
        }
        if (this.pluginContext.getTypeUtils().isSameType(this.sseEventFactoryType, this.pluginContext.getTypeUtils().erasure(parameterElement.asType()))) {
            TypeMirror sseEventType = ((DeclaredType)parameterElement.asType()).getTypeArguments().get(0);
            WebSseEventFactoryParameterInfo.SseEventFactoryKind sseFactoryType = WebSseEventFactoryParameterInfo.SseEventFactoryKind.RAW;
            if (this.pluginContext.getTypeUtils().isSameType(sseEventType, this.byteBufType)) {
                sseFactoryType = WebSseEventFactoryParameterInfo.SseEventFactoryKind.RAW;
            } else if (this.pluginContext.getTypeUtils().isAssignable(sseEventType, this.charSequenceType)) {
                sseFactoryType = WebSseEventFactoryParameterInfo.SseEventFactoryKind.CHARSEQUENCE;
            } else {
                reporter.error("Unsupported server-sent event type: " + sseEventType);
            }
            return new GenericWebSseEventFactoryParameterInfo(parameterQName, reporter, parameterElement, sseEventType, sseFactoryType, parameterElement.getAnnotation(SseEventFactory.class).value());
        }
        reporter.error("Invalid SSE event factory parameter which must be of type " + this.sseEventFactoryType + " or " + this.sseEncoderEventFactoryType);
        return new GenericWebSseEventFactoryParameterInfo(parameterQName, reporter, parameterElement, this.byteBufType, WebSseEventFactoryParameterInfo.SseEventFactoryKind.RAW);
    }

    private GenericWebFormParameterInfo createFormParameter(ReporterInfo reporter, WebParameterQualifiedName parameterQName, VariableElement parameterElement, TypeMirror parameterType, boolean required) {
        return new GenericWebFormParameterInfo(parameterQName, reporter, parameterElement, parameterType, required);
    }

    private GenericWebHeaderParameterInfo createHeaderParameter(ReporterInfo reporter, WebParameterQualifiedName parameterQName, VariableElement parameterElement, TypeMirror parameterType, boolean required) {
        return new GenericWebHeaderParameterInfo(parameterQName, reporter, parameterElement, parameterType, required);
    }

    private GenericWebPathParameterInfo createPathParameter(ReporterInfo reporter, WebParameterQualifiedName parameterQName, VariableElement parameterElement, TypeMirror parameterType, boolean required) {
        return new GenericWebPathParameterInfo(parameterQName, reporter, parameterElement, parameterType, required);
    }

    private GenericWebQueryParameterInfo createQueryParameter(ReporterInfo reporter, WebParameterQualifiedName parameterQName, VariableElement parameterElement, TypeMirror parameterType, boolean required) {
        return new GenericWebQueryParameterInfo(parameterQName, reporter, parameterElement, parameterType, required);
    }

    private GenericWebRequestBodyParameterInfo createRequestBodyParameter(ReporterInfo reporter, WebParameterQualifiedName parameterQName, VariableElement parameterElement, TypeMirror parameterType) {
        TypeMirror requestBodyType = parameterType;
        TypeMirror erasedRequestBodyType = this.pluginContext.getTypeUtils().erasure(requestBodyType);
        WebRequestBodyParameterInfo.RequestBodyReactiveKind requestBodyReactiveKind = null;
        requestBodyReactiveKind = this.pluginContext.getTypeUtils().isSameType(erasedRequestBodyType, this.publisherType) ? WebRequestBodyParameterInfo.RequestBodyReactiveKind.PUBLISHER : (this.pluginContext.getTypeUtils().isSameType(erasedRequestBodyType, this.monoType) ? WebRequestBodyParameterInfo.RequestBodyReactiveKind.ONE : (this.pluginContext.getTypeUtils().isSameType(erasedRequestBodyType, this.fluxType) ? WebRequestBodyParameterInfo.RequestBodyReactiveKind.MANY : WebRequestBodyParameterInfo.RequestBodyReactiveKind.NONE));
        WebRequestBodyParameterInfo.RequestBodyKind requestBodyKind = WebRequestBodyParameterInfo.RequestBodyKind.ENCODED;
        if (requestBodyReactiveKind != WebRequestBodyParameterInfo.RequestBodyReactiveKind.NONE) {
            requestBodyType = ((DeclaredType)requestBodyType).getTypeArguments().get(0);
            if (this.pluginContext.getTypeUtils().isSameType(requestBodyType, this.byteBufType)) {
                requestBodyKind = WebRequestBodyParameterInfo.RequestBodyKind.RAW;
            } else if (this.pluginContext.getTypeUtils().isAssignable(this.webPartType, requestBodyType)) {
                requestBodyKind = WebRequestBodyParameterInfo.RequestBodyKind.MULTIPART;
            } else if (this.pluginContext.getTypeUtils().isSameType(requestBodyType, this.parameterType)) {
                requestBodyKind = WebRequestBodyParameterInfo.RequestBodyKind.URLENCODED;
            }
        } else if (this.pluginContext.getTypeUtils().isSameType(requestBodyType, this.byteBufType)) {
            requestBodyKind = WebRequestBodyParameterInfo.RequestBodyKind.RAW;
        }
        return new GenericWebRequestBodyParameterInfo(parameterQName, reporter, parameterElement, requestBodyType, requestBodyKind, requestBodyReactiveKind);
    }
}

