/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.web.compiler.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

class TypeHierarchyExtractor {
    private Types typeUtils;

    public TypeHierarchyExtractor(Types typeUtils) {
        this.typeUtils = typeUtils;
    }

    public List<TypeElement> extractTypeHierarchy(TypeElement typeElement) {
        List<TypeElement> typeHierarchy = this.getTypeElementWrappers(typeElement, 0, 0).stream().sorted().map(SortableTypeElementWrapper::getTypeElement).collect(Collectors.toList());
        return typeHierarchy;
    }

    private List<SortableTypeElementWrapper> getTypeElementWrappers(TypeElement typeElement, int absoluteLevel, int extendsLevel) {
        ArrayList<SortableTypeElementWrapper> result = new ArrayList<SortableTypeElementWrapper>();
        result.add(new SortableTypeElementWrapper(typeElement, absoluteLevel, extendsLevel));
        TypeMirror superType = typeElement.getSuperclass();
        if (superType.getKind() == TypeKind.DECLARED) {
            TypeElement superTypeElement = (TypeElement)this.typeUtils.asElement(superType);
            result.addAll(this.getTypeElementWrappers(superTypeElement, absoluteLevel + 1, extendsLevel + 1));
        }
        for (TypeMirror typeMirror : typeElement.getInterfaces()) {
            TypeElement interfaceTypeElement = (TypeElement)this.typeUtils.asElement(typeMirror);
            result.addAll(this.getTypeElementWrappers(interfaceTypeElement, absoluteLevel + 1, extendsLevel));
        }
        return result;
    }

    private static class SortableTypeElementWrapper
    implements Comparable<SortableTypeElementWrapper> {
        private final TypeElement typeElement;
        private final int absoluteLevel;
        private final int extendsLevel;

        public SortableTypeElementWrapper(TypeElement typeElement, int absoluteLevel, int extendsLevel) {
            this.typeElement = typeElement;
            this.absoluteLevel = absoluteLevel;
            this.extendsLevel = extendsLevel;
        }

        public TypeElement getTypeElement() {
            return this.typeElement;
        }

        @Override
        public int compareTo(SortableTypeElementWrapper o) {
            if (this.absoluteLevel < o.absoluteLevel) {
                return -1;
            }
            if (this.absoluteLevel > o.absoluteLevel) {
                return 1;
            }
            if (this.extendsLevel < o.extendsLevel) {
                return -1;
            }
            if (this.extendsLevel > o.extendsLevel) {
                return 1;
            }
            return 0;
        }
    }
}

