/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.web.compiler.internal;

import io.inverno.mod.web.compiler.spi.WebControllerInfo;
import io.inverno.mod.web.compiler.spi.WebProvidedRouterConfigurerInfo;
import io.inverno.mod.web.compiler.spi.WebRouterConfigurerInfo;
import io.inverno.mod.web.compiler.spi.WebRouterConfigurerInfoVisitor;
import io.inverno.mod.web.compiler.spi.WebRouterConfigurerQualifiedName;
import java.util.List;
import javax.lang.model.element.ModuleElement;

class GenericWebRouterConfigurerInfo
implements WebRouterConfigurerInfo {
    private final ModuleElement element;
    private final WebRouterConfigurerQualifiedName name;
    private final List<? extends WebControllerInfo> webControllers;
    private final List<? extends WebProvidedRouterConfigurerInfo> webProvidedRouters;

    public GenericWebRouterConfigurerInfo(ModuleElement element, WebRouterConfigurerQualifiedName name, List<? extends WebControllerInfo> webControllers, List<? extends WebProvidedRouterConfigurerInfo> webProvidedRouters) {
        this.element = element;
        this.name = name;
        this.webControllers = webControllers != null ? webControllers : List.of();
        this.webProvidedRouters = webProvidedRouters != null ? webProvidedRouters : List.of();
    }

    @Override
    public ModuleElement getElement() {
        return this.element;
    }

    @Override
    public WebRouterConfigurerQualifiedName getQualifiedName() {
        return this.name;
    }

    public boolean hasError() {
        return this.webControllers.stream().anyMatch(controller -> controller.hasError());
    }

    public boolean hasWarning() {
        return this.webControllers.stream().anyMatch(controller -> controller.hasWarning());
    }

    public void error(String message) {
    }

    public void warning(String message) {
    }

    @Override
    public WebControllerInfo[] getControllers() {
        return (WebControllerInfo[])this.webControllers.stream().toArray(WebControllerInfo[]::new);
    }

    @Override
    public WebProvidedRouterConfigurerInfo[] getRouters() {
        return (WebProvidedRouterConfigurerInfo[])this.webProvidedRouters.stream().toArray(WebProvidedRouterConfigurerInfo[]::new);
    }

    @Override
    public <R, P> R accept(WebRouterConfigurerInfoVisitor<R, P> visitor, P p) {
        return visitor.visit(this, p);
    }
}

