/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.web.compiler.internal;

import io.inverno.core.compiler.spi.QualifiedName;
import io.inverno.core.compiler.spi.ReporterInfo;
import io.inverno.core.compiler.spi.support.AbstractInfo;
import io.inverno.mod.http.base.Method;
import io.inverno.mod.web.compiler.internal.AbstractWebParameterInfo;
import io.inverno.mod.web.compiler.internal.NoOpReporterInfo;
import io.inverno.mod.web.compiler.spi.WebControllerInfo;
import io.inverno.mod.web.compiler.spi.WebParameterInfo;
import io.inverno.mod.web.compiler.spi.WebResponseBodyInfo;
import io.inverno.mod.web.compiler.spi.WebRouteInfo;
import io.inverno.mod.web.compiler.spi.WebRouteQualifiedName;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;

class GenericWebRouteInfo
extends AbstractInfo<WebRouteQualifiedName>
implements WebRouteInfo {
    private Optional<WebControllerInfo> controller = Optional.empty();
    private final String[] paths;
    private final boolean matchTrailingSlash;
    private final Method[] methods;
    private final String[] consumes;
    private final String[] produces;
    private final String[] languages;
    private final List<? extends AbstractWebParameterInfo> parameters;
    private final WebResponseBodyInfo responseBody;
    private final ExecutableElement element;

    public GenericWebRouteInfo(ExecutableElement element, WebRouteQualifiedName name, ReporterInfo reporter, Set<String> paths, boolean matchTrailingSlash, Set<Method> methods, Set<String> consumes, Set<String> produces, Set<String> languages, List<? extends AbstractWebParameterInfo> parameters, WebResponseBodyInfo responseBody) {
        super((QualifiedName)name, reporter instanceof NoOpReporterInfo ? ((NoOpReporterInfo)reporter).getReporter() : reporter);
        this.element = element;
        this.paths = (String[])paths.stream().sorted().toArray(String[]::new);
        this.matchTrailingSlash = matchTrailingSlash;
        this.methods = (Method[])methods.stream().sorted().toArray(Method[]::new);
        this.consumes = (String[])consumes.stream().sorted().toArray(String[]::new);
        this.produces = (String[])produces.stream().sorted().toArray(String[]::new);
        this.languages = (String[])languages.stream().sorted().toArray(String[]::new);
        this.parameters = parameters;
        this.responseBody = responseBody;
    }

    @Override
    public Optional<WebControllerInfo> getController() {
        return this.controller;
    }

    public void setController(WebControllerInfo controller) {
        this.controller = Optional.ofNullable(controller);
    }

    public boolean hasError() {
        return super.hasError() || this.parameters.stream().anyMatch(parameter -> parameter.hasError());
    }

    public boolean hasWarning() {
        return super.hasWarning() || this.parameters.stream().anyMatch(parameter -> parameter.hasWarning());
    }

    @Override
    public String[] getPaths() {
        return this.paths;
    }

    @Override
    public boolean isMatchTrailingSlash() {
        return this.matchTrailingSlash;
    }

    @Override
    public Method[] getMethods() {
        return this.methods;
    }

    @Override
    public String[] getConsumes() {
        return this.consumes;
    }

    @Override
    public String[] getProduces() {
        return this.produces;
    }

    @Override
    public String[] getLanguages() {
        return this.languages;
    }

    @Override
    public Optional<ExecutableElement> getElement() {
        return Optional.ofNullable(this.element);
    }

    @Override
    public WebParameterInfo[] getParameters() {
        return this.parameters != null ? (WebParameterInfo[])this.parameters.stream().toArray(WebParameterInfo[]::new) : null;
    }

    @Override
    public WebResponseBodyInfo getResponseBody() {
        return this.responseBody;
    }
}

