/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.web.compiler.internal;

import io.inverno.core.compiler.spi.BeanQualifiedName;
import io.inverno.core.compiler.spi.QualifiedName;
import io.inverno.core.compiler.spi.ReporterInfo;
import io.inverno.core.compiler.spi.support.AbstractInfo;
import io.inverno.mod.web.compiler.internal.GenericWebRouteInfo;
import io.inverno.mod.web.compiler.internal.NoOpReporterInfo;
import io.inverno.mod.web.compiler.spi.WebControllerInfo;
import io.inverno.mod.web.compiler.spi.WebRouteInfo;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;

class GenericWebControllerInfo
extends AbstractInfo<BeanQualifiedName>
implements WebControllerInfo {
    private final TypeElement element;
    private final DeclaredType type;
    private final String rootPath;
    private final List<? extends WebRouteInfo> routes;

    public GenericWebControllerInfo(TypeElement element, BeanQualifiedName name, ReporterInfo reporter, DeclaredType type, String rootPath, List<GenericWebRouteInfo> routes) {
        super((QualifiedName)name, reporter instanceof NoOpReporterInfo ? ((NoOpReporterInfo)reporter).getReporter() : reporter);
        this.element = element;
        this.type = Objects.requireNonNull(type);
        this.rootPath = rootPath;
        this.routes = routes != null ? routes : List.of();
        for (GenericWebRouteInfo route : routes) {
            route.setController(this);
        }
    }

    @Override
    public TypeElement getElement() {
        return this.element;
    }

    public boolean hasError() {
        return super.hasError() || this.routes.stream().anyMatch(route -> route.hasError());
    }

    public boolean hasWarning() {
        return super.hasWarning() || this.routes.stream().anyMatch(route -> route.hasWarning());
    }

    @Override
    public DeclaredType getType() {
        return this.type;
    }

    @Override
    public String getRootPath() {
        return this.rootPath;
    }

    @Override
    public WebRouteInfo[] getRoutes() {
        return (WebRouteInfo[])this.routes.stream().toArray(WebRouteInfo[]::new);
    }
}

