/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.internal.context;

import io.inverno.mod.security.accesscontrol.AccessController;
import io.inverno.mod.security.authentication.Authentication;
import io.inverno.mod.security.context.SecurityContext;
import io.inverno.mod.security.identity.Identity;
import java.util.Objects;
import java.util.Optional;

public class GenericSecurityContext<A extends Identity, B extends AccessController>
implements SecurityContext<A, B> {
    private final Authentication authentication;
    private Optional<A> identity;
    private Optional<B> accessController;

    public GenericSecurityContext(Authentication authentication) {
        Objects.requireNonNull(authentication);
        this.authentication = authentication;
        this.identity = Optional.empty();
        this.accessController = Optional.empty();
    }

    public void setIdentity(A identity) {
        this.identity = this.isAuthenticated() ? Optional.ofNullable(identity) : Optional.empty();
    }

    public void setIdentity(Optional<A> identity) {
        this.identity = this.isAuthenticated() ? identity : Optional.empty();
    }

    public void setAccessController(B accessController) {
        this.accessController = this.isAuthenticated() ? Optional.ofNullable(accessController) : Optional.empty();
    }

    public void setAccessController(Optional<B> accessController) {
        this.accessController = this.isAuthenticated() ? accessController : Optional.empty();
    }

    @Override
    public Authentication getAuthentication() {
        return this.authentication;
    }

    @Override
    public Optional<A> getIdentity() {
        return this.identity;
    }

    @Override
    public Optional<B> getAccessController() {
        return this.accessController;
    }
}

