/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.internal.authentication.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.inverno.mod.security.SecurityException;
import io.inverno.mod.security.authentication.user.UserAuthentication;
import io.inverno.mod.security.identity.Identity;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GenericUserAuthentication<A extends Identity>
implements UserAuthentication<A> {
    @JsonIgnore
    private final String username;
    @JsonIgnore
    private final A identity;
    @JsonIgnore
    private final Set<String> groups;
    @JsonIgnore
    private boolean authenticated;
    @JsonIgnore
    private Optional<SecurityException> cause;

    @JsonCreator
    public GenericUserAuthentication(@JsonProperty(value="username") String username, @JsonProperty(value="identity") A identity, @JsonProperty(value="groups") Set<String> groups, @JsonProperty(value="authenticated") boolean authenticated) {
        this.username = username;
        this.identity = identity;
        this.groups = groups != null ? Collections.unmodifiableSet(groups) : Set.of();
        this.authenticated = authenticated;
        this.cause = Optional.empty();
    }

    public void setCause(SecurityException cause) {
        if (cause != null) {
            this.authenticated = false;
        }
        this.cause = Optional.ofNullable(cause);
    }

    @Override
    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @Override
    @JsonProperty(value="groups")
    public Set<String> getGroups() {
        return this.groups;
    }

    @Override
    @JsonProperty(value="identity")
    public A getIdentity() {
        return this.identity;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public Optional<SecurityException> getCause() {
        return this.cause;
    }

    public int hashCode() {
        return Objects.hash(this.groups, this.identity, this.username);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericUserAuthentication other = (GenericUserAuthentication)obj;
        return Objects.equals(this.groups, other.groups) && Objects.equals(this.identity, other.identity) && Objects.equals(this.username, other.username);
    }
}

