/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.internal.authentication;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.inverno.mod.security.SecurityException;
import io.inverno.mod.security.authentication.PrincipalAuthentication;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GenericPrincipalAuthentication
implements PrincipalAuthentication {
    @JsonIgnore
    private final String username;
    @JsonIgnore
    private boolean authenticated;
    @JsonIgnore
    private Optional<SecurityException> cause;

    @JsonCreator
    public GenericPrincipalAuthentication(@JsonProperty(value="username") String username, @JsonProperty(value="authenticated") boolean authenticated) {
        this.username = username;
        this.authenticated = authenticated;
        this.cause = Optional.empty();
    }

    public void setCause(SecurityException cause) {
        if (cause != null) {
            this.authenticated = false;
        }
        this.cause = Optional.ofNullable(cause);
    }

    @Override
    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public Optional<SecurityException> getCause() {
        return this.cause;
    }

    public int hashCode() {
        return Objects.hash(this.authenticated, this.username);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericPrincipalAuthentication other = (GenericPrincipalAuthentication)obj;
        return this.authenticated == other.authenticated && Objects.equals(this.username, other.username);
    }
}

