/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.internal.authentication;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.inverno.mod.security.SecurityException;
import io.inverno.mod.security.authentication.Authentication;
import io.inverno.mod.security.authentication.AuthenticationException;
import java.util.Objects;
import java.util.Optional;

public class GenericAuthentication
implements Authentication {
    public static final GenericAuthentication ANONYMOUS = new GenericAuthentication(false);
    public static final GenericAuthentication GRANTED = new GenericAuthentication(true);
    public static final GenericAuthentication DENIED = new GenericAuthentication(new AuthenticationException("Access denied"));
    @JsonIgnore
    private final boolean authenticated;
    @JsonIgnore
    private final Optional<SecurityException> cause;

    public GenericAuthentication(boolean authenticated) {
        this.authenticated = authenticated;
        this.cause = Optional.empty();
    }

    public GenericAuthentication(SecurityException cause) {
        this.authenticated = false;
        this.cause = Optional.ofNullable(cause);
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public Optional<SecurityException> getCause() {
        return this.cause;
    }

    public int hashCode() {
        return Objects.hash(this.authenticated);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericAuthentication other = (GenericAuthentication)obj;
        return this.authenticated == other.authenticated;
    }
}

