/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.internal.accesscontrol;

import io.inverno.mod.security.accesscontrol.RoleBasedAccessController;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import reactor.core.publisher.Mono;

public class GenericRoleBasedAccessController
implements RoleBasedAccessController {
    private final Set<String> roles;

    public GenericRoleBasedAccessController(Set<String> roles) {
        this.roles = roles;
    }

    @Override
    public Mono<Boolean> hasRole(String role) {
        return Mono.just((Object)this.roles.contains(role));
    }

    @Override
    public Mono<Boolean> hasAnyRole(Collection<String> roles) {
        return Mono.just((Object)roles.stream().anyMatch(this.roles::contains));
    }

    @Override
    public Mono<Boolean> hasAllRoles(Collection<String> roles) {
        return Mono.just((Object)this.roles.containsAll(Arrays.asList(roles)));
    }
}

