/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.internal;

import io.inverno.mod.security.SecurityException;
import io.inverno.mod.security.SecurityManager;
import io.inverno.mod.security.accesscontrol.AccessController;
import io.inverno.mod.security.accesscontrol.AccessControllerResolver;
import io.inverno.mod.security.authentication.Authentication;
import io.inverno.mod.security.authentication.AuthenticationException;
import io.inverno.mod.security.authentication.Authenticator;
import io.inverno.mod.security.authentication.Credentials;
import io.inverno.mod.security.context.SecurityContext;
import io.inverno.mod.security.identity.Identity;
import io.inverno.mod.security.identity.IdentityResolver;
import java.util.Objects;
import java.util.Optional;
import reactor.core.publisher.Mono;

public class GenericSecurityManager<A extends Credentials, B extends Authentication, C extends Identity, D extends AccessController>
implements SecurityManager<A, C, D> {
    private final Authenticator<? super A, ? extends B> authenticator;
    private final Optional<IdentityResolver<? super B, ? extends C>> identityResolver;
    private final Optional<AccessControllerResolver<? super B, ? extends D>> accessControllerResolver;

    public GenericSecurityManager(Authenticator<? super A, ? extends B> authenticator) {
        this(authenticator, null, null);
    }

    public GenericSecurityManager(Authenticator<? super A, ? extends B> authenticator, IdentityResolver<? super B, ? extends C> identityResolver) {
        this(authenticator, identityResolver, null);
    }

    public GenericSecurityManager(Authenticator<? super A, ? extends B> authenticator, AccessControllerResolver<? super B, ? extends D> accessControllerResolver) {
        this(authenticator, null, accessControllerResolver);
    }

    public GenericSecurityManager(Authenticator<? super A, ? extends B> authenticator, IdentityResolver<? super B, ? extends C> identityResolver, AccessControllerResolver<? super B, ? extends D> accessControllerResolver) {
        this.authenticator = Objects.requireNonNull(authenticator);
        this.identityResolver = Optional.ofNullable(identityResolver);
        this.accessControllerResolver = Optional.ofNullable(accessControllerResolver);
    }

    @Override
    public Mono<SecurityContext<C, D>> authenticate(A credentials) {
        if (credentials == null) {
            return Mono.just(SecurityContext.of(Authentication.anonymous()));
        }
        return this.authenticator.authenticate(credentials).switchIfEmpty(Mono.error(() -> new AuthenticationException("Unable to authenticate"))).flatMap(authentication -> Mono.zip((Mono)Mono.just((Object)authentication), (Mono)this.identityResolver.filter(ign -> authentication.isAuthenticated()).map(resolver -> resolver.resolveIdentity(authentication).map(Optional::of).switchIfEmpty(Mono.just(Optional.empty()))).orElse(Mono.just(Optional.empty())), (Mono)this.accessControllerResolver.filter(ign -> authentication.isAuthenticated()).map(resolver -> resolver.resolveAccessController(authentication).map(Optional::of).switchIfEmpty(Mono.just(Optional.empty()))).orElse(Mono.just(Optional.empty()))).map(tuple -> SecurityContext.of(authentication, (Optional)tuple.getT2(), (Optional)tuple.getT3()))).onErrorResume(SecurityException.class, error -> Mono.just(SecurityContext.of(Authentication.denied(error))));
    }
}

