/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.context;

import io.inverno.mod.security.accesscontrol.AccessController;
import io.inverno.mod.security.authentication.Authentication;
import io.inverno.mod.security.identity.Identity;
import io.inverno.mod.security.internal.context.GenericSecurityContext;
import java.util.Optional;

public interface SecurityContext<A extends Identity, B extends AccessController> {
    public static <A extends Identity, B extends AccessController> SecurityContext<A, B> of(Authentication authentication) {
        return new GenericSecurityContext(authentication);
    }

    public static <A extends Identity, B extends AccessController> SecurityContext<A, B> of(Authentication authentication, A identity) {
        GenericSecurityContext context = new GenericSecurityContext(authentication);
        context.setIdentity(identity);
        return context;
    }

    public static <A extends Identity, B extends AccessController> SecurityContext<A, B> of(Authentication authentication, B accessController) {
        GenericSecurityContext context = new GenericSecurityContext(authentication);
        context.setAccessController(accessController);
        return context;
    }

    public static <A extends Identity, B extends AccessController> SecurityContext<A, B> of(Authentication authentication, A identity, B accessController) {
        GenericSecurityContext<A, B> context = new GenericSecurityContext<A, B>(authentication);
        context.setIdentity(identity);
        context.setAccessController(accessController);
        return context;
    }

    public static <A extends Identity, B extends AccessController> SecurityContext<A, B> of(Authentication authentication, Optional<A> identity, Optional<B> accessController) {
        GenericSecurityContext<A, B> context = new GenericSecurityContext<A, B>(authentication);
        context.setIdentity(identity);
        context.setAccessController(accessController);
        return context;
    }

    default public boolean isAuthenticated() {
        return this.getAuthentication().isAuthenticated();
    }

    default public boolean isAnonymous() {
        return this.getAuthentication().isAnonymous();
    }

    default public Authentication getAuthentication() {
        return Authentication.anonymous();
    }

    default public Optional<A> getIdentity() {
        return Optional.empty();
    }

    default public Optional<B> getAccessController() {
        return Optional.empty();
    }
}

