/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.authentication.user;

import io.inverno.mod.security.authentication.AuthenticationException;
import io.inverno.mod.security.authentication.CredentialsResolver;
import io.inverno.mod.security.authentication.LoginCredentials;
import io.inverno.mod.security.authentication.password.PasswordException;
import io.inverno.mod.security.authentication.password.PasswordPolicyException;
import io.inverno.mod.security.authentication.user.User;
import io.inverno.mod.security.authentication.user.UserRepositoryException;
import io.inverno.mod.security.identity.Identity;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface UserRepository<A extends Identity, B extends User<A>>
extends CredentialsResolver<B> {
    public Mono<B> createUser(B var1) throws UserRepositoryException;

    public Mono<B> getUser(String var1) throws UserRepositoryException;

    public Flux<B> listUsers() throws UserRepositoryException;

    public Mono<B> updateUser(B var1) throws UserRepositoryException;

    public Mono<B> changePassword(LoginCredentials var1, String var2) throws AuthenticationException, PasswordPolicyException, PasswordException, UserRepositoryException;

    public Mono<B> lockUser(String var1) throws UserRepositoryException;

    public Mono<B> unlockUser(String var1) throws UserRepositoryException;

    public Mono<B> addUserToGroups(String var1, String ... var2) throws UserRepositoryException;

    public Mono<B> removeUserFromGroups(String var1, String ... var2) throws UserRepositoryException;

    public Mono<B> deleteUser(String var1) throws UserRepositoryException;
}

