/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.authentication.user;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.inverno.mod.security.SecurityException;
import io.inverno.mod.security.authentication.GroupAwareAuthentication;
import io.inverno.mod.security.authentication.PrincipalAuthentication;
import io.inverno.mod.security.authentication.user.User;
import io.inverno.mod.security.identity.Identity;
import io.inverno.mod.security.internal.authentication.user.GenericUserAuthentication;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@JsonDeserialize(as=GenericUserAuthentication.class)
public interface UserAuthentication<A extends Identity>
extends PrincipalAuthentication,
GroupAwareAuthentication {
    @JsonProperty(value="identity")
    public A getIdentity();

    public static <A extends Identity> UserAuthentication<A> of(String username, String ... groups) {
        return new GenericUserAuthentication<Object>(username, null, Arrays.stream(groups).filter(Objects::nonNull).collect(Collectors.toSet()), true);
    }

    public static <A extends Identity> UserAuthentication<A> of(String username, SecurityException cause) {
        GenericUserAuthentication<Object> authentication = new GenericUserAuthentication<Object>(username, null, Set.of(), false);
        authentication.setCause(cause);
        return authentication;
    }

    public static <A extends Identity> UserAuthentication<A> of(String username, Collection<String> groups) {
        return new GenericUserAuthentication<Object>(username, null, groups.stream().filter(Objects::nonNull).collect(Collectors.toSet()), true);
    }

    public static <A extends Identity> UserAuthentication<A> of(String username, A identity, String ... groups) {
        return new GenericUserAuthentication<A>(username, identity, Arrays.stream(groups).filter(Objects::nonNull).collect(Collectors.toSet()), true);
    }

    public static <A extends Identity> UserAuthentication<A> of(String username, A identity, Collection<String> groups) {
        return new GenericUserAuthentication<A>(username, identity, groups.stream().filter(Objects::nonNull).collect(Collectors.toSet()), true);
    }

    public static <A extends Identity> UserAuthentication<A> of(User<A> user) {
        return new GenericUserAuthentication<A>(user.getUsername(), user.getIdentity(), user.getGroups(), !user.isLocked());
    }
}

