/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.authentication.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.inverno.mod.security.authentication.LoginCredentials;
import io.inverno.mod.security.authentication.password.Password;
import io.inverno.mod.security.identity.Identity;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class User<A extends Identity>
implements LoginCredentials {
    @JsonIgnore
    protected final String username;
    @JsonIgnore
    private A identity;
    @JsonIgnore
    private Password<?, ?> password;
    @JsonIgnore
    private Set<String> groups;
    @JsonIgnore
    private boolean locked;

    public User(String username, Password<?, ?> password, String ... groups) {
        this(username, null, password, Set.of(groups), false);
    }

    public User(String username, A identity, Password<?, ?> password, String ... groups) {
        this(username, identity, password, Set.of(groups), false);
    }

    @JsonCreator
    public User(@JsonProperty(value="username", required=true) String username, @JsonProperty(value="identity", required=false) A identity, @JsonProperty(value="password", required=false) Password<?, ?> password, @JsonProperty(value="groups") Set<String> groups, @JsonProperty(value="locked", defaultValue="false") boolean locked) {
        this.username = Objects.requireNonNull(username);
        this.identity = identity;
        this.password = Objects.requireNonNull(password);
        this.groups = groups != null ? Collections.unmodifiableSet(groups) : Set.of();
        this.locked = locked;
    }

    public static <A extends Identity> Builder<A> of(String username) {
        return new Builder(username);
    }

    @Override
    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="identity")
    public A getIdentity() {
        return this.identity;
    }

    @JsonIgnore
    protected void setIdentity(A identity) {
        this.identity = identity;
    }

    @Override
    @JsonProperty(value="password")
    public Password<?, ?> getPassword() {
        return this.password;
    }

    @JsonIgnore
    protected void setPassword(Password<?, ?> password) {
        this.password = Objects.requireNonNull(password);
    }

    @JsonProperty(value="groups")
    public Set<String> getGroups() {
        return this.groups;
    }

    @JsonIgnore
    protected void setGroups(Set<String> groups) {
        this.groups = groups != null ? Collections.unmodifiableSet(groups) : Set.of();
    }

    @Override
    @JsonProperty(value="locked")
    public boolean isLocked() {
        return this.locked;
    }

    @JsonIgnore
    protected void setLocked(boolean locked) {
        this.locked = locked;
    }

    public int hashCode() {
        return Objects.hash(this.username);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return Objects.equals(this.username, other.username);
    }

    public static class Builder<A extends Identity> {
        private final String username;
        private A identity;
        private Password<?, ?> password;
        private Set<String> groups;
        private boolean locked;

        private Builder(String username) {
            this.username = Objects.requireNonNull(username);
        }

        public <B extends Identity> Builder<B> identity(B identity) {
            Builder<A> builder = new Builder<A>(this.username);
            builder.identity = identity;
            builder.password = this.password;
            builder.groups = this.groups;
            builder.locked = this.locked;
            return builder;
        }

        public Builder<A> password(Password<?, ?> password) {
            this.password = Objects.requireNonNull(password);
            return this;
        }

        public Builder<A> groups(String ... groups) {
            this.groups = groups != null ? Arrays.stream(groups).collect(Collectors.toSet()) : null;
            return this;
        }

        public Builder<A> groups(Collection<String> groups) {
            this.groups = groups != null ? groups.stream().collect(Collectors.toSet()) : null;
            return this;
        }

        public Builder<A> locked(boolean locked) {
            this.locked = locked;
            return this;
        }

        public User<A> build() {
            return new User<A>(this.username, this.identity, this.password, this.groups, this.locked);
        }
    }
}

