/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.authentication.user;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.mod.redis.RedisClient;
import io.inverno.mod.redis.operations.RedisKeyReactiveOperations;
import io.inverno.mod.redis.operations.RedisStringReactiveOperations;
import io.inverno.mod.security.authentication.AuthenticationException;
import io.inverno.mod.security.authentication.LoginCredentials;
import io.inverno.mod.security.authentication.password.PBKDF2Password;
import io.inverno.mod.security.authentication.password.Password;
import io.inverno.mod.security.authentication.password.PasswordException;
import io.inverno.mod.security.authentication.password.PasswordPolicy;
import io.inverno.mod.security.authentication.password.PasswordPolicyException;
import io.inverno.mod.security.authentication.password.RawPassword;
import io.inverno.mod.security.authentication.password.SimplePasswordPolicy;
import io.inverno.mod.security.authentication.user.User;
import io.inverno.mod.security.authentication.user.UserRepository;
import io.inverno.mod.security.authentication.user.UserRepositoryException;
import io.inverno.mod.security.identity.Identity;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedisUserRepository<A extends Identity, B extends User<A>>
implements UserRepository<A, B> {
    private static final String DEFAULT_KEY_PREFIX = "SEC";
    private static final PBKDF2Password.Encoder DEFAULT_PASSWORD_ENCODER = new PBKDF2Password.Encoder();
    private final RedisClient<String, String> redisClient;
    private final ObjectMapper mapper;
    private final PasswordPolicy<B, ?> passwordPolicy;
    private final Password.Encoder<?, ?> passwordEncoder;
    private String keyPrefix;
    private String userKeyPrefix;
    private String groupKeyPrefix;

    public RedisUserRepository(RedisClient<String, String> redisClient, ObjectMapper mapper) {
        this(redisClient, mapper, DEFAULT_PASSWORD_ENCODER, new SimplePasswordPolicy());
    }

    public RedisUserRepository(RedisClient<String, String> redisClient, ObjectMapper mapper, PasswordPolicy<B, ?> passwordPolicy) {
        this(redisClient, mapper, DEFAULT_PASSWORD_ENCODER, passwordPolicy);
    }

    public RedisUserRepository(RedisClient<String, String> redisClient, ObjectMapper mapper, Password.Encoder<?, ?> passwordEncoder) {
        this(redisClient, mapper, passwordEncoder, new SimplePasswordPolicy());
    }

    public RedisUserRepository(RedisClient<String, String> redisClient, ObjectMapper mapper, Password.Encoder<?, ?> passwordEncoder, PasswordPolicy<B, ?> passwordPolicy) {
        this.redisClient = redisClient;
        this.mapper = mapper;
        this.passwordPolicy = passwordPolicy;
        this.passwordEncoder = passwordEncoder;
        this.setKeyPrefix(DEFAULT_KEY_PREFIX);
    }

    public Password.Encoder<?, ?> getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public PasswordPolicy<B, ?> getPasswordPolicy() {
        return this.passwordPolicy;
    }

    public final String getKeyPrefix() {
        return this.keyPrefix;
    }

    public final void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = StringUtils.isNotBlank((CharSequence)keyPrefix) ? keyPrefix : DEFAULT_KEY_PREFIX;
        this.userKeyPrefix = this.keyPrefix + ":USER:";
        this.groupKeyPrefix = this.keyPrefix + ":GROUP:";
    }

    @Override
    public Mono<B> createUser(B user) throws UserRepositoryException {
        Objects.requireNonNull(user);
        if (!(((User)user).getPassword() instanceof RawPassword)) {
            throw new UserRepositoryException("User password must be a raw password");
        }
        return Mono.from((Publisher)this.redisClient.connection(operations -> {
            try {
                this.passwordPolicy.verify(user, user.getPassword().getValue());
                user.setPassword((Password<?, ?>)this.passwordEncoder.encode(user.getPassword().getValue()));
                return ((RedisStringReactiveOperations.StringSetBuilder)operations.set().nx()).build((Object)(this.userKeyPrefix + user.getUsername()), (Object)this.mapper.writeValueAsString((Object)user)).switchIfEmpty(Mono.error(() -> new UserRepositoryException("User already exists: " + user.getUsername()))).flatMapMany(result -> {
                    if (result.equals("OK")) {
                        if (!user.getGroups().isEmpty()) {
                            return Flux.fromIterable(user.getGroups()).flatMap(group -> operations.sadd((Object)(this.groupKeyPrefix + group), (Object)user.getUsername()));
                        }
                        return Mono.empty();
                    }
                    throw new UserRepositoryException("Error setting user: " + user.getUsername());
                }).then(Mono.just((Object)user));
            }
            catch (JsonProcessingException e) {
                throw new UserRepositoryException(e);
            }
        }));
    }

    @Override
    public Mono<B> updateUser(B user) throws UserRepositoryException {
        Objects.requireNonNull(user);
        return this.getUser(((User)user).getUsername()).flatMap(previousUser -> {
            user.setPassword(previousUser.getPassword());
            user.setGroups(previousUser.getGroups());
            user.setLocked(previousUser.isLocked());
            try {
                return this.redisClient.set((Object)(this.userKeyPrefix + user.getUsername()), (Object)this.mapper.writeValueAsString((Object)user)).map(result -> {
                    if (result.equals("OK")) {
                        return user;
                    }
                    throw new UserRepositoryException("Error setting user: " + user.getUsername());
                });
            }
            catch (JsonProcessingException e) {
                throw new UserRepositoryException(e);
            }
        });
    }

    @Override
    public Mono<B> getUser(String username) throws UserRepositoryException {
        Objects.requireNonNull(username);
        return this.redisClient.get((Object)(this.userKeyPrefix + username)).map(jsonUser -> {
            try {
                return (User)this.mapper.readValue(jsonUser, User.class);
            }
            catch (JsonProcessingException e) {
                throw new UserRepositoryException("Malformed user: " + username, e);
            }
        });
    }

    @Override
    public Flux<B> listUsers() throws UserRepositoryException {
        String usersPattern = this.userKeyPrefix + "*";
        return Flux.from((Publisher)this.redisClient.connection(operations -> ((RedisKeyReactiveOperations.KeyScanBuilder)((RedisKeyReactiveOperations.KeyScanBuilder)operations.scan().pattern(usersPattern)).count(100L)).build("0").expand(result -> {
            if (result.isFinished()) {
                return Mono.empty();
            }
            return ((RedisKeyReactiveOperations.KeyScanBuilder)((RedisKeyReactiveOperations.KeyScanBuilder)operations.scan().pattern(usersPattern)).count(100L)).build(result.getCursor());
        }).flatMapIterable(result -> result.getKeys()).flatMap(username -> operations.get(username).map(jsonUser -> {
            try {
                return (User)this.mapper.readValue(jsonUser, User.class);
            }
            catch (JsonProcessingException e) {
                throw new UserRepositoryException("Malformed user: " + username, e);
            }
        }))));
    }

    @Override
    public Mono<B> changePassword(LoginCredentials credentials, String rawPassword) throws AuthenticationException, PasswordPolicyException, PasswordException, UserRepositoryException {
        Objects.requireNonNull(credentials);
        Objects.requireNonNull(rawPassword);
        return this.getUser(credentials.getUsername()).flatMap(previousUser -> {
            if (!previousUser.getPassword().matches(credentials.getPassword())) {
                throw new AuthenticationException("Invalid credentials");
            }
            this.passwordPolicy.verify(previousUser, rawPassword);
            previousUser.setPassword((Password<?, ?>)this.passwordEncoder.encode(rawPassword));
            try {
                return this.redisClient.set((Object)(this.userKeyPrefix + credentials.getUsername()), (Object)this.mapper.writeValueAsString(previousUser)).map(result -> {
                    if (result.equals("OK")) {
                        return previousUser;
                    }
                    throw new UserRepositoryException("Error setting user: " + credentials.getUsername());
                });
            }
            catch (JsonProcessingException e) {
                throw new UserRepositoryException(e);
            }
        });
    }

    @Override
    public Mono<B> lockUser(String username) throws UserRepositoryException {
        Objects.requireNonNull(username);
        return this.getUser(username).flatMap(previousUser -> {
            previousUser.setLocked(true);
            try {
                return this.redisClient.set((Object)(this.userKeyPrefix + username), (Object)this.mapper.writeValueAsString(previousUser)).map(result -> {
                    if (result.equals("OK")) {
                        return previousUser;
                    }
                    throw new UserRepositoryException("Error setting user: " + username);
                });
            }
            catch (JsonProcessingException e) {
                throw new UserRepositoryException(e);
            }
        });
    }

    @Override
    public Mono<B> unlockUser(String username) throws UserRepositoryException {
        Objects.requireNonNull(username);
        return this.getUser(username).flatMap(previousUser -> {
            previousUser.setLocked(false);
            try {
                return this.redisClient.set((Object)(this.userKeyPrefix + username), (Object)this.mapper.writeValueAsString(previousUser)).map(result -> {
                    if (result.equals("OK")) {
                        return previousUser;
                    }
                    throw new UserRepositoryException("Error setting user: " + username);
                });
            }
            catch (JsonProcessingException e) {
                throw new UserRepositoryException(e);
            }
        });
    }

    @Override
    public Mono<B> addUserToGroups(String username, String ... groups) throws UserRepositoryException {
        Objects.requireNonNull(username);
        Objects.requireNonNull(groups);
        return this.getUser(username).flatMap(previousUser -> {
            HashSet<String> updatedGroups = new HashSet<String>(previousUser.getGroups());
            Set addedGroups = Arrays.stream(groups).filter(updatedGroups::add).collect(Collectors.toSet());
            if (updatedGroups.size() != previousUser.getGroups().size()) {
                previousUser.setGroups(updatedGroups);
                return Mono.from((Publisher)this.redisClient.connection(operations -> {
                    try {
                        return ((RedisStringReactiveOperations.StringSetBuilder)operations.set().xx()).build((Object)(this.userKeyPrefix + username), (Object)this.mapper.writeValueAsString(previousUser)).switchIfEmpty(Mono.error(() -> new UserRepositoryException("User already exists: " + username))).flatMapMany(result -> {
                            if (result.equals("OK")) {
                                return Flux.fromIterable((Iterable)addedGroups).flatMap(group -> operations.sadd((Object)(this.groupKeyPrefix + group), (Object)username));
                            }
                            throw new UserRepositoryException("Error setting user: " + username);
                        }).then(Mono.just((Object)previousUser));
                    }
                    catch (JsonProcessingException e) {
                        throw new UserRepositoryException(e);
                    }
                }));
            }
            return Mono.just((Object)previousUser);
        });
    }

    @Override
    public Mono<B> removeUserFromGroups(String username, String ... groups) throws UserRepositoryException {
        Objects.requireNonNull(username);
        Objects.requireNonNull(groups);
        return this.getUser(username).flatMap(previousUser -> {
            HashSet<String> updatedGroups = new HashSet<String>(previousUser.getGroups());
            Set removedGroups = Arrays.stream(groups).filter(updatedGroups::remove).collect(Collectors.toSet());
            if (updatedGroups.size() != previousUser.getGroups().size()) {
                previousUser.setGroups(updatedGroups);
                return Mono.from((Publisher)this.redisClient.connection(operations -> {
                    try {
                        return ((RedisStringReactiveOperations.StringSetBuilder)operations.set().xx()).build((Object)(this.userKeyPrefix + username), (Object)this.mapper.writeValueAsString(previousUser)).switchIfEmpty(Mono.error(() -> new UserRepositoryException("User already exists: " + username))).flatMapMany(result -> {
                            if (result.equals("OK")) {
                                return Flux.fromIterable((Iterable)removedGroups).flatMap(group -> operations.srem((Object)(this.groupKeyPrefix + group), (Object)username));
                            }
                            throw new UserRepositoryException("Error setting user: " + username);
                        }).then(Mono.just((Object)previousUser));
                    }
                    catch (JsonProcessingException e) {
                        throw new UserRepositoryException(e);
                    }
                }));
            }
            return Mono.just((Object)previousUser);
        });
    }

    @Override
    public Mono<B> deleteUser(String username) throws UserRepositoryException {
        Objects.requireNonNull(username);
        return this.getUser(username).flatMap(previousUser -> Mono.from((Publisher)this.redisClient.connection(operations -> Flux.fromIterable(previousUser.getGroups()).flatMap(group -> operations.srem((Object)(this.groupKeyPrefix + group), (Object)username)).then(operations.del((Object)(this.userKeyPrefix + username))).thenReturn(previousUser))));
    }

    @Override
    public Mono<B> resolveCredentials(String id) throws SecurityException {
        return this.getUser(id);
    }
}

