/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.authentication.user;

import io.inverno.mod.security.authentication.AuthenticationException;
import io.inverno.mod.security.authentication.LoginCredentials;
import io.inverno.mod.security.authentication.password.PBKDF2Password;
import io.inverno.mod.security.authentication.password.Password;
import io.inverno.mod.security.authentication.password.PasswordException;
import io.inverno.mod.security.authentication.password.PasswordPolicy;
import io.inverno.mod.security.authentication.password.PasswordPolicyException;
import io.inverno.mod.security.authentication.password.RawPassword;
import io.inverno.mod.security.authentication.password.SimplePasswordPolicy;
import io.inverno.mod.security.authentication.user.User;
import io.inverno.mod.security.authentication.user.UserRepository;
import io.inverno.mod.security.authentication.user.UserRepositoryException;
import io.inverno.mod.security.identity.Identity;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class InMemoryUserRepository<A extends Identity, B extends User<A>>
implements UserRepository<A, B> {
    private static final PBKDF2Password.Encoder DEFAULT_PASSWORD_ENCODER = new PBKDF2Password.Encoder();
    private final Map<String, B> users = new ConcurrentHashMap<String, B>();
    private final PasswordPolicy<B, ?> passwordPolicy;
    private final Password.Encoder<?, ?> passwordEncoder;

    public InMemoryUserRepository() {
        this(List.of(), DEFAULT_PASSWORD_ENCODER, new SimplePasswordPolicy());
    }

    public InMemoryUserRepository(Collection<B> users) {
        this(users, DEFAULT_PASSWORD_ENCODER, new SimplePasswordPolicy());
    }

    public InMemoryUserRepository(Collection<B> users, Password.Encoder<?, ?> passwordEncoder, PasswordPolicy<B, ?> passwordPolicy) throws UserRepositoryException {
        this.passwordEncoder = passwordEncoder != null ? passwordEncoder : DEFAULT_PASSWORD_ENCODER;
        SimplePasswordPolicy simplePasswordPolicy = this.passwordPolicy = passwordPolicy != null ? passwordPolicy : new SimplePasswordPolicy();
        if (users != null) {
            users.stream().forEach(user -> this.createUser(user).block());
        }
    }

    public static <A extends Identity, B extends User<A>> Builder<A, B> of() {
        return new Builder();
    }

    public static <A extends Identity, B extends User<A>> Builder<A, B> of(Collection<B> users) {
        return new Builder().users(users);
    }

    public Password.Encoder<?, ?> getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public PasswordPolicy<B, ?> getPasswordPolicy() {
        return this.passwordPolicy;
    }

    @Override
    public Mono<B> createUser(B user) throws UserRepositoryException {
        Objects.requireNonNull(user);
        if (!(((User)user).getPassword() instanceof RawPassword)) {
            throw new UserRepositoryException("User password must be a raw password");
        }
        return Mono.fromSupplier(() -> {
            User previousUser = (User)this.users.get(user.getUsername());
            if (previousUser != null) {
                throw new UserRepositoryException("User already exists: " + user.getUsername());
            }
            this.passwordPolicy.verify(user, user.getPassword().getValue());
            user.setPassword((Password<?, ?>)this.passwordEncoder.encode(user.getPassword().getValue()));
            this.users.put(user.getUsername(), user);
            return user;
        });
    }

    @Override
    public Mono<B> updateUser(B user) {
        Objects.requireNonNull(user);
        return Mono.fromSupplier(() -> {
            User previousUser = (User)this.users.get(user.getUsername());
            if (previousUser == null) {
                return null;
            }
            user.setPassword(previousUser.getPassword());
            user.setGroups(previousUser.getGroups());
            user.setLocked(previousUser.isLocked());
            this.users.put(user.getUsername(), user);
            return user;
        });
    }

    @Override
    public Mono<B> getUser(String username) throws UserRepositoryException {
        Objects.requireNonNull(username);
        return Mono.fromSupplier(() -> (User)this.users.get(username));
    }

    @Override
    public Flux<B> listUsers() throws UserRepositoryException {
        return Flux.fromStream(() -> this.users.values().stream());
    }

    @Override
    public Mono<B> lockUser(String username) throws UserRepositoryException {
        Objects.requireNonNull(username);
        return Mono.fromSupplier(() -> {
            User previousUser = (User)this.users.get(username);
            if (previousUser == null) {
                return null;
            }
            previousUser.setLocked(true);
            this.users.put(previousUser.getUsername(), previousUser);
            return previousUser;
        });
    }

    @Override
    public Mono<B> unlockUser(String username) throws UserRepositoryException {
        Objects.requireNonNull(username);
        return Mono.fromSupplier(() -> {
            User previousUser = (User)this.users.get(username);
            if (previousUser == null) {
                return null;
            }
            previousUser.setLocked(false);
            this.users.put(previousUser.getUsername(), previousUser);
            return previousUser;
        });
    }

    @Override
    public Mono<B> changePassword(LoginCredentials credentials, String rawPassword) throws AuthenticationException, PasswordPolicyException, PasswordException, UserRepositoryException {
        Objects.requireNonNull(credentials);
        Objects.requireNonNull(rawPassword);
        return Mono.fromSupplier(() -> {
            User previousUser = (User)this.users.get(credentials.getUsername());
            if (previousUser == null) {
                return null;
            }
            if (!previousUser.getPassword().matches(credentials.getPassword())) {
                throw new AuthenticationException("Invalid credentials");
            }
            this.passwordPolicy.verify(previousUser, rawPassword);
            previousUser.setPassword((Password<?, ?>)this.passwordEncoder.encode(rawPassword));
            this.users.put(previousUser.getUsername(), previousUser);
            return previousUser;
        });
    }

    @Override
    public Mono<B> addUserToGroups(String username, String ... groups) throws UserRepositoryException {
        Objects.requireNonNull(username);
        Objects.requireNonNull(groups);
        return Mono.fromSupplier(() -> {
            User previousUser = (User)this.users.get(username);
            if (previousUser == null) {
                return null;
            }
            HashSet<String> newGroups = new HashSet<String>(previousUser.getGroups());
            newGroups.addAll(Arrays.asList(groups));
            previousUser.setGroups(newGroups);
            this.users.put(previousUser.getUsername(), previousUser);
            return previousUser;
        });
    }

    @Override
    public Mono<B> removeUserFromGroups(String username, String ... groups) throws UserRepositoryException {
        Objects.requireNonNull(username);
        Objects.requireNonNull(groups);
        return Mono.fromSupplier(() -> {
            User previousUser = (User)this.users.get(username);
            if (previousUser == null) {
                return null;
            }
            HashSet<String> newGroups = new HashSet<String>(previousUser.getGroups());
            newGroups.removeAll(Arrays.asList(groups));
            previousUser.setGroups(newGroups);
            this.users.put(previousUser.getUsername(), previousUser);
            return previousUser;
        });
    }

    @Override
    public Mono<B> deleteUser(String username) throws UserRepositoryException {
        Objects.requireNonNull(username);
        return Mono.fromSupplier(() -> {
            User previousUser = (User)this.users.remove(username);
            if (previousUser == null) {
                return null;
            }
            return previousUser;
        });
    }

    @Override
    public Mono<B> resolveCredentials(String id) throws SecurityException {
        Objects.requireNonNull(id);
        return this.getUser(id);
    }

    public static class Builder<A extends Identity, B extends User<A>> {
        private Set<B> users;
        private PasswordPolicy<B, ?> passwordPolicy;
        private Password.Encoder<?, ?> passwordEncoder;

        private Builder() {
        }

        public Builder<A, B> user(B user) {
            if (user != null) {
                this.users.add(user);
            }
            return this;
        }

        public Builder<A, B> users(Collection<B> users) {
            if (users != null) {
                if (this.users == null) {
                    this.users = new HashSet<B>();
                }
                this.users.addAll(users);
            }
            return this;
        }

        public Builder<A, B> passwordPolicy(PasswordPolicy<B, ?> passwordPolicy) {
            this.passwordPolicy = passwordPolicy;
            return this;
        }

        public Builder<A, B> passwordEncoder(Password.Encoder<?, ?> passwordEncoder) {
            this.passwordEncoder = passwordEncoder;
            return this;
        }

        public InMemoryUserRepository<A, B> build() {
            return new InMemoryUserRepository(this.users, this.passwordEncoder, this.passwordPolicy);
        }
    }
}

