/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.authentication.password;

import io.inverno.mod.security.authentication.LoginCredentials;
import io.inverno.mod.security.authentication.password.PasswordPolicy;
import io.inverno.mod.security.authentication.password.PasswordPolicyException;
import java.util.Objects;

public class SimplePasswordPolicy<A extends LoginCredentials>
implements PasswordPolicy<A, SimplePasswordStrength> {
    public static final int DEFAULT_MINIMUM_PASSWORD_LENGTH = 8;
    public static final int DEFAULT_MAXIMUM_PASSWORD_LENGTH = 64;
    private final int minimumPasswordLength;
    private final int maximumPasswordLength;

    public SimplePasswordPolicy() {
        this(8, 64);
    }

    public SimplePasswordPolicy(int minimumPasswordLength, int maximumPasswordLength) throws IllegalArgumentException {
        if (minimumPasswordLength <= 0) {
            throw new IllegalArgumentException("Minimum password length must be strictly positive");
        }
        if (maximumPasswordLength < minimumPasswordLength) {
            throw new IllegalArgumentException("Maximum password length must greater than minimum password length");
        }
        this.minimumPasswordLength = minimumPasswordLength;
        this.maximumPasswordLength = maximumPasswordLength;
    }

    @Override
    public SimplePasswordStrength verify(A credentials, String rawPassword) throws PasswordPolicyException {
        SimplePasswordStrength strength = new SimplePasswordStrength(Objects.requireNonNull(rawPassword).length());
        if (strength.getScore() < this.minimumPasswordLength) {
            throw new PasswordPolicyException((PasswordPolicy.PasswordStrength)strength, "Password must be at least " + this.minimumPasswordLength + " characters long");
        }
        if (strength.getScore() > this.maximumPasswordLength) {
            throw new PasswordPolicyException((PasswordPolicy.PasswordStrength)strength, "Password must be at most " + this.maximumPasswordLength + " characters long");
        }
        return strength;
    }

    public int getMinimumPasswordLength() {
        return this.minimumPasswordLength;
    }

    public int getMaximumPasswordLength() {
        return this.maximumPasswordLength;
    }

    public static class SimplePasswordStrength
    implements PasswordPolicy.PasswordStrength {
        private final int score;
        private final PasswordPolicy.PasswordStrength.Qualifier qualifier;

        public SimplePasswordStrength(int score) {
            this.score = score;
            this.qualifier = score < 5 ? PasswordPolicy.PasswordStrength.Qualifier.VERY_WEAK : (score < 7 ? PasswordPolicy.PasswordStrength.Qualifier.WEAK : (score < 10 ? PasswordPolicy.PasswordStrength.Qualifier.STRONG : PasswordPolicy.PasswordStrength.Qualifier.VERY_STRONG));
        }

        @Override
        public PasswordPolicy.PasswordStrength.Qualifier getQualifier() {
            return this.qualifier;
        }

        @Override
        public int getScore() {
            return this.score;
        }
    }
}

