/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.authentication.password;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.inverno.mod.security.authentication.password.AbstractPassword;
import io.inverno.mod.security.authentication.password.Password;
import io.inverno.mod.security.authentication.password.PasswordException;
import io.inverno.mod.security.authentication.password.PasswordUtils;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import org.bouncycastle.crypto.generators.SCrypt;

public class SCryptPassword
extends AbstractPassword<SCryptPassword, Encoder> {
    @JsonCreator
    public SCryptPassword(@JsonProperty(value="value") String encoded, @JsonProperty(value="encoder") Encoder encoder) {
        super(encoded, encoder);
    }

    public static class Encoder
    implements Password.Encoder<SCryptPassword, Encoder> {
        public static final int DEFAULT_SALT_LENGTH = 16;
        public static final int DEFAULT_COST_FACTOR = 16384;
        public static final int DEFAULT_BLOCK_SIZE_FACTOR = 8;
        public static final int DEFAULT_PARALLELIZATION_FACTOR = 1;
        public static final int DEFAULT_HASH_LENGTH = 32;
        @JsonIgnore
        private final int saltLength;
        @JsonIgnore
        private final int costFactor;
        @JsonIgnore
        private final int blockSizeFactor;
        @JsonIgnore
        private final int parallelizationFactor;
        @JsonIgnore
        private final int hashLength;
        @JsonIgnore
        private final SecureRandom secureRandom;

        public Encoder() {
            this(16, 16384, 8, 1, 32, PasswordUtils.DEFAULT_SECURE_RANDOM);
        }

        @JsonCreator
        public Encoder(@JsonProperty(value="saltLength") int saltLength, @JsonProperty(value="costFactor") int costFactor, @JsonProperty(value="blockSizeFactor") int blockSizeFactor, @JsonProperty(value="parallelizationFactor") int parallelizationFactor, @JsonProperty(value="hashLength") int hashLength) throws IllegalArgumentException {
            this(saltLength, costFactor, blockSizeFactor, parallelizationFactor, hashLength, PasswordUtils.DEFAULT_SECURE_RANDOM);
        }

        public Encoder(int saltLength, int costFactor, int blockSizeFactor, int parallelizationFactor, int hashLength, SecureRandom secureRandom) throws IllegalArgumentException {
            if (costFactor <= 1 || (costFactor & costFactor - 1) != 0) {
                throw new IllegalArgumentException("Cost factor must be > 1 and a power of 2");
            }
            if (blockSizeFactor == 1 && costFactor >= 65536) {
                throw new IllegalArgumentException("Cost factor must be > 1 and < 65536");
            }
            if (blockSizeFactor < 1) {
                throw new IllegalArgumentException("Block size factor must be >= 1");
            }
            int maxParallel = Integer.MAX_VALUE / (128 * blockSizeFactor * 8);
            if (parallelizationFactor < 1 || parallelizationFactor > maxParallel) {
                throw new IllegalArgumentException("Parallelisation factor must be >= 1 and <= " + maxParallel + " (based on block size r of " + blockSizeFactor + ")");
            }
            if (hashLength < 1) {
                throw new IllegalArgumentException("Generated hash length must be >= 1.");
            }
            this.saltLength = saltLength;
            this.costFactor = costFactor;
            this.blockSizeFactor = blockSizeFactor;
            this.parallelizationFactor = parallelizationFactor;
            this.hashLength = hashLength;
            this.secureRandom = secureRandom;
        }

        @JsonProperty(value="saltLength")
        public int getSaltLength() {
            return this.saltLength;
        }

        @JsonProperty(value="costFactor")
        public int getCostFactor() {
            return this.costFactor;
        }

        @JsonProperty(value="blockSizeFactor")
        public int getBlockSizeFactor() {
            return this.blockSizeFactor;
        }

        @JsonProperty(value="parallelizationFactor")
        public int getParallelizationFactor() {
            return this.parallelizationFactor;
        }

        @JsonProperty(value="hashLength")
        public int getHashLength() {
            return this.hashLength;
        }

        @JsonIgnore
        public SecureRandom getSecureRandom() {
            return this.secureRandom;
        }

        @Override
        public SCryptPassword recover(String encoded) throws PasswordException {
            return new SCryptPassword(encoded, this);
        }

        @Override
        public SCryptPassword encode(String raw) throws PasswordException {
            byte[] salt = PasswordUtils.generateSalt(this.secureRandom, this.saltLength);
            return new SCryptPassword(PasswordUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(this.encode(raw.getBytes(), salt)), this);
        }

        private byte[] encode(byte[] raw, byte[] salt) {
            byte[] hash = SCrypt.generate((byte[])raw, (byte[])salt, (int)this.costFactor, (int)this.blockSizeFactor, (int)this.parallelizationFactor, (int)this.hashLength);
            byte[] encoded = new byte[this.saltLength + hash.length];
            System.arraycopy(salt, 0, encoded, 0, this.saltLength);
            System.arraycopy(hash, 0, encoded, this.saltLength, hash.length);
            return encoded;
        }

        @Override
        public boolean matches(String raw, String encoded) throws PasswordException {
            byte[] encodedBytes = Base64.getUrlDecoder().decode(encoded);
            byte[] salt = new byte[this.saltLength];
            System.arraycopy(encodedBytes, 0, salt, 0, this.saltLength);
            return MessageDigest.isEqual(this.encode(raw.getBytes(), salt), encodedBytes);
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + this.saltLength;
            hash = 29 * hash + this.costFactor;
            hash = 29 * hash + this.blockSizeFactor;
            hash = 29 * hash + this.parallelizationFactor;
            hash = 29 * hash + this.hashLength;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Encoder other = (Encoder)obj;
            if (this.saltLength != other.saltLength) {
                return false;
            }
            if (this.costFactor != other.costFactor) {
                return false;
            }
            if (this.blockSizeFactor != other.blockSizeFactor) {
                return false;
            }
            if (this.parallelizationFactor != other.parallelizationFactor) {
                return false;
            }
            return this.hashLength == other.hashLength;
        }
    }
}

