/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.authentication.password;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.inverno.mod.security.authentication.password.AbstractPassword;
import io.inverno.mod.security.authentication.password.Password;
import io.inverno.mod.security.authentication.password.PasswordException;
import java.util.Objects;

public class RawPassword
extends AbstractPassword<RawPassword, Encoder> {
    protected static final Encoder RAW_PASSWORD_ENCODER = new Encoder();

    public RawPassword(String raw) {
        super(raw, RAW_PASSWORD_ENCODER);
    }

    protected RawPassword(String raw, Encoder encoder) {
        super(raw, encoder);
    }

    @Override
    @JsonIgnore
    public String getValue() {
        return super.getValue();
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + Objects.hashCode(this.value);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RawPassword other = (RawPassword)obj;
        return Objects.equals(this.value, other.value);
    }

    public static class Encoder
    implements Password.Encoder<RawPassword, Encoder> {
        @Override
        public RawPassword recover(String encoded) throws PasswordException {
            return new RawPassword(encoded, this);
        }

        @Override
        public RawPassword encode(String raw) throws PasswordException {
            return new RawPassword(raw);
        }

        @Override
        public boolean matches(String raw, String encoded) throws PasswordException {
            return raw.equals(encoded);
        }
    }
}

