/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.authentication.password;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.inverno.mod.security.authentication.password.PasswordException;
import io.inverno.mod.security.authentication.password.RawPassword;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.MINIMAL_CLASS, include=JsonTypeInfo.As.PROPERTY)
public interface Password<A extends Password<A, B>, B extends Encoder<A, B>> {
    @JsonProperty(value="value")
    public String getValue();

    @JsonProperty(value="encoder")
    public B getEncoder();

    default public boolean matches(String raw) throws PasswordException {
        return this.getEncoder().matches(raw, this.getValue());
    }

    default public boolean matches(Password<?, ?> other) throws PasswordException {
        return this.getEncoder().matches((Password)this, other);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonTypeInfo(use=JsonTypeInfo.Id.MINIMAL_CLASS, include=JsonTypeInfo.As.PROPERTY)
    public static interface Encoder<A extends Password<A, B>, B extends Encoder<A, B>> {
        public A recover(String var1) throws PasswordException;

        public A encode(String var1) throws PasswordException;

        public boolean matches(String var1, String var2) throws PasswordException;

        default public boolean matches(A password, Password<?, ?> other) throws PasswordException {
            if (password != null && other != null) {
                if (other instanceof RawPassword) {
                    return this.matches(other.getValue(), password.getValue());
                }
                if (password instanceof RawPassword) {
                    return other.matches(password.getValue());
                }
                if (password.getClass().equals(other.getClass())) {
                    return password.getValue().equals(other.getValue());
                }
                throw new PasswordException("Incompatible passwords: " + password.getClass().getCanonicalName() + " and " + other.getClass().getCanonicalName());
            }
            return false;
        }
    }
}

