/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.authentication.password;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.inverno.mod.security.authentication.password.AbstractPassword;
import io.inverno.mod.security.authentication.password.Password;
import io.inverno.mod.security.authentication.password.PasswordException;
import io.inverno.mod.security.authentication.password.PasswordUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.Objects;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PBKDF2Password
extends AbstractPassword<PBKDF2Password, Encoder> {
    @JsonCreator
    public PBKDF2Password(@JsonProperty(value="value") String encoded, @JsonProperty(value="encoder") Encoder encoder) {
        super(encoded, encoder);
    }

    public static class Encoder
    implements Password.Encoder<PBKDF2Password, Encoder> {
        public static final String PRF_SHA256 = "HmacSHA256";
        public static final String PRF_SHA384 = "HmacSHA384";
        public static final String PRF_SHA512 = "HmacSHA512";
        public static final String DEFAULT_PRF = "HmacSHA256";
        public static final int DEFAULT_SALT_LENGTH = 16;
        public static final int DEFAULT_HASH_LENGTH = 32;
        public static final int DEFAULT_ITERATION_COUNT = 1000;
        @JsonIgnore
        private final String prf;
        @JsonIgnore
        private final int iterationCount;
        @JsonIgnore
        private final int saltLength;
        @JsonIgnore
        private final int hashLength;
        @JsonIgnore
        private final SecureRandom secureRandom;

        public Encoder() {
            this("HmacSHA256", 1000, 16, 32, PasswordUtils.DEFAULT_SECURE_RANDOM);
        }

        public Encoder(String prf) {
            this(prf, 1000, 16, 32, PasswordUtils.DEFAULT_SECURE_RANDOM);
        }

        @JsonCreator
        public Encoder(@JsonProperty(value="prf") String prf, @JsonProperty(value="iterationCount") int iterationCount, @JsonProperty(value="saltLength") int saltLength, @JsonProperty(value="hashLength") int hashLength) {
            this(prf, iterationCount, saltLength, hashLength, PasswordUtils.DEFAULT_SECURE_RANDOM);
        }

        public Encoder(String prf, int iterationCount, int saltLength, int hashLength, SecureRandom secureRandom) {
            this.prf = Objects.requireNonNull(prf);
            this.saltLength = saltLength;
            this.iterationCount = iterationCount;
            this.hashLength = hashLength;
            this.secureRandom = Objects.requireNonNull(secureRandom);
        }

        @JsonProperty(value="prf")
        public String getPseudoRandomFunction() {
            return this.prf;
        }

        @JsonProperty(value="iterationCount")
        public int getIterationCount() {
            return this.iterationCount;
        }

        @JsonProperty(value="saltLength")
        public int getSaltLength() {
            return this.saltLength;
        }

        @JsonProperty(value="hashLength")
        public int getHashLength() {
            return this.hashLength;
        }

        @JsonIgnore
        public SecureRandom getSecureRandom() {
            return this.secureRandom;
        }

        @Override
        public PBKDF2Password recover(String encoded) throws PasswordException {
            return new PBKDF2Password(encoded, this);
        }

        @Override
        public PBKDF2Password encode(String raw) throws PasswordException {
            byte[] salt = PasswordUtils.generateSalt(this.secureRandom, this.saltLength);
            return new PBKDF2Password(PasswordUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(this.encode(raw.toCharArray(), salt)), this);
        }

        private byte[] encode(char[] raw, byte[] salt) throws PasswordException {
            try {
                SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2With" + this.prf);
                PBEKeySpec keySpec = new PBEKeySpec(raw, salt, this.iterationCount, this.hashLength * 8);
                byte[] hash = skf.generateSecret(keySpec).getEncoded();
                byte[] encoded = new byte[salt.length + hash.length];
                System.arraycopy(salt, 0, encoded, 0, salt.length);
                System.arraycopy(hash, 0, encoded, salt.length, hash.length);
                return encoded;
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                throw new PasswordException(e);
            }
        }

        @Override
        public boolean matches(String raw, String encoded) throws PasswordException {
            byte[] encodedBytes = Base64.getUrlDecoder().decode(encoded);
            byte[] salt = new byte[this.saltLength];
            System.arraycopy(encodedBytes, 0, salt, 0, this.saltLength);
            return MessageDigest.isEqual(this.encode(raw.toCharArray(), salt), encodedBytes);
        }

        public int hashCode() {
            int hash = 7;
            hash = 41 * hash + Objects.hashCode(this.prf);
            hash = 41 * hash + this.iterationCount;
            hash = 41 * hash + this.saltLength;
            hash = 41 * hash + this.hashLength;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Encoder other = (Encoder)obj;
            if (this.iterationCount != other.iterationCount) {
                return false;
            }
            if (this.saltLength != other.saltLength) {
                return false;
            }
            if (this.hashLength != other.hashLength) {
                return false;
            }
            return Objects.equals(this.prf, other.prf);
        }
    }
}

