/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.authentication.password;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.inverno.mod.security.authentication.password.AbstractPassword;
import io.inverno.mod.security.authentication.password.Password;
import io.inverno.mod.security.authentication.password.PasswordException;
import io.inverno.mod.security.authentication.password.PasswordUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;

public class MessageDigestPassword
extends AbstractPassword<MessageDigestPassword, Encoder> {
    @JsonCreator
    public MessageDigestPassword(@JsonProperty(value="value") String encoded, @JsonProperty(value="encoder") Encoder encoder) {
        super(encoded, encoder);
    }

    public static class Encoder
    implements Password.Encoder<MessageDigestPassword, Encoder> {
        public static final String DEFAULT_ALGORITHM = "SHA-512";
        public static final byte[] DEFAULT_SECRET = new byte[0];
        public static final int DEFAULT_SALT_LENGTH = 16;
        @JsonIgnore
        private final String algorithm;
        @JsonIgnore
        private final byte[] secret;
        @JsonIgnore
        private final int saltLength;
        @JsonIgnore
        private final SecureRandom secureRandom;
        @JsonIgnore
        private MessageDigest digest;

        public Encoder() {
            this(DEFAULT_ALGORITHM, DEFAULT_SECRET, 16, PasswordUtils.DEFAULT_SECURE_RANDOM);
        }

        public Encoder(String algorithm) {
            this(algorithm, DEFAULT_SECRET, 16, PasswordUtils.DEFAULT_SECURE_RANDOM);
        }

        public Encoder(String algorithm, byte[] secret) {
            this(algorithm, secret, 16, PasswordUtils.DEFAULT_SECURE_RANDOM);
        }

        @JsonCreator
        public Encoder(@JsonProperty(value="algorithm") String algorithm, @JsonProperty(value="secret") byte[] secret, @JsonProperty(value="saltLength") int saltLength) {
            this(algorithm, secret, saltLength, PasswordUtils.DEFAULT_SECURE_RANDOM);
        }

        public Encoder(String algorithm, byte[] secret, int saltLength, SecureRandom secureRandom) {
            this.algorithm = Objects.requireNonNull(algorithm);
            this.secret = secret != null ? secret : DEFAULT_SECRET;
            this.saltLength = saltLength;
            this.secureRandom = secureRandom != null ? secureRandom : PasswordUtils.DEFAULT_SECURE_RANDOM;
        }

        @JsonProperty(value="algorithm")
        public String getAlgorithm() {
            return this.algorithm;
        }

        @JsonProperty(value="secret")
        public byte[] getSecret() {
            return this.secret;
        }

        @JsonProperty(value="saltLength")
        public int getSaltLength() {
            return this.saltLength;
        }

        @JsonIgnore
        public SecureRandom getSecureRandom() {
            return this.secureRandom;
        }

        @Override
        public MessageDigestPassword recover(String encoded) throws PasswordException {
            return new MessageDigestPassword(encoded, this);
        }

        @Override
        public MessageDigestPassword encode(String raw) throws PasswordException {
            byte[] salt = PasswordUtils.generateSalt(this.secureRandom, this.saltLength);
            return new MessageDigestPassword(PasswordUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(this.encode(raw.getBytes(), salt)), this);
        }

        private byte[] encode(byte[] raw, byte[] salt) throws PasswordException {
            if (this.digest == null) {
                try {
                    this.digest = MessageDigest.getInstance(this.algorithm);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new PasswordException(e);
                }
            }
            byte[] input = new byte[this.secret.length + salt.length + raw.length];
            System.arraycopy(this.secret, 0, input, 0, this.secret.length);
            System.arraycopy(salt, 0, input, this.secret.length, salt.length);
            System.arraycopy(raw, 0, input, this.secret.length + salt.length, raw.length);
            byte[] hash = this.digest.digest(input);
            byte[] encoded = new byte[salt.length + hash.length];
            System.arraycopy(salt, 0, encoded, 0, salt.length);
            System.arraycopy(hash, 0, encoded, salt.length, hash.length);
            return encoded;
        }

        @Override
        public boolean matches(String raw, String encoded) throws PasswordException {
            byte[] encodedBytes = Base64.getUrlDecoder().decode(encoded);
            byte[] salt = new byte[this.saltLength];
            System.arraycopy(encodedBytes, 0, salt, 0, this.saltLength);
            return MessageDigest.isEqual(this.encode(raw.getBytes(), salt), encodedBytes);
        }

        public int hashCode() {
            int hash = 3;
            hash = 19 * hash + Objects.hashCode(this.algorithm);
            hash = 19 * hash + Arrays.hashCode(this.secret);
            hash = 19 * hash + this.saltLength;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Encoder other = (Encoder)obj;
            if (this.saltLength != other.saltLength) {
                return false;
            }
            if (!Objects.equals(this.algorithm, other.algorithm)) {
                return false;
            }
            return Arrays.equals(this.secret, other.secret);
        }
    }
}

