/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.authentication.password;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.inverno.mod.security.authentication.password.AbstractPassword;
import io.inverno.mod.security.authentication.password.Password;
import io.inverno.mod.security.authentication.password.PasswordException;
import io.inverno.mod.security.authentication.password.PasswordUtils;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import org.bouncycastle.crypto.generators.BCrypt;

public class BCryptPassword
extends AbstractPassword<BCryptPassword, Encoder> {
    @JsonCreator
    public BCryptPassword(@JsonProperty(value="value") String encoded, @JsonProperty(value="encoder") Encoder encoder) {
        super(encoded, encoder);
    }

    public static class Encoder
    implements Password.Encoder<BCryptPassword, Encoder> {
        public static final int DEFAULT_COST = 10;
        public static final int SALT_LENGTH = 16;
        @JsonIgnore
        private final int cost;
        @JsonIgnore
        private final int saltLength;
        @JsonIgnore
        private SecureRandom secureRandom;

        public Encoder() {
            this(10, 16, PasswordUtils.DEFAULT_SECURE_RANDOM);
        }

        @JsonCreator
        public Encoder(@JsonProperty(value="cost") int cost, @JsonProperty(value="saltLength") int saltLength) throws IllegalArgumentException {
            this(cost, saltLength, PasswordUtils.DEFAULT_SECURE_RANDOM);
        }

        public Encoder(int cost, int saltLength, SecureRandom secureRandom) throws IllegalArgumentException {
            if (cost < 4 || cost > 31) {
                throw new IllegalArgumentException("Invalid cost parameter " + cost + " which must be between 4 and 31 inclusive");
            }
            this.cost = cost;
            this.saltLength = saltLength;
            this.secureRandom = secureRandom != null ? secureRandom : PasswordUtils.DEFAULT_SECURE_RANDOM;
        }

        @JsonProperty(value="cost")
        public int getCost() {
            return this.cost;
        }

        public int getSaltLength() {
            return this.saltLength;
        }

        @JsonIgnore
        public SecureRandom getSecureRandom() {
            return this.secureRandom;
        }

        @Override
        public BCryptPassword recover(String encoded) throws PasswordException {
            return new BCryptPassword(encoded, this);
        }

        @Override
        public BCryptPassword encode(String raw) throws PasswordException {
            byte[] salt = PasswordUtils.generateSalt(this.secureRandom, 16);
            return new BCryptPassword(PasswordUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(this.encode(raw.getBytes(), salt)), this);
        }

        private byte[] encode(byte[] raw, byte[] salt) {
            byte[] hash = BCrypt.generate((byte[])raw, (byte[])salt, (int)this.cost);
            byte[] encoded = new byte[16 + hash.length];
            System.arraycopy(salt, 0, encoded, 0, 16);
            System.arraycopy(hash, 0, encoded, 16, hash.length);
            return encoded;
        }

        @Override
        public boolean matches(String raw, String encoded) throws PasswordException {
            byte[] encodedBytes = Base64.getUrlDecoder().decode(encoded);
            byte[] salt = new byte[16];
            System.arraycopy(encodedBytes, 0, salt, 0, 16);
            return MessageDigest.isEqual(this.encode(raw.getBytes(), salt), encodedBytes);
        }

        public int hashCode() {
            int hash = 3;
            hash = 97 * hash + this.cost;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Encoder other = (Encoder)obj;
            return this.cost == other.cost;
        }
    }
}

