/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.authentication.password;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.inverno.mod.security.authentication.password.AbstractPassword;
import io.inverno.mod.security.authentication.password.Password;
import io.inverno.mod.security.authentication.password.PasswordException;
import io.inverno.mod.security.authentication.password.PasswordUtils;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Scanner;
import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.crypto.params.Argon2Parameters;

public class Argon2Password
extends AbstractPassword<Argon2Password, Encoder> {
    @JsonCreator
    public Argon2Password(@JsonProperty(value="value") String encoded, @JsonProperty(value="encoder") Encoder encoder) {
        super(encoded, encoder);
    }

    public static class Encoder
    implements Password.Encoder<Argon2Password, Encoder> {
        public static final HashType DEFAULT_TYPE = HashType.I;
        public static final int DEFAULT_SALT_LENGTH = 16;
        public static final int DEFAULT_HASH_LENGTH = 32;
        public static final int DEFAULT_PARALLELISM = 1;
        public static final int DEFAULT_MEMORY = 12;
        public static final int DEFAULT_ITERATION_COUNT = 3;
        @JsonIgnore
        private final HashType type;
        @JsonIgnore
        private final int saltLength;
        @JsonIgnore
        private final int hashLength;
        @JsonIgnore
        private final int parallelism;
        @JsonIgnore
        private final int memory;
        @JsonIgnore
        private final int iterationCount;
        @JsonIgnore
        private final byte[] secret;
        @JsonIgnore
        private final byte[] additionalData;
        @JsonIgnore
        private final SecureRandom secureRandom;

        public Encoder() {
            this(DEFAULT_TYPE, 16, 32, 1, 3, 3, null, null, PasswordUtils.DEFAULT_SECURE_RANDOM);
        }

        public Encoder(HashType type, int saltLength, int hashLength, int parallelism, int memory, int iterationCount) {
            this(type, saltLength, hashLength, parallelism, memory, iterationCount, null, null, PasswordUtils.DEFAULT_SECURE_RANDOM);
        }

        @JsonCreator
        public Encoder(@JsonProperty(value="type") HashType type, @JsonProperty(value="saltLength") int saltLength, @JsonProperty(value="hashLength") int hashLength, @JsonProperty(value="parallelism") int parallelism, @JsonProperty(value="memory") int memory, @JsonProperty(value="iterationCount") int iterationCount, @JsonProperty(value="secret") byte[] secret, @JsonProperty(value="additionalData") byte[] additionalData) {
            this(type, saltLength, hashLength, parallelism, memory, iterationCount, secret, additionalData, PasswordUtils.DEFAULT_SECURE_RANDOM);
        }

        public Encoder(HashType type, int saltLength, int hashLength, int parallelism, int memory, int iterationCount, byte[] secret, byte[] additionalData, SecureRandom secureRandom) {
            this.type = Objects.requireNonNull(type);
            this.saltLength = saltLength;
            this.hashLength = hashLength;
            this.parallelism = parallelism;
            this.memory = memory;
            this.iterationCount = iterationCount;
            this.secret = secret;
            this.additionalData = additionalData;
            this.secureRandom = secureRandom;
        }

        @JsonProperty(value="type")
        public HashType getType() {
            return this.type;
        }

        @JsonProperty(value="saltLength")
        public int getSaltLength() {
            return this.saltLength;
        }

        @JsonProperty(value="hashLength")
        public int getHashLength() {
            return this.hashLength;
        }

        @JsonProperty(value="parallelism")
        public int getParallelism() {
            return this.parallelism;
        }

        @JsonProperty(value="memory")
        public int getMemory() {
            return this.memory;
        }

        @JsonProperty(value="iterationCount")
        public int getIterationCount() {
            return this.iterationCount;
        }

        @JsonProperty(value="secret")
        public byte[] getSecret() {
            return this.secret;
        }

        @JsonProperty(value="additionalData")
        public byte[] getAdditionalData() {
            return this.additionalData;
        }

        @JsonIgnore
        public SecureRandom getSecureRandom() {
            return this.secureRandom;
        }

        @Override
        public Argon2Password recover(String encoded) throws PasswordException {
            return new Argon2Password(encoded, this);
        }

        @Override
        public Argon2Password encode(String raw) throws PasswordException {
            byte[] salt = PasswordUtils.generateSalt(this.secureRandom, this.saltLength);
            Argon2Parameters.Builder parametersBuilder = new Argon2Parameters.Builder(this.type.getId()).withVersion(19).withSalt(salt).withParallelism(this.parallelism).withMemoryAsKB(this.memory).withIterations(this.iterationCount);
            if (this.secret != null) {
                parametersBuilder = parametersBuilder.withSecret(this.secret);
            }
            if (this.additionalData != null) {
                parametersBuilder = parametersBuilder.withAdditional(this.additionalData);
            }
            byte[] hash = this.encode(raw.getBytes(), parametersBuilder.build());
            StringBuilder encoded = new StringBuilder();
            encoded.append('$').append(this.type.getName());
            encoded.append("$v=").append(19);
            encoded.append('$').append("m=").append(this.memory).append(",t=").append(this.iterationCount).append(",p=").append(this.parallelism);
            encoded.append('$').append(PasswordUtils.BASE64_NOPAD_ENCODER.encodeToString(salt));
            encoded.append('$').append(PasswordUtils.BASE64_NOPAD_ENCODER.encodeToString(hash));
            return new Argon2Password(encoded.toString(), this);
        }

        private byte[] encode(byte[] raw, Argon2Parameters parameters) throws PasswordException {
            Argon2BytesGenerator generator = new Argon2BytesGenerator();
            generator.init(parameters);
            byte[] hash = new byte[this.hashLength];
            generator.generateBytes(raw, hash);
            return hash;
        }

        @Override
        public boolean matches(String raw, String encoded) throws PasswordException {
            Argon2Parameters decoded_parameters;
            byte[] decoded_hash;
            Scanner scanner = new Scanner(encoded).useDelimiter("\\$|,");
            try {
                Argon2Parameters.Builder parametersBuilder;
                String currentPart = scanner.next();
                try {
                    parametersBuilder = new Argon2Parameters.Builder(HashType.fromName(currentPart).getId());
                }
                catch (IllegalArgumentException e) {
                    throw new PasswordException("Invalid Argon2 encoded hash", e);
                }
                currentPart = scanner.next();
                if (currentPart.startsWith("v=")) {
                    parametersBuilder.withVersion(Integer.parseInt(currentPart.substring(2)));
                    currentPart = scanner.next();
                }
                if (!currentPart.startsWith("m=")) {
                    throw new PasswordException("Invalid Argon2 encoded hash");
                }
                parametersBuilder.withMemoryAsKB(Integer.parseInt(currentPart.substring(2)));
                currentPart = scanner.next();
                if (!currentPart.startsWith("t=")) {
                    throw new PasswordException("Invalid Argon2 encoded hash");
                }
                parametersBuilder.withIterations(Integer.parseInt(currentPart.substring(2)));
                currentPart = scanner.next();
                if (!currentPart.startsWith("p=")) {
                    throw new PasswordException("Invalid Argon2 encoded hash");
                }
                parametersBuilder.withParallelism(Integer.parseInt(currentPart.substring(2)));
                parametersBuilder.withSalt(Base64.getDecoder().decode(scanner.next()));
                decoded_hash = Base64.getDecoder().decode(scanner.next());
                if (this.secret != null) {
                    parametersBuilder = parametersBuilder.withSecret(this.secret);
                }
                if (this.additionalData != null) {
                    parametersBuilder = parametersBuilder.withAdditional(this.additionalData);
                }
                decoded_parameters = parametersBuilder.build();
            }
            catch (NoSuchElementException e) {
                throw new PasswordException("Invalid Argon2 encoded hash", e);
            }
            return MessageDigest.isEqual(this.encode(raw.getBytes(), decoded_parameters), decoded_hash);
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + Objects.hashCode((Object)this.type);
            hash = 79 * hash + this.saltLength;
            hash = 79 * hash + this.hashLength;
            hash = 79 * hash + this.parallelism;
            hash = 79 * hash + this.memory;
            hash = 79 * hash + this.iterationCount;
            hash = 79 * hash + Arrays.hashCode(this.secret);
            hash = 79 * hash + Arrays.hashCode(this.additionalData);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Encoder other = (Encoder)obj;
            if (this.saltLength != other.saltLength) {
                return false;
            }
            if (this.hashLength != other.hashLength) {
                return false;
            }
            if (this.parallelism != other.parallelism) {
                return false;
            }
            if (this.memory != other.memory) {
                return false;
            }
            if (this.iterationCount != other.iterationCount) {
                return false;
            }
            if (this.type != other.type) {
                return false;
            }
            if (!Arrays.equals(this.secret, other.secret)) {
                return false;
            }
            return Arrays.equals(this.additionalData, other.additionalData);
        }

        public static enum HashType {
            D(0, "argon2d"),
            I(1, "argon2i"),
            ID(2, "argon2id");

            private final int id;
            private final String name;

            private HashType(int id, String name) {
                this.id = id;
                this.name = name;
            }

            public int getId() {
                return this.id;
            }

            public String getName() {
                return this.name;
            }

            public static HashType fromId(int id) throws IllegalArgumentException {
                switch (id) {
                    case 0: {
                        return D;
                    }
                    case 1: {
                        return I;
                    }
                    case 2: {
                        return ID;
                    }
                }
                throw new IllegalArgumentException("Unsupported type with id: " + id);
            }

            public static HashType fromName(String name) throws IllegalArgumentException {
                switch (name) {
                    case "argon2d": {
                        return D;
                    }
                    case "argon2i": {
                        return I;
                    }
                    case "argon2id": {
                        return ID;
                    }
                }
                throw new IllegalArgumentException("Unsupported type with name: " + name);
            }
        }
    }
}

