/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.authentication;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.inverno.mod.security.SecurityException;
import io.inverno.mod.security.authentication.Authentication;
import io.inverno.mod.security.authentication.PrincipalCredentials;
import io.inverno.mod.security.internal.authentication.GenericPrincipalAuthentication;

@JsonDeserialize(as=GenericPrincipalAuthentication.class)
public interface PrincipalAuthentication
extends Authentication {
    @JsonProperty(value="username")
    public String getUsername();

    public static PrincipalAuthentication of(String username) {
        return new GenericPrincipalAuthentication(username, true);
    }

    public static PrincipalAuthentication of(String username, SecurityException cause) {
        GenericPrincipalAuthentication authentication = new GenericPrincipalAuthentication(username, false);
        authentication.setCause(cause);
        return authentication;
    }

    public static PrincipalAuthentication of(PrincipalCredentials credentials) {
        return new GenericPrincipalAuthentication(credentials.getUsername(), !credentials.isLocked());
    }
}

