/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.authentication;

import io.inverno.mod.security.authentication.AuthenticationException;
import io.inverno.mod.security.authentication.CredentialsResolver;
import io.inverno.mod.security.authentication.LoginCredentials;
import io.inverno.mod.security.authentication.password.Password;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import reactor.core.publisher.Mono;

public class InMemoryLoginCredentialsResolver
implements CredentialsResolver<LoginCredentials> {
    private final Map<String, LoginCredentials> credentials = new ConcurrentHashMap<String, LoginCredentials>();

    public InMemoryLoginCredentialsResolver() {
    }

    public InMemoryLoginCredentialsResolver(List<LoginCredentials> credentials) {
        if (credentials != null) {
            credentials.stream().forEach(c -> this.credentials.put(c.getUsername(), (LoginCredentials)c));
        }
    }

    public void put(String username, Password<?, ?> password) {
        this.credentials.put(username, LoginCredentials.of(username, password));
    }

    public void put(LoginCredentials credentials) {
        this.credentials.put(credentials.getUsername(), credentials);
    }

    public LoginCredentials remove(String username) {
        return this.credentials.remove(username);
    }

    @Override
    public Mono<LoginCredentials> resolveCredentials(String id) throws AuthenticationException {
        return Mono.fromSupplier(() -> this.credentials.get(id));
    }
}

